// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.PutInventoryResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutInventoryOperationDeserializer: HttpDeserialize<PutInventoryResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PutInventoryResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutInventoryError(context, call)
        }
        val builder = PutInventoryResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutInventoryOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPutInventoryError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ItemSizeLimitExceededException" -> ItemSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidItemContentException" -> InvalidItemContentExceptionDeserializer().deserialize(context, wrappedCall)
        "ItemContentMismatchException" -> ItemContentMismatchExceptionDeserializer().deserialize(context, wrappedCall)
        "CustomSchemaCountLimitExceededException" -> CustomSchemaCountLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedInventorySchemaVersionException" -> UnsupportedInventorySchemaVersionExceptionDeserializer().deserialize(context, wrappedCall)
        "UnsupportedInventoryItemContextException" -> UnsupportedInventoryItemContextExceptionDeserializer().deserialize(context, wrappedCall)
        "TotalSizeLimitExceededException" -> TotalSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        "InvalidInventoryItemContextException" -> InvalidInventoryItemContextExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidInstanceId" -> InvalidInstanceIdDeserializer().deserialize(context, wrappedCall)
        "SubTypeCountLimitExceededException" -> SubTypeCountLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidTypeNameException" -> InvalidTypeNameExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutInventoryOperationBody(builder: PutInventoryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Message"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MESSAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
