// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.PutComplianceItemsResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class PutComplianceItemsOperationDeserializer: HttpDeserialize<PutComplianceItemsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PutComplianceItemsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutComplianceItemsError(context, call)
        }
        val builder = PutComplianceItemsResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPutComplianceItemsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ItemSizeLimitExceededException" -> ItemSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ComplianceTypeCountLimitExceededException" -> ComplianceTypeCountLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidItemContentException" -> InvalidItemContentExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidResourceId" -> InvalidResourceIdDeserializer().deserialize(context, wrappedCall)
        "TotalSizeLimitExceededException" -> TotalSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        "InvalidResourceType" -> InvalidResourceTypeDeserializer().deserialize(context, wrappedCall)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
