// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowExecutionResponse
import aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionStatus
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetMaintenanceWindowExecutionOperationDeserializer: HttpDeserialize<GetMaintenanceWindowExecutionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetMaintenanceWindowExecutionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetMaintenanceWindowExecutionError(context, call)
        }
        val builder = GetMaintenanceWindowExecutionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetMaintenanceWindowExecutionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetMaintenanceWindowExecutionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DoesNotExistException" -> DoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMaintenanceWindowExecutionOperationBody(builder: GetMaintenanceWindowExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndTime"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val STATUSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusDetails"))
    val TASKIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TaskIds"))
    val WINDOWEXECUTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WindowExecutionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDTIME_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSDETAILS_DESCRIPTOR)
        field(TASKIDS_DESCRIPTOR)
        field(WINDOWEXECUTIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { MaintenanceWindowExecutionStatus.fromValue(it) }
                STATUSDETAILS_DESCRIPTOR.index -> builder.statusDetails = deserializeString()
                TASKIDS_DESCRIPTOR.index -> builder.taskIds =
                    deserializer.deserializeList(TASKIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                WINDOWEXECUTIONID_DESCRIPTOR.index -> builder.windowExecutionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
