// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.AttachmentContent
import aws.sdk.kotlin.services.ssm.model.DocumentFormat
import aws.sdk.kotlin.services.ssm.model.DocumentRequires
import aws.sdk.kotlin.services.ssm.model.DocumentStatus
import aws.sdk.kotlin.services.ssm.model.DocumentType
import aws.sdk.kotlin.services.ssm.model.GetDocumentResponse
import aws.sdk.kotlin.services.ssm.model.ReviewStatus
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetDocumentOperationDeserializer: HttpDeserialize<GetDocumentResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetDocumentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetDocumentError(context, call)
        }
        val builder = GetDocumentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDocumentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetDocumentError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidDocumentVersion" -> InvalidDocumentVersionDeserializer().deserialize(context, wrappedCall)
        "InvalidDocument" -> InvalidDocumentDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDocumentOperationBody(builder: GetDocumentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ATTACHMENTSCONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AttachmentsContent"))
    val CONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Content"))
    val CREATEDDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedDate"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DisplayName"))
    val DOCUMENTFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DocumentFormat"))
    val DOCUMENTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DocumentType"))
    val DOCUMENTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DocumentVersion"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val REQUIRES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Requires"))
    val REVIEWSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ReviewStatus"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val STATUSINFORMATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusInformation"))
    val VERSIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VersionName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTACHMENTSCONTENT_DESCRIPTOR)
        field(CONTENT_DESCRIPTOR)
        field(CREATEDDATE_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(DOCUMENTFORMAT_DESCRIPTOR)
        field(DOCUMENTTYPE_DESCRIPTOR)
        field(DOCUMENTVERSION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(REQUIRES_DESCRIPTOR)
        field(REVIEWSTATUS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSINFORMATION_DESCRIPTOR)
        field(VERSIONNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ATTACHMENTSCONTENT_DESCRIPTOR.index -> builder.attachmentsContent =
                    deserializer.deserializeList(ATTACHMENTSCONTENT_DESCRIPTOR) {
                        val col0 = mutableListOf<AttachmentContent>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAttachmentContentDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CONTENT_DESCRIPTOR.index -> builder.content = deserializeString()
                CREATEDDATE_DESCRIPTOR.index -> builder.createdDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                DISPLAYNAME_DESCRIPTOR.index -> builder.displayName = deserializeString()
                DOCUMENTFORMAT_DESCRIPTOR.index -> builder.documentFormat = deserializeString().let { DocumentFormat.fromValue(it) }
                DOCUMENTTYPE_DESCRIPTOR.index -> builder.documentType = deserializeString().let { DocumentType.fromValue(it) }
                DOCUMENTVERSION_DESCRIPTOR.index -> builder.documentVersion = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                REQUIRES_DESCRIPTOR.index -> builder.requires =
                    deserializer.deserializeList(REQUIRES_DESCRIPTOR) {
                        val col0 = mutableListOf<DocumentRequires>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDocumentRequiresDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                REVIEWSTATUS_DESCRIPTOR.index -> builder.reviewStatus = deserializeString().let { ReviewStatus.fromValue(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { DocumentStatus.fromValue(it) }
                STATUSINFORMATION_DESCRIPTOR.index -> builder.statusInformation = deserializeString()
                VERSIONNAME_DESCRIPTOR.index -> builder.versionName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
