// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.DescribePatchGroupStateResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribePatchGroupStateOperationDeserializer: HttpDeserialize<DescribePatchGroupStateResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribePatchGroupStateResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribePatchGroupStateError(context, call)
        }
        val builder = DescribePatchGroupStateResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribePatchGroupStateOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribePatchGroupStateError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        "InvalidNextToken" -> InvalidNextTokenDeserializer().deserialize(context, wrappedCall)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribePatchGroupStateOperationBody(builder: DescribePatchGroupStateResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INSTANCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Instances"))
    val INSTANCESWITHCRITICALNONCOMPLIANTPATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("InstancesWithCriticalNonCompliantPatches"))
    val INSTANCESWITHFAILEDPATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("InstancesWithFailedPatches"))
    val INSTANCESWITHINSTALLEDOTHERPATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("InstancesWithInstalledOtherPatches"))
    val INSTANCESWITHINSTALLEDPATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("InstancesWithInstalledPatches"))
    val INSTANCESWITHINSTALLEDPENDINGREBOOTPATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("InstancesWithInstalledPendingRebootPatches"))
    val INSTANCESWITHINSTALLEDREJECTEDPATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("InstancesWithInstalledRejectedPatches"))
    val INSTANCESWITHMISSINGPATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("InstancesWithMissingPatches"))
    val INSTANCESWITHNOTAPPLICABLEPATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("InstancesWithNotApplicablePatches"))
    val INSTANCESWITHOTHERNONCOMPLIANTPATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("InstancesWithOtherNonCompliantPatches"))
    val INSTANCESWITHSECURITYNONCOMPLIANTPATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("InstancesWithSecurityNonCompliantPatches"))
    val INSTANCESWITHUNREPORTEDNOTAPPLICABLEPATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("InstancesWithUnreportedNotApplicablePatches"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INSTANCES_DESCRIPTOR)
        field(INSTANCESWITHCRITICALNONCOMPLIANTPATCHES_DESCRIPTOR)
        field(INSTANCESWITHFAILEDPATCHES_DESCRIPTOR)
        field(INSTANCESWITHINSTALLEDOTHERPATCHES_DESCRIPTOR)
        field(INSTANCESWITHINSTALLEDPATCHES_DESCRIPTOR)
        field(INSTANCESWITHINSTALLEDPENDINGREBOOTPATCHES_DESCRIPTOR)
        field(INSTANCESWITHINSTALLEDREJECTEDPATCHES_DESCRIPTOR)
        field(INSTANCESWITHMISSINGPATCHES_DESCRIPTOR)
        field(INSTANCESWITHNOTAPPLICABLEPATCHES_DESCRIPTOR)
        field(INSTANCESWITHOTHERNONCOMPLIANTPATCHES_DESCRIPTOR)
        field(INSTANCESWITHSECURITYNONCOMPLIANTPATCHES_DESCRIPTOR)
        field(INSTANCESWITHUNREPORTEDNOTAPPLICABLEPATCHES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INSTANCES_DESCRIPTOR.index -> builder.instances = deserializeInt()
                INSTANCESWITHCRITICALNONCOMPLIANTPATCHES_DESCRIPTOR.index -> builder.instancesWithCriticalNonCompliantPatches = deserializeInt()
                INSTANCESWITHFAILEDPATCHES_DESCRIPTOR.index -> builder.instancesWithFailedPatches = deserializeInt()
                INSTANCESWITHINSTALLEDOTHERPATCHES_DESCRIPTOR.index -> builder.instancesWithInstalledOtherPatches = deserializeInt()
                INSTANCESWITHINSTALLEDPATCHES_DESCRIPTOR.index -> builder.instancesWithInstalledPatches = deserializeInt()
                INSTANCESWITHINSTALLEDPENDINGREBOOTPATCHES_DESCRIPTOR.index -> builder.instancesWithInstalledPendingRebootPatches = deserializeInt()
                INSTANCESWITHINSTALLEDREJECTEDPATCHES_DESCRIPTOR.index -> builder.instancesWithInstalledRejectedPatches = deserializeInt()
                INSTANCESWITHMISSINGPATCHES_DESCRIPTOR.index -> builder.instancesWithMissingPatches = deserializeInt()
                INSTANCESWITHNOTAPPLICABLEPATCHES_DESCRIPTOR.index -> builder.instancesWithNotApplicablePatches = deserializeInt()
                INSTANCESWITHOTHERNONCOMPLIANTPATCHES_DESCRIPTOR.index -> builder.instancesWithOtherNonCompliantPatches = deserializeInt()
                INSTANCESWITHSECURITYNONCOMPLIANTPATCHES_DESCRIPTOR.index -> builder.instancesWithSecurityNonCompliantPatches = deserializeInt()
                INSTANCESWITHUNREPORTEDNOTAPPLICABLEPATCHES_DESCRIPTOR.index -> builder.instancesWithUnreportedNotApplicablePatches = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
