// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.DeregisterTaskFromMaintenanceWindowResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeregisterTaskFromMaintenanceWindowOperationDeserializer: HttpDeserialize<DeregisterTaskFromMaintenanceWindowResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeregisterTaskFromMaintenanceWindowResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeregisterTaskFromMaintenanceWindowError(context, call)
        }
        val builder = DeregisterTaskFromMaintenanceWindowResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeregisterTaskFromMaintenanceWindowOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeregisterTaskFromMaintenanceWindowError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DoesNotExistException" -> DoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeregisterTaskFromMaintenanceWindowOperationBody(builder: DeregisterTaskFromMaintenanceWindowResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val WINDOWID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WindowId"))
    val WINDOWTASKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WindowTaskId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(WINDOWID_DESCRIPTOR)
        field(WINDOWTASKID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                WINDOWID_DESCRIPTOR.index -> builder.windowId = deserializeString()
                WINDOWTASKID_DESCRIPTOR.index -> builder.windowTaskId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
