// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.DeregisterPatchBaselineForPatchGroupResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeregisterPatchBaselineForPatchGroupOperationDeserializer: HttpDeserialize<DeregisterPatchBaselineForPatchGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeregisterPatchBaselineForPatchGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeregisterPatchBaselineForPatchGroupError(context, call)
        }
        val builder = DeregisterPatchBaselineForPatchGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeregisterPatchBaselineForPatchGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeregisterPatchBaselineForPatchGroupError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidResourceId" -> InvalidResourceIdDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeregisterPatchBaselineForPatchGroupOperationBody(builder: DeregisterPatchBaselineForPatchGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BASELINEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BaselineId"))
    val PATCHGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PatchGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASELINEID_DESCRIPTOR)
        field(PATCHGROUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BASELINEID_DESCRIPTOR.index -> builder.baselineId = deserializeString()
                PATCHGROUP_DESCRIPTOR.index -> builder.patchGroup = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
