// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.CreateResourceDataSyncResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class CreateResourceDataSyncOperationDeserializer: HttpDeserialize<CreateResourceDataSyncResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateResourceDataSyncResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateResourceDataSyncError(context, call)
        }
        val builder = CreateResourceDataSyncResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateResourceDataSyncError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceDataSyncInvalidConfigurationException" -> ResourceDataSyncInvalidConfigurationExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceDataSyncAlreadyExistsException" -> ResourceDataSyncAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceDataSyncCountExceededException" -> ResourceDataSyncCountExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
