// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.AssociationDescription
import aws.sdk.kotlin.services.ssm.model.CreateAssociationBatchResponse
import aws.sdk.kotlin.services.ssm.model.FailedCreateAssociation
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class CreateAssociationBatchOperationDeserializer: HttpDeserialize<CreateAssociationBatchResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateAssociationBatchResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateAssociationBatchError(context, call)
        }
        val builder = CreateAssociationBatchResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateAssociationBatchOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateAssociationBatchError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidTarget" -> InvalidTargetDeserializer().deserialize(context, wrappedCall)
        "UnsupportedPlatformType" -> UnsupportedPlatformTypeDeserializer().deserialize(context, wrappedCall)
        "DuplicateInstanceId" -> DuplicateInstanceIdDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        "AssociationLimitExceeded" -> AssociationLimitExceededDeserializer().deserialize(context, wrappedCall)
        "InvalidSchedule" -> InvalidScheduleDeserializer().deserialize(context, wrappedCall)
        "InvalidDocumentVersion" -> InvalidDocumentVersionDeserializer().deserialize(context, wrappedCall)
        "InvalidTargetMaps" -> InvalidTargetMapsDeserializer().deserialize(context, wrappedCall)
        "InvalidInstanceId" -> InvalidInstanceIdDeserializer().deserialize(context, wrappedCall)
        "InvalidDocument" -> InvalidDocumentDeserializer().deserialize(context, wrappedCall)
        "InvalidParameters" -> InvalidParametersDeserializer().deserialize(context, wrappedCall)
        "InvalidOutputLocation" -> InvalidOutputLocationDeserializer().deserialize(context, wrappedCall)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateAssociationBatchOperationBody(builder: CreateAssociationBatchResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Failed"))
    val SUCCESSFUL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Successful"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILED_DESCRIPTOR)
        field(SUCCESSFUL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILED_DESCRIPTOR.index -> builder.failed =
                    deserializer.deserializeList(FAILED_DESCRIPTOR) {
                        val col0 = mutableListOf<FailedCreateAssociation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFailedCreateAssociationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUCCESSFUL_DESCRIPTOR.index -> builder.successful =
                    deserializer.deserializeList(SUCCESSFUL_DESCRIPTOR) {
                        val col0 = mutableListOf<AssociationDescription>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssociationDescriptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
