// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.AddTagsToResourceResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class AddTagsToResourceOperationDeserializer: HttpDeserialize<AddTagsToResourceResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): AddTagsToResourceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAddTagsToResourceError(context, call)
        }
        val builder = AddTagsToResourceResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwAddTagsToResourceError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TooManyUpdates" -> TooManyUpdatesDeserializer().deserialize(context, wrappedCall)
        "InvalidResourceId" -> InvalidResourceIdDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        "TooManyTagsError" -> TooManyTagsErrorDeserializer().deserialize(context, wrappedCall)
        "InvalidResourceType" -> InvalidResourceTypeDeserializer().deserialize(context, wrappedCall)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
