// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



public class UpdatePatchBaselineRequest private constructor(builder: Builder) {
    /**
     * A set of rules used to include patches in the baseline.
     */
    public val approvalRules: aws.sdk.kotlin.services.ssm.model.PatchRuleGroup? = builder.approvalRules
    /**
     * A list of explicitly approved patches for the baseline.
     *
     * For information about accepted formats for lists of approved patches and rejected patches, see [About package name formats for approved and rejected patch lists](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val approvedPatches: List<String>? = builder.approvedPatches
    /**
     * Assigns a new compliance severity level to an existing patch baseline.
     */
    public val approvedPatchesComplianceLevel: aws.sdk.kotlin.services.ssm.model.PatchComplianceLevel? = builder.approvedPatchesComplianceLevel
    /**
     * Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is `false`. Applies to Linux managed nodes only.
     */
    public val approvedPatchesEnableNonSecurity: kotlin.Boolean? = builder.approvedPatchesEnableNonSecurity
    /**
     * The ID of the patch baseline to update.
     */
    public val baselineId: kotlin.String? = builder.baselineId
    /**
     * A description of the patch baseline.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A set of global filters used to include patches in the baseline.
     */
    public val globalFilters: aws.sdk.kotlin.services.ssm.model.PatchFilterGroup? = builder.globalFilters
    /**
     * The name of the patch baseline.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list of explicitly rejected patches for the baseline.
     *
     * For information about accepted formats for lists of approved patches and rejected patches, see [About package name formats for approved and rejected patch lists](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val rejectedPatches: List<String>? = builder.rejectedPatches
    /**
     * The action for Patch Manager to take on patches included in the `RejectedPackages` list.
     * + **`ALLOW_AS_DEPENDENCY`**: A package in the `Rejected` patches list is installed only if it is a dependency of another package. It is considered compliant with the patch baseline, and its status is reported as `InstalledOther`. This is the default action if no option is specified.
     * + **`BLOCK`**: Packages in the `RejectedPatches` list, and packages that include them as dependencies, aren't installed under any circumstances. If a package was installed before it was added to the `Rejected` patches list, it is considered non-compliant with the patch baseline, and its status is reported as `InstalledRejected`.
     */
    public val rejectedPatchesAction: aws.sdk.kotlin.services.ssm.model.PatchAction? = builder.rejectedPatchesAction
    /**
     * If True, then all fields that are required by the CreatePatchBaseline operation are also required for this API request. Optional fields that aren't specified are set to null.
     */
    public val replace: kotlin.Boolean? = builder.replace
    /**
     * Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.
     */
    public val sources: List<PatchSource>? = builder.sources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.UpdatePatchBaselineRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdatePatchBaselineRequest(")
        append("approvalRules=$approvalRules,")
        append("approvedPatches=$approvedPatches,")
        append("approvedPatchesComplianceLevel=$approvedPatchesComplianceLevel,")
        append("approvedPatchesEnableNonSecurity=$approvedPatchesEnableNonSecurity,")
        append("baselineId=$baselineId,")
        append("description=$description,")
        append("globalFilters=$globalFilters,")
        append("name=$name,")
        append("rejectedPatches=$rejectedPatches,")
        append("rejectedPatchesAction=$rejectedPatchesAction,")
        append("replace=$replace,")
        append("sources=$sources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = approvalRules?.hashCode() ?: 0
        result = 31 * result + (approvedPatches?.hashCode() ?: 0)
        result = 31 * result + (approvedPatchesComplianceLevel?.hashCode() ?: 0)
        result = 31 * result + (approvedPatchesEnableNonSecurity?.hashCode() ?: 0)
        result = 31 * result + (baselineId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (globalFilters?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (rejectedPatches?.hashCode() ?: 0)
        result = 31 * result + (rejectedPatchesAction?.hashCode() ?: 0)
        result = 31 * result + (replace?.hashCode() ?: 0)
        result = 31 * result + (sources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdatePatchBaselineRequest

        if (approvalRules != other.approvalRules) return false
        if (approvedPatches != other.approvedPatches) return false
        if (approvedPatchesComplianceLevel != other.approvedPatchesComplianceLevel) return false
        if (approvedPatchesEnableNonSecurity != other.approvedPatchesEnableNonSecurity) return false
        if (baselineId != other.baselineId) return false
        if (description != other.description) return false
        if (globalFilters != other.globalFilters) return false
        if (name != other.name) return false
        if (rejectedPatches != other.rejectedPatches) return false
        if (rejectedPatchesAction != other.rejectedPatchesAction) return false
        if (replace != other.replace) return false
        if (sources != other.sources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.UpdatePatchBaselineRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A set of rules used to include patches in the baseline.
         */
        public var approvalRules: aws.sdk.kotlin.services.ssm.model.PatchRuleGroup? = null
        /**
         * A list of explicitly approved patches for the baseline.
         *
         * For information about accepted formats for lists of approved patches and rejected patches, see [About package name formats for approved and rejected patch lists](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var approvedPatches: List<String>? = null
        /**
         * Assigns a new compliance severity level to an existing patch baseline.
         */
        public var approvedPatchesComplianceLevel: aws.sdk.kotlin.services.ssm.model.PatchComplianceLevel? = null
        /**
         * Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is `false`. Applies to Linux managed nodes only.
         */
        public var approvedPatchesEnableNonSecurity: kotlin.Boolean? = null
        /**
         * The ID of the patch baseline to update.
         */
        public var baselineId: kotlin.String? = null
        /**
         * A description of the patch baseline.
         */
        public var description: kotlin.String? = null
        /**
         * A set of global filters used to include patches in the baseline.
         */
        public var globalFilters: aws.sdk.kotlin.services.ssm.model.PatchFilterGroup? = null
        /**
         * The name of the patch baseline.
         */
        public var name: kotlin.String? = null
        /**
         * A list of explicitly rejected patches for the baseline.
         *
         * For information about accepted formats for lists of approved patches and rejected patches, see [About package name formats for approved and rejected patch lists](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var rejectedPatches: List<String>? = null
        /**
         * The action for Patch Manager to take on patches included in the `RejectedPackages` list.
         * + **`ALLOW_AS_DEPENDENCY`**: A package in the `Rejected` patches list is installed only if it is a dependency of another package. It is considered compliant with the patch baseline, and its status is reported as `InstalledOther`. This is the default action if no option is specified.
         * + **`BLOCK`**: Packages in the `RejectedPatches` list, and packages that include them as dependencies, aren't installed under any circumstances. If a package was installed before it was added to the `Rejected` patches list, it is considered non-compliant with the patch baseline, and its status is reported as `InstalledRejected`.
         */
        public var rejectedPatchesAction: aws.sdk.kotlin.services.ssm.model.PatchAction? = null
        /**
         * If True, then all fields that are required by the CreatePatchBaseline operation are also required for this API request. Optional fields that aren't specified are set to null.
         */
        public var replace: kotlin.Boolean? = null
        /**
         * Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.
         */
        public var sources: List<PatchSource>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.UpdatePatchBaselineRequest) : this() {
            this.approvalRules = x.approvalRules
            this.approvedPatches = x.approvedPatches
            this.approvedPatchesComplianceLevel = x.approvedPatchesComplianceLevel
            this.approvedPatchesEnableNonSecurity = x.approvedPatchesEnableNonSecurity
            this.baselineId = x.baselineId
            this.description = x.description
            this.globalFilters = x.globalFilters
            this.name = x.name
            this.rejectedPatches = x.rejectedPatches
            this.rejectedPatchesAction = x.rejectedPatchesAction
            this.replace = x.replace
            this.sources = x.sources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.UpdatePatchBaselineRequest = UpdatePatchBaselineRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.PatchRuleGroup] inside the given [block]
         */
        public fun approvalRules(block: aws.sdk.kotlin.services.ssm.model.PatchRuleGroup.Builder.() -> kotlin.Unit) {
            this.approvalRules = aws.sdk.kotlin.services.ssm.model.PatchRuleGroup.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.PatchFilterGroup] inside the given [block]
         */
        public fun globalFilters(block: aws.sdk.kotlin.services.ssm.model.PatchFilterGroup.Builder.() -> kotlin.Unit) {
            this.globalFilters = aws.sdk.kotlin.services.ssm.model.PatchFilterGroup.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
