// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



public class UpdateMaintenanceWindowTaskResponse private constructor(builder: Builder) {
    /**
     * The details for the CloudWatch alarm you applied to your maintenance window task.
     */
    public val alarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = builder.alarmConfiguration
    /**
     * The specification for whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached.
     */
    public val cutoffBehavior: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskCutoffBehavior? = builder.cutoffBehavior
    /**
     * The updated task description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The updated logging information in Amazon S3.
     *
     * `LoggingInfo` has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the `OutputS3BucketName` and `OutputS3KeyPrefix` options in the `TaskInvocationParameters` structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
     */
    public val loggingInfo: aws.sdk.kotlin.services.ssm.model.LoggingInfo? = builder.loggingInfo
    /**
     * The updated `MaxConcurrency` value.
     */
    public val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The updated `MaxErrors` value.
     */
    public val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * The updated task name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The updated priority value.
     */
    public val priority: kotlin.Int = builder.priority
    /**
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.
     */
    public val serviceRoleArn: kotlin.String? = builder.serviceRoleArn
    /**
     * The updated target values.
     */
    public val targets: List<Target>? = builder.targets
    /**
     * The updated task ARN value.
     */
    public val taskArn: kotlin.String? = builder.taskArn
    /**
     * The updated parameter values.
     */
    public val taskInvocationParameters: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters? = builder.taskInvocationParameters
    /**
     * The updated parameter values.
     *
     * `TaskParameters` has been deprecated. To specify parameters to pass to a task when it runs, instead use the `Parameters` option in the `TaskInvocationParameters` structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
     */
    public val taskParameters: Map<String, MaintenanceWindowTaskParameterValueExpression>? = builder.taskParameters
    /**
     * The ID of the maintenance window that was updated.
     */
    public val windowId: kotlin.String? = builder.windowId
    /**
     * The task ID of the maintenance window that was updated.
     */
    public val windowTaskId: kotlin.String? = builder.windowTaskId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowTaskResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateMaintenanceWindowTaskResponse(")
        append("alarmConfiguration=$alarmConfiguration,")
        append("cutoffBehavior=$cutoffBehavior,")
        append("description=*** Sensitive Data Redacted ***,")
        append("loggingInfo=$loggingInfo,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("name=$name,")
        append("priority=$priority,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("targets=$targets,")
        append("taskArn=$taskArn,")
        append("taskInvocationParameters=$taskInvocationParameters,")
        append("taskParameters=*** Sensitive Data Redacted ***,")
        append("windowId=$windowId,")
        append("windowTaskId=$windowTaskId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmConfiguration?.hashCode() ?: 0
        result = 31 * result + (cutoffBehavior?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (loggingInfo?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (maxErrors?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (priority)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        result = 31 * result + (taskInvocationParameters?.hashCode() ?: 0)
        result = 31 * result + (taskParameters?.hashCode() ?: 0)
        result = 31 * result + (windowId?.hashCode() ?: 0)
        result = 31 * result + (windowTaskId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateMaintenanceWindowTaskResponse

        if (alarmConfiguration != other.alarmConfiguration) return false
        if (cutoffBehavior != other.cutoffBehavior) return false
        if (description != other.description) return false
        if (loggingInfo != other.loggingInfo) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (name != other.name) return false
        if (priority != other.priority) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (targets != other.targets) return false
        if (taskArn != other.taskArn) return false
        if (taskInvocationParameters != other.taskInvocationParameters) return false
        if (taskParameters != other.taskParameters) return false
        if (windowId != other.windowId) return false
        if (windowTaskId != other.windowTaskId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowTaskResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The details for the CloudWatch alarm you applied to your maintenance window task.
         */
        public var alarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = null
        /**
         * The specification for whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached.
         */
        public var cutoffBehavior: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskCutoffBehavior? = null
        /**
         * The updated task description.
         */
        public var description: kotlin.String? = null
        /**
         * The updated logging information in Amazon S3.
         *
         * `LoggingInfo` has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the `OutputS3BucketName` and `OutputS3KeyPrefix` options in the `TaskInvocationParameters` structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
         */
        public var loggingInfo: aws.sdk.kotlin.services.ssm.model.LoggingInfo? = null
        /**
         * The updated `MaxConcurrency` value.
         */
        public var maxConcurrency: kotlin.String? = null
        /**
         * The updated `MaxErrors` value.
         */
        public var maxErrors: kotlin.String? = null
        /**
         * The updated task name.
         */
        public var name: kotlin.String? = null
        /**
         * The updated priority value.
         */
        public var priority: kotlin.Int = 0
        /**
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.
         */
        public var serviceRoleArn: kotlin.String? = null
        /**
         * The updated target values.
         */
        public var targets: List<Target>? = null
        /**
         * The updated task ARN value.
         */
        public var taskArn: kotlin.String? = null
        /**
         * The updated parameter values.
         */
        public var taskInvocationParameters: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters? = null
        /**
         * The updated parameter values.
         *
         * `TaskParameters` has been deprecated. To specify parameters to pass to a task when it runs, instead use the `Parameters` option in the `TaskInvocationParameters` structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
         */
        public var taskParameters: Map<String, MaintenanceWindowTaskParameterValueExpression>? = null
        /**
         * The ID of the maintenance window that was updated.
         */
        public var windowId: kotlin.String? = null
        /**
         * The task ID of the maintenance window that was updated.
         */
        public var windowTaskId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowTaskResponse) : this() {
            this.alarmConfiguration = x.alarmConfiguration
            this.cutoffBehavior = x.cutoffBehavior
            this.description = x.description
            this.loggingInfo = x.loggingInfo
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.name = x.name
            this.priority = x.priority
            this.serviceRoleArn = x.serviceRoleArn
            this.targets = x.targets
            this.taskArn = x.taskArn
            this.taskInvocationParameters = x.taskInvocationParameters
            this.taskParameters = x.taskParameters
            this.windowId = x.windowId
            this.windowTaskId = x.windowTaskId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowTaskResponse = UpdateMaintenanceWindowTaskResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.AlarmConfiguration] inside the given [block]
         */
        public fun alarmConfiguration(block: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.Builder.() -> kotlin.Unit) {
            this.alarmConfiguration = aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.LoggingInfo] inside the given [block]
         */
        public fun loggingInfo(block: aws.sdk.kotlin.services.ssm.model.LoggingInfo.Builder.() -> kotlin.Unit) {
            this.loggingInfo = aws.sdk.kotlin.services.ssm.model.LoggingInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters] inside the given [block]
         */
        public fun taskInvocationParameters(block: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters.Builder.() -> kotlin.Unit) {
            this.taskInvocationParameters = aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
