// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



public class UpdateMaintenanceWindowTaskRequest private constructor(builder: Builder) {
    /**
     * The CloudWatch alarm you want to apply to your maintenance window task.
     */
    public val alarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = builder.alarmConfiguration
    /**
     * Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached.
     * + `CONTINUE_TASK`: When the cutoff time is reached, any tasks that are running continue. The default value.
     * + `CANCEL_TASK`:
     *    + For Automation, Lambda, Step Functions tasks: When the cutoff time is reached, any task invocations that are already running continue, but no new task invocations are started.
     *    + For Run Command tasks: When the cutoff time is reached, the system sends a CancelCommand operation that attempts to cancel the command associated with the task. However, there is no guarantee that the command will be terminated and the underlying process stopped.
     * The status for tasks that are not completed is `TIMED_OUT`.
     */
    public val cutoffBehavior: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskCutoffBehavior? = builder.cutoffBehavior
    /**
     * The new task description to specify.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The new logging location in Amazon S3 to specify.
     *
     * `LoggingInfo` has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the `OutputS3BucketName` and `OutputS3KeyPrefix` options in the `TaskInvocationParameters` structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
     */
    public val loggingInfo: aws.sdk.kotlin.services.ssm.model.LoggingInfo? = builder.loggingInfo
    /**
     * The new `MaxConcurrency` value you want to specify. `MaxConcurrency` is the number of targets that are allowed to run this task, in parallel.
     *
     * Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a [targetless task](https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html) You must provide a value in all other cases.
     *
     * For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of `1`. This value doesn't affect the running of your task.
     */
    public val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The new `MaxErrors` value to specify. `MaxErrors` is the maximum number of errors that are allowed before the task stops being scheduled.
     *
     * Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a [targetless task](https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html) You must provide a value in all other cases.
     *
     * For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of `1`. This value doesn't affect the running of your task.
     */
    public val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * The new task name to specify.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The new task priority to specify. The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * If True, then all fields that are required by the RegisterTaskWithMaintenanceWindow operation are also required for this API request. Optional fields that aren't specified are set to null.
     */
    public val replace: kotlin.Boolean? = builder.replace
    /**
     * The Amazon Resource Name (ARN) of the IAM service role for Amazon Web Services Systems Manager to assume when running a maintenance window task. If you do not specify a service role ARN, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created when you run `RegisterTaskWithMaintenanceWindow`.
     *
     * For more information, see the following topics in the in the *Amazon Web Services Systems Manager User Guide*:
     * + [Using service-linked roles for Systems Manager](https://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions)
     * + [Should I use a service-linked role or a custom service role to run maintenance window tasks? ](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role)
     */
    public val serviceRoleArn: kotlin.String? = builder.serviceRoleArn
    /**
     * The targets (either managed nodes or tags) to modify. Managed nodes are specified using the format `Key=instanceids,Values=instanceID_1,instanceID_2`. Tags are specified using the format ` Key=tag_name,Values=tag_value`.
     *
     * One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the task, targets are optional for other maintenance window task types (Automation, Lambda, and Step Functions). For more information about running tasks that don't specify targets, see [Registering maintenance window tasks without targets](https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val targets: List<Target>? = builder.targets
    /**
     * The task ARN to modify.
     */
    public val taskArn: kotlin.String? = builder.taskArn
    /**
     * The parameters that the task should use during execution. Populate only the fields that match the task type. All other fields should be empty.
     *
     * When you update a maintenance window task that has options specified in `TaskInvocationParameters`, you must provide again all the `TaskInvocationParameters` values that you want to retain. The values you don't specify again are removed. For example, suppose that when you registered a Run Command task, you specified `TaskInvocationParameters` values for `Comment`, `NotificationConfig`, and `OutputS3BucketName`. If you update the maintenance window task and specify only a different `OutputS3BucketName` value, the values for `Comment` and `NotificationConfig` are removed.
     */
    public val taskInvocationParameters: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters? = builder.taskInvocationParameters
    /**
     * The parameters to modify.
     *
     * `TaskParameters` has been deprecated. To specify parameters to pass to a task when it runs, instead use the `Parameters` option in the `TaskInvocationParameters` structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
     *
     * The map has the following format:
     *
     * Key: string, between 1 and 255 characters
     *
     * Value: an array of strings, each string is between 1 and 255 characters
     */
    public val taskParameters: Map<String, MaintenanceWindowTaskParameterValueExpression>? = builder.taskParameters
    /**
     * The maintenance window ID that contains the task to modify.
     */
    public val windowId: kotlin.String? = builder.windowId
    /**
     * The task ID to modify.
     */
    public val windowTaskId: kotlin.String? = builder.windowTaskId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateMaintenanceWindowTaskRequest(")
        append("alarmConfiguration=$alarmConfiguration,")
        append("cutoffBehavior=$cutoffBehavior,")
        append("description=*** Sensitive Data Redacted ***,")
        append("loggingInfo=$loggingInfo,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("name=$name,")
        append("priority=$priority,")
        append("replace=$replace,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("targets=$targets,")
        append("taskArn=$taskArn,")
        append("taskInvocationParameters=$taskInvocationParameters,")
        append("taskParameters=*** Sensitive Data Redacted ***,")
        append("windowId=$windowId,")
        append("windowTaskId=$windowTaskId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmConfiguration?.hashCode() ?: 0
        result = 31 * result + (cutoffBehavior?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (loggingInfo?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (maxErrors?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (replace?.hashCode() ?: 0)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        result = 31 * result + (taskInvocationParameters?.hashCode() ?: 0)
        result = 31 * result + (taskParameters?.hashCode() ?: 0)
        result = 31 * result + (windowId?.hashCode() ?: 0)
        result = 31 * result + (windowTaskId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateMaintenanceWindowTaskRequest

        if (alarmConfiguration != other.alarmConfiguration) return false
        if (cutoffBehavior != other.cutoffBehavior) return false
        if (description != other.description) return false
        if (loggingInfo != other.loggingInfo) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (name != other.name) return false
        if (priority != other.priority) return false
        if (replace != other.replace) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (targets != other.targets) return false
        if (taskArn != other.taskArn) return false
        if (taskInvocationParameters != other.taskInvocationParameters) return false
        if (taskParameters != other.taskParameters) return false
        if (windowId != other.windowId) return false
        if (windowTaskId != other.windowTaskId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowTaskRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The CloudWatch alarm you want to apply to your maintenance window task.
         */
        public var alarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = null
        /**
         * Indicates whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached.
         * + `CONTINUE_TASK`: When the cutoff time is reached, any tasks that are running continue. The default value.
         * + `CANCEL_TASK`:
         *    + For Automation, Lambda, Step Functions tasks: When the cutoff time is reached, any task invocations that are already running continue, but no new task invocations are started.
         *    + For Run Command tasks: When the cutoff time is reached, the system sends a CancelCommand operation that attempts to cancel the command associated with the task. However, there is no guarantee that the command will be terminated and the underlying process stopped.
         * The status for tasks that are not completed is `TIMED_OUT`.
         */
        public var cutoffBehavior: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskCutoffBehavior? = null
        /**
         * The new task description to specify.
         */
        public var description: kotlin.String? = null
        /**
         * The new logging location in Amazon S3 to specify.
         *
         * `LoggingInfo` has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the `OutputS3BucketName` and `OutputS3KeyPrefix` options in the `TaskInvocationParameters` structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
         */
        public var loggingInfo: aws.sdk.kotlin.services.ssm.model.LoggingInfo? = null
        /**
         * The new `MaxConcurrency` value you want to specify. `MaxConcurrency` is the number of targets that are allowed to run this task, in parallel.
         *
         * Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a [targetless task](https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html) You must provide a value in all other cases.
         *
         * For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of `1`. This value doesn't affect the running of your task.
         */
        public var maxConcurrency: kotlin.String? = null
        /**
         * The new `MaxErrors` value to specify. `MaxErrors` is the maximum number of errors that are allowed before the task stops being scheduled.
         *
         * Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a [targetless task](https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html) You must provide a value in all other cases.
         *
         * For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of `1`. This value doesn't affect the running of your task.
         */
        public var maxErrors: kotlin.String? = null
        /**
         * The new task name to specify.
         */
        public var name: kotlin.String? = null
        /**
         * The new task priority to specify. The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.
         */
        public var priority: kotlin.Int? = null
        /**
         * If True, then all fields that are required by the RegisterTaskWithMaintenanceWindow operation are also required for this API request. Optional fields that aren't specified are set to null.
         */
        public var replace: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM service role for Amazon Web Services Systems Manager to assume when running a maintenance window task. If you do not specify a service role ARN, Systems Manager uses your account's service-linked role. If no service-linked role for Systems Manager exists in your account, it is created when you run `RegisterTaskWithMaintenanceWindow`.
         *
         * For more information, see the following topics in the in the *Amazon Web Services Systems Manager User Guide*:
         * + [Using service-linked roles for Systems Manager](https://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions)
         * + [Should I use a service-linked role or a custom service role to run maintenance window tasks? ](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role)
         */
        public var serviceRoleArn: kotlin.String? = null
        /**
         * The targets (either managed nodes or tags) to modify. Managed nodes are specified using the format `Key=instanceids,Values=instanceID_1,instanceID_2`. Tags are specified using the format ` Key=tag_name,Values=tag_value`.
         *
         * One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the task, targets are optional for other maintenance window task types (Automation, Lambda, and Step Functions). For more information about running tasks that don't specify targets, see [Registering maintenance window tasks without targets](https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var targets: List<Target>? = null
        /**
         * The task ARN to modify.
         */
        public var taskArn: kotlin.String? = null
        /**
         * The parameters that the task should use during execution. Populate only the fields that match the task type. All other fields should be empty.
         *
         * When you update a maintenance window task that has options specified in `TaskInvocationParameters`, you must provide again all the `TaskInvocationParameters` values that you want to retain. The values you don't specify again are removed. For example, suppose that when you registered a Run Command task, you specified `TaskInvocationParameters` values for `Comment`, `NotificationConfig`, and `OutputS3BucketName`. If you update the maintenance window task and specify only a different `OutputS3BucketName` value, the values for `Comment` and `NotificationConfig` are removed.
         */
        public var taskInvocationParameters: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters? = null
        /**
         * The parameters to modify.
         *
         * `TaskParameters` has been deprecated. To specify parameters to pass to a task when it runs, instead use the `Parameters` option in the `TaskInvocationParameters` structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
         *
         * The map has the following format:
         *
         * Key: string, between 1 and 255 characters
         *
         * Value: an array of strings, each string is between 1 and 255 characters
         */
        public var taskParameters: Map<String, MaintenanceWindowTaskParameterValueExpression>? = null
        /**
         * The maintenance window ID that contains the task to modify.
         */
        public var windowId: kotlin.String? = null
        /**
         * The task ID to modify.
         */
        public var windowTaskId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowTaskRequest) : this() {
            this.alarmConfiguration = x.alarmConfiguration
            this.cutoffBehavior = x.cutoffBehavior
            this.description = x.description
            this.loggingInfo = x.loggingInfo
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.name = x.name
            this.priority = x.priority
            this.replace = x.replace
            this.serviceRoleArn = x.serviceRoleArn
            this.targets = x.targets
            this.taskArn = x.taskArn
            this.taskInvocationParameters = x.taskInvocationParameters
            this.taskParameters = x.taskParameters
            this.windowId = x.windowId
            this.windowTaskId = x.windowTaskId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowTaskRequest = UpdateMaintenanceWindowTaskRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.AlarmConfiguration] inside the given [block]
         */
        public fun alarmConfiguration(block: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.Builder.() -> kotlin.Unit) {
            this.alarmConfiguration = aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.LoggingInfo] inside the given [block]
         */
        public fun loggingInfo(block: aws.sdk.kotlin.services.ssm.model.LoggingInfo.Builder.() -> kotlin.Unit) {
            this.loggingInfo = aws.sdk.kotlin.services.ssm.model.LoggingInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters] inside the given [block]
         */
        public fun taskInvocationParameters(block: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters.Builder.() -> kotlin.Unit) {
            this.taskInvocationParameters = aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
