// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * The combination of Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Automation execution.
 */
public class TargetLocation private constructor(builder: Builder) {
    /**
     * The Amazon Web Services accounts targeted by the current Automation execution.
     */
    public val accounts: List<String>? = builder.accounts
    /**
     * The Automation execution role used by the currently running Automation. If not specified, the default value is `AWS-SystemsManager-AutomationExecutionRole`.
     */
    public val executionRoleName: kotlin.String? = builder.executionRoleName
    /**
     * The Amazon Web Services Regions targeted by the current Automation execution.
     */
    public val regions: List<String>? = builder.regions
    /**
     * The details for the CloudWatch alarm you want to apply to an automation or command.
     */
    public val targetLocationAlarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = builder.targetLocationAlarmConfiguration
    /**
     * The maximum number of Amazon Web Services Regions and Amazon Web Services accounts allowed to run the Automation concurrently.
     */
    public val targetLocationMaxConcurrency: kotlin.String? = builder.targetLocationMaxConcurrency
    /**
     * The maximum number of errors allowed before the system stops queueing additional Automation executions for the currently running Automation.
     */
    public val targetLocationMaxErrors: kotlin.String? = builder.targetLocationMaxErrors

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.TargetLocation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetLocation(")
        append("accounts=$accounts,")
        append("executionRoleName=$executionRoleName,")
        append("regions=$regions,")
        append("targetLocationAlarmConfiguration=$targetLocationAlarmConfiguration,")
        append("targetLocationMaxConcurrency=$targetLocationMaxConcurrency,")
        append("targetLocationMaxErrors=$targetLocationMaxErrors")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accounts?.hashCode() ?: 0
        result = 31 * result + (executionRoleName?.hashCode() ?: 0)
        result = 31 * result + (regions?.hashCode() ?: 0)
        result = 31 * result + (targetLocationAlarmConfiguration?.hashCode() ?: 0)
        result = 31 * result + (targetLocationMaxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (targetLocationMaxErrors?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetLocation

        if (accounts != other.accounts) return false
        if (executionRoleName != other.executionRoleName) return false
        if (regions != other.regions) return false
        if (targetLocationAlarmConfiguration != other.targetLocationAlarmConfiguration) return false
        if (targetLocationMaxConcurrency != other.targetLocationMaxConcurrency) return false
        if (targetLocationMaxErrors != other.targetLocationMaxErrors) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.TargetLocation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services accounts targeted by the current Automation execution.
         */
        public var accounts: List<String>? = null
        /**
         * The Automation execution role used by the currently running Automation. If not specified, the default value is `AWS-SystemsManager-AutomationExecutionRole`.
         */
        public var executionRoleName: kotlin.String? = null
        /**
         * The Amazon Web Services Regions targeted by the current Automation execution.
         */
        public var regions: List<String>? = null
        /**
         * The details for the CloudWatch alarm you want to apply to an automation or command.
         */
        public var targetLocationAlarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = null
        /**
         * The maximum number of Amazon Web Services Regions and Amazon Web Services accounts allowed to run the Automation concurrently.
         */
        public var targetLocationMaxConcurrency: kotlin.String? = null
        /**
         * The maximum number of errors allowed before the system stops queueing additional Automation executions for the currently running Automation.
         */
        public var targetLocationMaxErrors: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.TargetLocation) : this() {
            this.accounts = x.accounts
            this.executionRoleName = x.executionRoleName
            this.regions = x.regions
            this.targetLocationAlarmConfiguration = x.targetLocationAlarmConfiguration
            this.targetLocationMaxConcurrency = x.targetLocationMaxConcurrency
            this.targetLocationMaxErrors = x.targetLocationMaxErrors
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.TargetLocation = TargetLocation(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.AlarmConfiguration] inside the given [block]
         */
        public fun targetLocationAlarmConfiguration(block: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.Builder.() -> kotlin.Unit) {
            this.targetLocationAlarmConfiguration = aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
