// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed information about an the execution state of an Automation step.
 */
public class StepExecution private constructor(builder: Builder) {
    /**
     * The action this step performs. The action determines the behavior of the step.
     */
    public val action: kotlin.String? = builder.action
    /**
     * If a step has finished execution, this contains the time the execution ended. If the step hasn't yet concluded, this field isn't populated.
     */
    public val executionEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.executionEndTime
    /**
     * If a step has begun execution, this contains the time the step started. If the step is in Pending status, this field isn't populated.
     */
    public val executionStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.executionStartTime
    /**
     * Information about the Automation failure.
     */
    public val failureDetails: aws.sdk.kotlin.services.ssm.model.FailureDetails? = builder.failureDetails
    /**
     * If a step failed, this message explains why the execution failed.
     */
    public val failureMessage: kotlin.String? = builder.failureMessage
    /**
     * Fully-resolved values passed into the step before execution.
     */
    public val inputs: Map<String, String>? = builder.inputs
    /**
     * The flag which can be used to help decide whether the failure of current step leads to the Automation failure.
     */
    public val isCritical: kotlin.Boolean? = builder.isCritical
    /**
     * The flag which can be used to end automation no matter whether the step succeeds or fails.
     */
    public val isEnd: kotlin.Boolean? = builder.isEnd
    /**
     * The maximum number of tries to run the action of the step. The default value is `1`.
     */
    public val maxAttempts: kotlin.Int? = builder.maxAttempts
    /**
     * The next step after the step succeeds.
     */
    public val nextStep: kotlin.String? = builder.nextStep
    /**
     * The action to take if the step fails. The default value is `Abort`.
     */
    public val onFailure: kotlin.String? = builder.onFailure
    /**
     * Returned values from the execution of the step.
     */
    public val outputs: Map<String, List<String>>? = builder.outputs
    /**
     * A user-specified list of parameters to override when running a step.
     */
    public val overriddenParameters: Map<String, List<String>>? = builder.overriddenParameters
    /**
     * Information about the parent step.
     */
    public val parentStepDetails: aws.sdk.kotlin.services.ssm.model.ParentStepDetails? = builder.parentStepDetails
    /**
     * A message associated with the response code for an execution.
     */
    public val response: kotlin.String? = builder.response
    /**
     * The response code returned by the execution of the step.
     */
    public val responseCode: kotlin.String? = builder.responseCode
    /**
     * The unique ID of a step execution.
     */
    public val stepExecutionId: kotlin.String? = builder.stepExecutionId
    /**
     * The name of this execution step.
     */
    public val stepName: kotlin.String? = builder.stepName
    /**
     * The execution status for this step.
     */
    public val stepStatus: aws.sdk.kotlin.services.ssm.model.AutomationExecutionStatus? = builder.stepStatus
    /**
     * The combination of Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Automation execution.
     */
    public val targetLocation: aws.sdk.kotlin.services.ssm.model.TargetLocation? = builder.targetLocation
    /**
     * The targets for the step execution.
     */
    public val targets: List<Target>? = builder.targets
    /**
     * The timeout seconds of the step.
     */
    public val timeoutSeconds: kotlin.Long? = builder.timeoutSeconds
    /**
     * The CloudWatch alarms that were invoked by the automation.
     */
    public val triggeredAlarms: List<AlarmStateInformation>? = builder.triggeredAlarms
    /**
     * Strategies used when step fails, we support Continue and Abort. Abort will fail the automation when the step fails. Continue will ignore the failure of current step and allow automation to run the next step. With conditional branching, we add step:stepName to support the automation to go to another specific step.
     */
    public val validNextSteps: List<String>? = builder.validNextSteps

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.StepExecution = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StepExecution(")
        append("action=$action,")
        append("executionEndTime=$executionEndTime,")
        append("executionStartTime=$executionStartTime,")
        append("failureDetails=$failureDetails,")
        append("failureMessage=$failureMessage,")
        append("inputs=$inputs,")
        append("isCritical=$isCritical,")
        append("isEnd=$isEnd,")
        append("maxAttempts=$maxAttempts,")
        append("nextStep=$nextStep,")
        append("onFailure=$onFailure,")
        append("outputs=$outputs,")
        append("overriddenParameters=$overriddenParameters,")
        append("parentStepDetails=$parentStepDetails,")
        append("response=$response,")
        append("responseCode=$responseCode,")
        append("stepExecutionId=$stepExecutionId,")
        append("stepName=$stepName,")
        append("stepStatus=$stepStatus,")
        append("targetLocation=$targetLocation,")
        append("targets=$targets,")
        append("timeoutSeconds=$timeoutSeconds,")
        append("triggeredAlarms=$triggeredAlarms,")
        append("validNextSteps=$validNextSteps")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (executionEndTime?.hashCode() ?: 0)
        result = 31 * result + (executionStartTime?.hashCode() ?: 0)
        result = 31 * result + (failureDetails?.hashCode() ?: 0)
        result = 31 * result + (failureMessage?.hashCode() ?: 0)
        result = 31 * result + (inputs?.hashCode() ?: 0)
        result = 31 * result + (isCritical?.hashCode() ?: 0)
        result = 31 * result + (isEnd?.hashCode() ?: 0)
        result = 31 * result + (maxAttempts ?: 0)
        result = 31 * result + (nextStep?.hashCode() ?: 0)
        result = 31 * result + (onFailure?.hashCode() ?: 0)
        result = 31 * result + (outputs?.hashCode() ?: 0)
        result = 31 * result + (overriddenParameters?.hashCode() ?: 0)
        result = 31 * result + (parentStepDetails?.hashCode() ?: 0)
        result = 31 * result + (response?.hashCode() ?: 0)
        result = 31 * result + (responseCode?.hashCode() ?: 0)
        result = 31 * result + (stepExecutionId?.hashCode() ?: 0)
        result = 31 * result + (stepName?.hashCode() ?: 0)
        result = 31 * result + (stepStatus?.hashCode() ?: 0)
        result = 31 * result + (targetLocation?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (timeoutSeconds?.hashCode() ?: 0)
        result = 31 * result + (triggeredAlarms?.hashCode() ?: 0)
        result = 31 * result + (validNextSteps?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StepExecution

        if (action != other.action) return false
        if (executionEndTime != other.executionEndTime) return false
        if (executionStartTime != other.executionStartTime) return false
        if (failureDetails != other.failureDetails) return false
        if (failureMessage != other.failureMessage) return false
        if (inputs != other.inputs) return false
        if (isCritical != other.isCritical) return false
        if (isEnd != other.isEnd) return false
        if (maxAttempts != other.maxAttempts) return false
        if (nextStep != other.nextStep) return false
        if (onFailure != other.onFailure) return false
        if (outputs != other.outputs) return false
        if (overriddenParameters != other.overriddenParameters) return false
        if (parentStepDetails != other.parentStepDetails) return false
        if (response != other.response) return false
        if (responseCode != other.responseCode) return false
        if (stepExecutionId != other.stepExecutionId) return false
        if (stepName != other.stepName) return false
        if (stepStatus != other.stepStatus) return false
        if (targetLocation != other.targetLocation) return false
        if (targets != other.targets) return false
        if (timeoutSeconds != other.timeoutSeconds) return false
        if (triggeredAlarms != other.triggeredAlarms) return false
        if (validNextSteps != other.validNextSteps) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.StepExecution = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action this step performs. The action determines the behavior of the step.
         */
        public var action: kotlin.String? = null
        /**
         * If a step has finished execution, this contains the time the execution ended. If the step hasn't yet concluded, this field isn't populated.
         */
        public var executionEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If a step has begun execution, this contains the time the step started. If the step is in Pending status, this field isn't populated.
         */
        public var executionStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the Automation failure.
         */
        public var failureDetails: aws.sdk.kotlin.services.ssm.model.FailureDetails? = null
        /**
         * If a step failed, this message explains why the execution failed.
         */
        public var failureMessage: kotlin.String? = null
        /**
         * Fully-resolved values passed into the step before execution.
         */
        public var inputs: Map<String, String>? = null
        /**
         * The flag which can be used to help decide whether the failure of current step leads to the Automation failure.
         */
        public var isCritical: kotlin.Boolean? = null
        /**
         * The flag which can be used to end automation no matter whether the step succeeds or fails.
         */
        public var isEnd: kotlin.Boolean? = null
        /**
         * The maximum number of tries to run the action of the step. The default value is `1`.
         */
        public var maxAttempts: kotlin.Int? = null
        /**
         * The next step after the step succeeds.
         */
        public var nextStep: kotlin.String? = null
        /**
         * The action to take if the step fails. The default value is `Abort`.
         */
        public var onFailure: kotlin.String? = null
        /**
         * Returned values from the execution of the step.
         */
        public var outputs: Map<String, List<String>>? = null
        /**
         * A user-specified list of parameters to override when running a step.
         */
        public var overriddenParameters: Map<String, List<String>>? = null
        /**
         * Information about the parent step.
         */
        public var parentStepDetails: aws.sdk.kotlin.services.ssm.model.ParentStepDetails? = null
        /**
         * A message associated with the response code for an execution.
         */
        public var response: kotlin.String? = null
        /**
         * The response code returned by the execution of the step.
         */
        public var responseCode: kotlin.String? = null
        /**
         * The unique ID of a step execution.
         */
        public var stepExecutionId: kotlin.String? = null
        /**
         * The name of this execution step.
         */
        public var stepName: kotlin.String? = null
        /**
         * The execution status for this step.
         */
        public var stepStatus: aws.sdk.kotlin.services.ssm.model.AutomationExecutionStatus? = null
        /**
         * The combination of Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Automation execution.
         */
        public var targetLocation: aws.sdk.kotlin.services.ssm.model.TargetLocation? = null
        /**
         * The targets for the step execution.
         */
        public var targets: List<Target>? = null
        /**
         * The timeout seconds of the step.
         */
        public var timeoutSeconds: kotlin.Long? = null
        /**
         * The CloudWatch alarms that were invoked by the automation.
         */
        public var triggeredAlarms: List<AlarmStateInformation>? = null
        /**
         * Strategies used when step fails, we support Continue and Abort. Abort will fail the automation when the step fails. Continue will ignore the failure of current step and allow automation to run the next step. With conditional branching, we add step:stepName to support the automation to go to another specific step.
         */
        public var validNextSteps: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.StepExecution) : this() {
            this.action = x.action
            this.executionEndTime = x.executionEndTime
            this.executionStartTime = x.executionStartTime
            this.failureDetails = x.failureDetails
            this.failureMessage = x.failureMessage
            this.inputs = x.inputs
            this.isCritical = x.isCritical
            this.isEnd = x.isEnd
            this.maxAttempts = x.maxAttempts
            this.nextStep = x.nextStep
            this.onFailure = x.onFailure
            this.outputs = x.outputs
            this.overriddenParameters = x.overriddenParameters
            this.parentStepDetails = x.parentStepDetails
            this.response = x.response
            this.responseCode = x.responseCode
            this.stepExecutionId = x.stepExecutionId
            this.stepName = x.stepName
            this.stepStatus = x.stepStatus
            this.targetLocation = x.targetLocation
            this.targets = x.targets
            this.timeoutSeconds = x.timeoutSeconds
            this.triggeredAlarms = x.triggeredAlarms
            this.validNextSteps = x.validNextSteps
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.StepExecution = StepExecution(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.FailureDetails] inside the given [block]
         */
        public fun failureDetails(block: aws.sdk.kotlin.services.ssm.model.FailureDetails.Builder.() -> kotlin.Unit) {
            this.failureDetails = aws.sdk.kotlin.services.ssm.model.FailureDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.ParentStepDetails] inside the given [block]
         */
        public fun parentStepDetails(block: aws.sdk.kotlin.services.ssm.model.ParentStepDetails.Builder.() -> kotlin.Unit) {
            this.parentStepDetails = aws.sdk.kotlin.services.ssm.model.ParentStepDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.TargetLocation] inside the given [block]
         */
        public fun targetLocation(block: aws.sdk.kotlin.services.ssm.model.TargetLocation.Builder.() -> kotlin.Unit) {
            this.targetLocation = aws.sdk.kotlin.services.ssm.model.TargetLocation.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
