// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



public class StartSessionResponse private constructor(builder: Builder) {
    /**
     * The ID of the session.
     */
    public val sessionId: kotlin.String? = builder.sessionId
    /**
     * A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and receive output from the node. Format: `wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)`
     *
     * **region** represents the Region identifier for an Amazon Web Services Region supported by Amazon Web Services Systems Manager, such as `us-east-2` for the US East (Ohio) Region. For a list of supported **region** values, see the **Region** column in [Systems Manager service endpoints](https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region) in the *Amazon Web Services General Reference*.
     *
     * **session-id** represents the ID of a Session Manager session, such as `1a2b3c4dEXAMPLE`.
     */
    public val streamUrl: kotlin.String? = builder.streamUrl
    /**
     * An encrypted token value containing session and caller information. This token is used to authenticate the connection to the managed node, and is valid only long enough to ensure the connection is successful. Never share your session's token.
     */
    public val tokenValue: kotlin.String? = builder.tokenValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.StartSessionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartSessionResponse(")
        append("sessionId=$sessionId,")
        append("streamUrl=$streamUrl,")
        append("tokenValue=$tokenValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = sessionId?.hashCode() ?: 0
        result = 31 * result + (streamUrl?.hashCode() ?: 0)
        result = 31 * result + (tokenValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartSessionResponse

        if (sessionId != other.sessionId) return false
        if (streamUrl != other.streamUrl) return false
        if (tokenValue != other.tokenValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.StartSessionResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the session.
         */
        public var sessionId: kotlin.String? = null
        /**
         * A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and receive output from the node. Format: `wss://ssmmessages.<b>region</b>.amazonaws.com/v1/data-channel/<b>session-id</b>?stream=(input|output)`
         *
         * **region** represents the Region identifier for an Amazon Web Services Region supported by Amazon Web Services Systems Manager, such as `us-east-2` for the US East (Ohio) Region. For a list of supported **region** values, see the **Region** column in [Systems Manager service endpoints](https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region) in the *Amazon Web Services General Reference*.
         *
         * **session-id** represents the ID of a Session Manager session, such as `1a2b3c4dEXAMPLE`.
         */
        public var streamUrl: kotlin.String? = null
        /**
         * An encrypted token value containing session and caller information. This token is used to authenticate the connection to the managed node, and is valid only long enough to ensure the connection is successful. Never share your session's token.
         */
        public var tokenValue: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.StartSessionResponse) : this() {
            this.sessionId = x.sessionId
            this.streamUrl = x.streamUrl
            this.tokenValue = x.tokenValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.StartSessionResponse = StartSessionResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
