// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * Describes a filter for Session Manager information.
 */
public class SessionFilter private constructor(builder: Builder) {
    /**
     * The name of the filter.
     */
    public val key: aws.sdk.kotlin.services.ssm.model.SessionFilterKey = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * The filter value. Valid values for each filter key are as follows:
     * + InvokedAfter: Specify a timestamp to limit your results. For example, specify 2018-08-29T00:00:00Z to see sessions that started August 29, 2018, and later.
     * + InvokedBefore: Specify a timestamp to limit your results. For example, specify 2018-08-29T00:00:00Z to see sessions that started before August 29, 2018.
     * + Target: Specify a managed node to which session connections have been made.
     * + Owner: Specify an Amazon Web Services user to see a list of sessions started by that user.
     * + Status: Specify a valid session status to see a list of all sessions with that status. Status values you can specify include:
     *    + Connected
     *    + Connecting
     *    + Disconnected
     *    + Terminated
     *    + Terminating
     *    + Failed
     * + SessionId: Specify a session ID to return details about the session.
     */
    public val value: kotlin.String = requireNotNull(builder.value) { "A non-null value must be provided for value" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.SessionFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SessionFilter(")
        append("key=$key,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = key.hashCode()
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SessionFilter

        if (key != other.key) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.SessionFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the filter.
         */
        public var key: aws.sdk.kotlin.services.ssm.model.SessionFilterKey? = null
        /**
         * The filter value. Valid values for each filter key are as follows:
         * + InvokedAfter: Specify a timestamp to limit your results. For example, specify 2018-08-29T00:00:00Z to see sessions that started August 29, 2018, and later.
         * + InvokedBefore: Specify a timestamp to limit your results. For example, specify 2018-08-29T00:00:00Z to see sessions that started before August 29, 2018.
         * + Target: Specify a managed node to which session connections have been made.
         * + Owner: Specify an Amazon Web Services user to see a list of sessions started by that user.
         * + Status: Specify a valid session status to see a list of all sessions with that status. Status values you can specify include:
         *    + Connected
         *    + Connecting
         *    + Disconnected
         *    + Terminated
         *    + Terminating
         *    + Failed
         * + SessionId: Specify a session ID to return details about the session.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.SessionFilter) : this() {
            this.key = x.key
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.SessionFilter = SessionFilter(this)

        internal fun correctErrors(): Builder {
            if (key == null) key = SessionFilterKey.SdkUnknown("no value provided")
            if (value == null) value = ""
            return this
        }
    }
}
