// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The service setting data structure.
 *
 * `ServiceSetting` is an account-level setting for an Amazon Web Services service. This setting defines how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services service charges money to the account based on feature or service usage, then the Amazon Web Services service team might create a default setting of "false". This means the user can't use this feature unless they change the setting to "true" and intentionally opt in for a paid feature.
 *
 * Services map a `SettingId` object to a setting value. Amazon Web Services services teams define the default value for a `SettingId`. You can't create a new `SettingId`, but you can overwrite the default value if you have the `ssm:UpdateServiceSetting` permission for the setting. Use the UpdateServiceSetting API operation to change the default setting. Or, use the ResetServiceSetting to change the value back to the original value defined by the Amazon Web Services service team.
 */
public class ServiceSetting private constructor(builder: Builder) {
    /**
     * The ARN of the service setting.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The last time the service setting was modified.
     */
    public val lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedDate
    /**
     * The ARN of the last modified user. This field is populated only if the setting value was overwritten.
     */
    public val lastModifiedUser: kotlin.String? = builder.lastModifiedUser
    /**
     * The ID of the service setting.
     */
    public val settingId: kotlin.String? = builder.settingId
    /**
     * The value of the service setting.
     */
    public val settingValue: kotlin.String? = builder.settingValue
    /**
     * The status of the service setting. The value can be Default, Customized or PendingUpdate.
     * + Default: The current setting uses a default value provisioned by the Amazon Web Services service team.
     * + Customized: The current setting use a custom value specified by the customer.
     * + PendingUpdate: The current setting uses a default or custom value, but a setting change request is pending approval.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.ServiceSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceSetting(")
        append("arn=$arn,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("lastModifiedUser=$lastModifiedUser,")
        append("settingId=$settingId,")
        append("settingValue=$settingValue,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedUser?.hashCode() ?: 0)
        result = 31 * result + (settingId?.hashCode() ?: 0)
        result = 31 * result + (settingValue?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceSetting

        if (arn != other.arn) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (lastModifiedUser != other.lastModifiedUser) return false
        if (settingId != other.settingId) return false
        if (settingValue != other.settingValue) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.ServiceSetting = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the service setting.
         */
        public var arn: kotlin.String? = null
        /**
         * The last time the service setting was modified.
         */
        public var lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the last modified user. This field is populated only if the setting value was overwritten.
         */
        public var lastModifiedUser: kotlin.String? = null
        /**
         * The ID of the service setting.
         */
        public var settingId: kotlin.String? = null
        /**
         * The value of the service setting.
         */
        public var settingValue: kotlin.String? = null
        /**
         * The status of the service setting. The value can be Default, Customized or PendingUpdate.
         * + Default: The current setting uses a default value provisioned by the Amazon Web Services service team.
         * + Customized: The current setting use a custom value specified by the customer.
         * + PendingUpdate: The current setting uses a default or custom value, but a setting change request is pending approval.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.ServiceSetting) : this() {
            this.arn = x.arn
            this.lastModifiedDate = x.lastModifiedDate
            this.lastModifiedUser = x.lastModifiedUser
            this.settingId = x.settingId
            this.settingValue = x.settingValue
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.ServiceSetting = ServiceSetting(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
