// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * Information about the source of the data included in the resource data sync.
 */
public class ResourceDataSyncSource private constructor(builder: Builder) {
    /**
     * Information about the `AwsOrganizationsSource` resource data sync source. A sync source of this type can synchronize data from Organizations.
     */
    public val awsOrganizationsSource: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncAwsOrganizationsSource? = builder.awsOrganizationsSource
    /**
     * When you create a resource data sync, if you choose one of the Organizations options, then Systems Manager automatically enables all OpsData sources in the selected Amazon Web Services Regions for all Amazon Web Services accounts in your organization (or in the selected organization units). For more information, see [About multiple account and Region resource data syncs](https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resouce-data-sync-multiple-accounts-and-regions.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val enableAllOpsDataSources: kotlin.Boolean = builder.enableAllOpsDataSources
    /**
     * Whether to automatically synchronize and aggregate data from new Amazon Web Services Regions when those Regions come online.
     */
    public val includeFutureRegions: kotlin.Boolean = builder.includeFutureRegions
    /**
     * The `SyncSource` Amazon Web Services Regions included in the resource data sync.
     */
    public val sourceRegions: List<String> = requireNotNull(builder.sourceRegions) { "A non-null value must be provided for sourceRegions" }
    /**
     * The type of data source for the resource data sync. `SourceType` is either `AwsOrganizations` (if an organization is present in Organizations) or `SingleAccountMultiRegions`.
     */
    public val sourceType: kotlin.String = requireNotNull(builder.sourceType) { "A non-null value must be provided for sourceType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.ResourceDataSyncSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceDataSyncSource(")
        append("awsOrganizationsSource=$awsOrganizationsSource,")
        append("enableAllOpsDataSources=$enableAllOpsDataSources,")
        append("includeFutureRegions=$includeFutureRegions,")
        append("sourceRegions=$sourceRegions,")
        append("sourceType=$sourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsOrganizationsSource?.hashCode() ?: 0
        result = 31 * result + (enableAllOpsDataSources.hashCode())
        result = 31 * result + (includeFutureRegions.hashCode())
        result = 31 * result + (sourceRegions.hashCode())
        result = 31 * result + (sourceType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceDataSyncSource

        if (awsOrganizationsSource != other.awsOrganizationsSource) return false
        if (enableAllOpsDataSources != other.enableAllOpsDataSources) return false
        if (includeFutureRegions != other.includeFutureRegions) return false
        if (sourceRegions != other.sourceRegions) return false
        if (sourceType != other.sourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.ResourceDataSyncSource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Information about the `AwsOrganizationsSource` resource data sync source. A sync source of this type can synchronize data from Organizations.
         */
        public var awsOrganizationsSource: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncAwsOrganizationsSource? = null
        /**
         * When you create a resource data sync, if you choose one of the Organizations options, then Systems Manager automatically enables all OpsData sources in the selected Amazon Web Services Regions for all Amazon Web Services accounts in your organization (or in the selected organization units). For more information, see [About multiple account and Region resource data syncs](https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resouce-data-sync-multiple-accounts-and-regions.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var enableAllOpsDataSources: kotlin.Boolean = false
        /**
         * Whether to automatically synchronize and aggregate data from new Amazon Web Services Regions when those Regions come online.
         */
        public var includeFutureRegions: kotlin.Boolean = false
        /**
         * The `SyncSource` Amazon Web Services Regions included in the resource data sync.
         */
        public var sourceRegions: List<String>? = null
        /**
         * The type of data source for the resource data sync. `SourceType` is either `AwsOrganizations` (if an organization is present in Organizations) or `SingleAccountMultiRegions`.
         */
        public var sourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncSource) : this() {
            this.awsOrganizationsSource = x.awsOrganizationsSource
            this.enableAllOpsDataSources = x.enableAllOpsDataSources
            this.includeFutureRegions = x.includeFutureRegions
            this.sourceRegions = x.sourceRegions
            this.sourceType = x.sourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.ResourceDataSyncSource = ResourceDataSyncSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.ResourceDataSyncAwsOrganizationsSource] inside the given [block]
         */
        public fun awsOrganizationsSource(block: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncAwsOrganizationsSource.Builder.() -> kotlin.Unit) {
            this.awsOrganizationsSource = aws.sdk.kotlin.services.ssm.model.ResourceDataSyncAwsOrganizationsSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (sourceRegions == null) sourceRegions = emptyList()
            if (sourceType == null) sourceType = ""
            return this
        }
    }
}
