// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the state of a patch on a particular managed node as it relates to the patch baseline used to patch the node.
 */
public class PatchComplianceData private constructor(builder: Builder) {
    /**
     * The classification of the patch, such as `SecurityUpdates`, `Updates`, and `CriticalUpdates`.
     */
    public val classification: kotlin.String = requireNotNull(builder.classification) { "A non-null value must be provided for classification" }
    /**
     * The IDs of one or more Common Vulnerabilities and Exposure (CVE) issues that are resolved by the patch.
     */
    public val cveIds: kotlin.String? = builder.cveIds
    /**
     * The date/time the patch was installed on the managed node. Not all operating systems provide this level of information.
     */
    public val installedTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.installedTime) { "A non-null value must be provided for installedTime" }
    /**
     * The operating system-specific ID of the patch.
     */
    public val kbId: kotlin.String = requireNotNull(builder.kbId) { "A non-null value must be provided for kbId" }
    /**
     * The severity of the patch such as `Critical`, `Important`, and `Moderate`.
     */
    public val severity: kotlin.String = requireNotNull(builder.severity) { "A non-null value must be provided for severity" }
    /**
     * The state of the patch on the managed node, such as INSTALLED or FAILED.
     *
     * For descriptions of each patch state, see [About patch compliance](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-compliance-about.html#sysman-compliance-monitor-patch) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val state: aws.sdk.kotlin.services.ssm.model.PatchComplianceDataState = requireNotNull(builder.state) { "A non-null value must be provided for state" }
    /**
     * The title of the patch.
     */
    public val title: kotlin.String = requireNotNull(builder.title) { "A non-null value must be provided for title" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.PatchComplianceData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PatchComplianceData(")
        append("classification=$classification,")
        append("cveIds=$cveIds,")
        append("installedTime=$installedTime,")
        append("kbId=$kbId,")
        append("severity=$severity,")
        append("state=$state,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = classification.hashCode()
        result = 31 * result + (cveIds?.hashCode() ?: 0)
        result = 31 * result + (installedTime.hashCode())
        result = 31 * result + (kbId.hashCode())
        result = 31 * result + (severity.hashCode())
        result = 31 * result + (state.hashCode())
        result = 31 * result + (title.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PatchComplianceData

        if (classification != other.classification) return false
        if (cveIds != other.cveIds) return false
        if (installedTime != other.installedTime) return false
        if (kbId != other.kbId) return false
        if (severity != other.severity) return false
        if (state != other.state) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.PatchComplianceData = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The classification of the patch, such as `SecurityUpdates`, `Updates`, and `CriticalUpdates`.
         */
        public var classification: kotlin.String? = null
        /**
         * The IDs of one or more Common Vulnerabilities and Exposure (CVE) issues that are resolved by the patch.
         */
        public var cveIds: kotlin.String? = null
        /**
         * The date/time the patch was installed on the managed node. Not all operating systems provide this level of information.
         */
        public var installedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The operating system-specific ID of the patch.
         */
        public var kbId: kotlin.String? = null
        /**
         * The severity of the patch such as `Critical`, `Important`, and `Moderate`.
         */
        public var severity: kotlin.String? = null
        /**
         * The state of the patch on the managed node, such as INSTALLED or FAILED.
         *
         * For descriptions of each patch state, see [About patch compliance](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-compliance-about.html#sysman-compliance-monitor-patch) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var state: aws.sdk.kotlin.services.ssm.model.PatchComplianceDataState? = null
        /**
         * The title of the patch.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.PatchComplianceData) : this() {
            this.classification = x.classification
            this.cveIds = x.cveIds
            this.installedTime = x.installedTime
            this.kbId = x.kbId
            this.severity = x.severity
            this.state = x.state
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.PatchComplianceData = PatchComplianceData(this)

        internal fun correctErrors(): Builder {
            if (classification == null) classification = ""
            if (installedTime == null) installedTime = Instant.fromEpochSeconds(0)
            if (kbId == null) kbId = ""
            if (severity == null) severity = ""
            if (state == null) state = PatchComplianceDataState.SdkUnknown("no value provided")
            if (title == null) title = ""
            return this
        }
    }
}
