// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * Defines the basic information about a patch baseline.
 */
public class PatchBaselineIdentity private constructor(builder: Builder) {
    /**
     * The description of the patch baseline.
     */
    public val baselineDescription: kotlin.String? = builder.baselineDescription
    /**
     * The ID of the patch baseline.
     */
    public val baselineId: kotlin.String? = builder.baselineId
    /**
     * The name of the patch baseline.
     */
    public val baselineName: kotlin.String? = builder.baselineName
    /**
     * Whether this is the default baseline. Amazon Web Services Systems Manager supports creating multiple default patch baselines. For example, you can create a default patch baseline for each operating system.
     */
    public val defaultBaseline: kotlin.Boolean = builder.defaultBaseline
    /**
     * Defines the operating system the patch baseline applies to. The default value is `WINDOWS`.
     */
    public val operatingSystem: aws.sdk.kotlin.services.ssm.model.OperatingSystem? = builder.operatingSystem

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.PatchBaselineIdentity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PatchBaselineIdentity(")
        append("baselineDescription=$baselineDescription,")
        append("baselineId=$baselineId,")
        append("baselineName=$baselineName,")
        append("defaultBaseline=$defaultBaseline,")
        append("operatingSystem=$operatingSystem")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = baselineDescription?.hashCode() ?: 0
        result = 31 * result + (baselineId?.hashCode() ?: 0)
        result = 31 * result + (baselineName?.hashCode() ?: 0)
        result = 31 * result + (defaultBaseline.hashCode())
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PatchBaselineIdentity

        if (baselineDescription != other.baselineDescription) return false
        if (baselineId != other.baselineId) return false
        if (baselineName != other.baselineName) return false
        if (defaultBaseline != other.defaultBaseline) return false
        if (operatingSystem != other.operatingSystem) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.PatchBaselineIdentity = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The description of the patch baseline.
         */
        public var baselineDescription: kotlin.String? = null
        /**
         * The ID of the patch baseline.
         */
        public var baselineId: kotlin.String? = null
        /**
         * The name of the patch baseline.
         */
        public var baselineName: kotlin.String? = null
        /**
         * Whether this is the default baseline. Amazon Web Services Systems Manager supports creating multiple default patch baselines. For example, you can create a default patch baseline for each operating system.
         */
        public var defaultBaseline: kotlin.Boolean = false
        /**
         * Defines the operating system the patch baseline applies to. The default value is `WINDOWS`.
         */
        public var operatingSystem: aws.sdk.kotlin.services.ssm.model.OperatingSystem? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.PatchBaselineIdentity) : this() {
            this.baselineDescription = x.baselineDescription
            this.baselineId = x.baselineId
            this.baselineName = x.baselineName
            this.defaultBaseline = x.defaultBaseline
            this.operatingSystem = x.operatingSystem
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.PatchBaselineIdentity = PatchBaselineIdentity(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
