// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



public class ModifyDocumentPermissionRequest private constructor(builder: Builder) {
    /**
     * The Amazon Web Services users that should have access to the document. The account IDs can either be a group of account IDs or *All*.
     */
    public val accountIdsToAdd: List<String>? = builder.accountIdsToAdd
    /**
     * The Amazon Web Services users that should no longer have access to the document. The Amazon Web Services user can either be a group of account IDs or *All*. This action has a higher priority than *AccountIdsToAdd*. If you specify an ID to add and the same ID to remove, the system removes access to the document.
     */
    public val accountIdsToRemove: List<String>? = builder.accountIdsToRemove
    /**
     * The name of the document that you want to share.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The permission type for the document. The permission type can be *Share*.
     */
    public val permissionType: aws.sdk.kotlin.services.ssm.model.DocumentPermissionType? = builder.permissionType
    /**
     * (Optional) The version of the document to share. If it isn't specified, the system choose the `Default` version to share.
     */
    public val sharedDocumentVersion: kotlin.String? = builder.sharedDocumentVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.ModifyDocumentPermissionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDocumentPermissionRequest(")
        append("accountIdsToAdd=$accountIdsToAdd,")
        append("accountIdsToRemove=$accountIdsToRemove,")
        append("name=$name,")
        append("permissionType=$permissionType,")
        append("sharedDocumentVersion=$sharedDocumentVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountIdsToAdd?.hashCode() ?: 0
        result = 31 * result + (accountIdsToRemove?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (permissionType?.hashCode() ?: 0)
        result = 31 * result + (sharedDocumentVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyDocumentPermissionRequest

        if (accountIdsToAdd != other.accountIdsToAdd) return false
        if (accountIdsToRemove != other.accountIdsToRemove) return false
        if (name != other.name) return false
        if (permissionType != other.permissionType) return false
        if (sharedDocumentVersion != other.sharedDocumentVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.ModifyDocumentPermissionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services users that should have access to the document. The account IDs can either be a group of account IDs or *All*.
         */
        public var accountIdsToAdd: List<String>? = null
        /**
         * The Amazon Web Services users that should no longer have access to the document. The Amazon Web Services user can either be a group of account IDs or *All*. This action has a higher priority than *AccountIdsToAdd*. If you specify an ID to add and the same ID to remove, the system removes access to the document.
         */
        public var accountIdsToRemove: List<String>? = null
        /**
         * The name of the document that you want to share.
         */
        public var name: kotlin.String? = null
        /**
         * The permission type for the document. The permission type can be *Share*.
         */
        public var permissionType: aws.sdk.kotlin.services.ssm.model.DocumentPermissionType? = null
        /**
         * (Optional) The version of the document to share. If it isn't specified, the system choose the `Default` version to share.
         */
        public var sharedDocumentVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.ModifyDocumentPermissionRequest) : this() {
            this.accountIdsToAdd = x.accountIdsToAdd
            this.accountIdsToRemove = x.accountIdsToRemove
            this.name = x.name
            this.permissionType = x.permissionType
            this.sharedDocumentVersion = x.sharedDocumentVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.ModifyDocumentPermissionRequest = ModifyDocumentPermissionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
