// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * Information about a task defined for a maintenance window.
 */
public class MaintenanceWindowTask private constructor(builder: Builder) {
    /**
     * The details for the CloudWatch alarm applied to your maintenance window task.
     */
    public val alarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = builder.alarmConfiguration
    /**
     * The specification for whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached.
     */
    public val cutoffBehavior: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskCutoffBehavior? = builder.cutoffBehavior
    /**
     * A description of the task.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Information about an S3 bucket to write task-level logs to.
     *
     * `LoggingInfo` has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the `OutputS3BucketName` and `OutputS3KeyPrefix` options in the `TaskInvocationParameters` structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
     */
    public val loggingInfo: aws.sdk.kotlin.services.ssm.model.LoggingInfo? = builder.loggingInfo
    /**
     * The maximum number of targets this task can be run for, in parallel.
     *
     * Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a [targetless task](https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html) You must provide a value in all other cases.
     *
     * For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of `1`. This value doesn't affect the running of your task.
     */
    public val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The maximum number of errors allowed before this task stops being scheduled.
     *
     * Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a [targetless task](https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html) You must provide a value in all other cases.
     *
     * For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of `1`. This value doesn't affect the running of your task.
     */
    public val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * The task name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The priority of the task in the maintenance window. The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.
     */
    public val priority: kotlin.Int = builder.priority
    /**
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.
     */
    public val serviceRoleArn: kotlin.String? = builder.serviceRoleArn
    /**
     * The targets (either managed nodes or tags). Managed nodes are specified using `Key=instanceids,Values=<instanceid1>,<instanceid2>`. Tags are specified using `Key=<tag name>,Values=<tag value>`.
     */
    public val targets: List<Target>? = builder.targets
    /**
     * The resource that the task uses during execution. For `RUN_COMMAND` and `AUTOMATION` task types, `TaskArn` is the Amazon Web Services Systems Manager (SSM document) name or ARN. For `LAMBDA` tasks, it's the function name or ARN. For `STEP_FUNCTIONS` tasks, it's the state machine ARN.
     */
    public val taskArn: kotlin.String? = builder.taskArn
    /**
     * The parameters that should be passed to the task when it is run.
     *
     * `TaskParameters` has been deprecated. To specify parameters to pass to a task when it runs, instead use the `Parameters` option in the `TaskInvocationParameters` structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
     */
    public val taskParameters: Map<String, MaintenanceWindowTaskParameterValueExpression>? = builder.taskParameters
    /**
     * The type of task.
     */
    public val type: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskType? = builder.type
    /**
     * The ID of the maintenance window where the task is registered.
     */
    public val windowId: kotlin.String? = builder.windowId
    /**
     * The task ID.
     */
    public val windowTaskId: kotlin.String? = builder.windowTaskId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTask = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MaintenanceWindowTask(")
        append("alarmConfiguration=$alarmConfiguration,")
        append("cutoffBehavior=$cutoffBehavior,")
        append("description=*** Sensitive Data Redacted ***,")
        append("loggingInfo=$loggingInfo,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("name=$name,")
        append("priority=$priority,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("targets=$targets,")
        append("taskArn=$taskArn,")
        append("taskParameters=*** Sensitive Data Redacted ***,")
        append("type=$type,")
        append("windowId=$windowId,")
        append("windowTaskId=$windowTaskId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmConfiguration?.hashCode() ?: 0
        result = 31 * result + (cutoffBehavior?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (loggingInfo?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (maxErrors?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (priority)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        result = 31 * result + (taskParameters?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (windowId?.hashCode() ?: 0)
        result = 31 * result + (windowTaskId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MaintenanceWindowTask

        if (alarmConfiguration != other.alarmConfiguration) return false
        if (cutoffBehavior != other.cutoffBehavior) return false
        if (description != other.description) return false
        if (loggingInfo != other.loggingInfo) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (name != other.name) return false
        if (priority != other.priority) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (targets != other.targets) return false
        if (taskArn != other.taskArn) return false
        if (taskParameters != other.taskParameters) return false
        if (type != other.type) return false
        if (windowId != other.windowId) return false
        if (windowTaskId != other.windowTaskId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTask = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The details for the CloudWatch alarm applied to your maintenance window task.
         */
        public var alarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = null
        /**
         * The specification for whether tasks should continue to run after the cutoff time specified in the maintenance windows is reached.
         */
        public var cutoffBehavior: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskCutoffBehavior? = null
        /**
         * A description of the task.
         */
        public var description: kotlin.String? = null
        /**
         * Information about an S3 bucket to write task-level logs to.
         *
         * `LoggingInfo` has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the `OutputS3BucketName` and `OutputS3KeyPrefix` options in the `TaskInvocationParameters` structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
         */
        public var loggingInfo: aws.sdk.kotlin.services.ssm.model.LoggingInfo? = null
        /**
         * The maximum number of targets this task can be run for, in parallel.
         *
         * Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a [targetless task](https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html) You must provide a value in all other cases.
         *
         * For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of `1`. This value doesn't affect the running of your task.
         */
        public var maxConcurrency: kotlin.String? = null
        /**
         * The maximum number of errors allowed before this task stops being scheduled.
         *
         * Although this element is listed as "Required: No", a value can be omitted only when you are registering or updating a [targetless task](https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html) You must provide a value in all other cases.
         *
         * For maintenance window tasks without a target specified, you can't supply a value for this option. Instead, the system inserts a placeholder value of `1`. This value doesn't affect the running of your task.
         */
        public var maxErrors: kotlin.String? = null
        /**
         * The task name.
         */
        public var name: kotlin.String? = null
        /**
         * The priority of the task in the maintenance window. The lower the number, the higher the priority. Tasks that have the same priority are scheduled in parallel.
         */
        public var priority: kotlin.Int = 0
        /**
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.
         */
        public var serviceRoleArn: kotlin.String? = null
        /**
         * The targets (either managed nodes or tags). Managed nodes are specified using `Key=instanceids,Values=<instanceid1>,<instanceid2>`. Tags are specified using `Key=<tag name>,Values=<tag value>`.
         */
        public var targets: List<Target>? = null
        /**
         * The resource that the task uses during execution. For `RUN_COMMAND` and `AUTOMATION` task types, `TaskArn` is the Amazon Web Services Systems Manager (SSM document) name or ARN. For `LAMBDA` tasks, it's the function name or ARN. For `STEP_FUNCTIONS` tasks, it's the state machine ARN.
         */
        public var taskArn: kotlin.String? = null
        /**
         * The parameters that should be passed to the task when it is run.
         *
         * `TaskParameters` has been deprecated. To specify parameters to pass to a task when it runs, instead use the `Parameters` option in the `TaskInvocationParameters` structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
         */
        public var taskParameters: Map<String, MaintenanceWindowTaskParameterValueExpression>? = null
        /**
         * The type of task.
         */
        public var type: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskType? = null
        /**
         * The ID of the maintenance window where the task is registered.
         */
        public var windowId: kotlin.String? = null
        /**
         * The task ID.
         */
        public var windowTaskId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTask) : this() {
            this.alarmConfiguration = x.alarmConfiguration
            this.cutoffBehavior = x.cutoffBehavior
            this.description = x.description
            this.loggingInfo = x.loggingInfo
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.name = x.name
            this.priority = x.priority
            this.serviceRoleArn = x.serviceRoleArn
            this.targets = x.targets
            this.taskArn = x.taskArn
            this.taskParameters = x.taskParameters
            this.type = x.type
            this.windowId = x.windowId
            this.windowTaskId = x.windowTaskId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTask = MaintenanceWindowTask(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.AlarmConfiguration] inside the given [block]
         */
        public fun alarmConfiguration(block: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.Builder.() -> kotlin.Unit) {
            this.alarmConfiguration = aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.LoggingInfo] inside the given [block]
         */
        public fun loggingInfo(block: aws.sdk.kotlin.services.ssm.model.LoggingInfo.Builder.() -> kotlin.Unit) {
            this.loggingInfo = aws.sdk.kotlin.services.ssm.model.LoggingInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
