// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * The parameters for a `RUN_COMMAND` task type.
 *
 * For information about specifying and updating task parameters, see RegisterTaskWithMaintenanceWindow and UpdateMaintenanceWindowTask.
 *
 * `LoggingInfo` has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the `OutputS3BucketName` and `OutputS3KeyPrefix` options in the `TaskInvocationParameters` structure. For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
 *
 * `TaskParameters` has been deprecated. To specify parameters to pass to a task when it runs, instead use the `Parameters` option in the `TaskInvocationParameters` structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
 *
 * For `RUN_COMMAND` tasks, Systems Manager uses specified values for `TaskParameters` and `LoggingInfo` only if no values are specified for `TaskInvocationParameters`.
 */
public class MaintenanceWindowRunCommandParameters private constructor(builder: Builder) {
    /**
     * Configuration options for sending command output to Amazon CloudWatch Logs.
     */
    public val cloudWatchOutputConfig: aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig? = builder.cloudWatchOutputConfig
    /**
     * Information about the commands to run.
     */
    public val comment: kotlin.String? = builder.comment
    /**
     * The SHA-256 or SHA-1 hash created by the system when the document was created. SHA-1 hashes have been deprecated.
     */
    public val documentHash: kotlin.String? = builder.documentHash
    /**
     * SHA-256 or SHA-1. SHA-1 hashes have been deprecated.
     */
    public val documentHashType: aws.sdk.kotlin.services.ssm.model.DocumentHashType? = builder.documentHashType
    /**
     * The Amazon Web Services Systems Manager document (SSM document) version to use in the request. You can specify `$DEFAULT`, `$LATEST`, or a specific version number. If you run commands by using the Amazon Web Services CLI, then you must escape the first two options by using a backslash. If you specify a version number, then you don't need to use the backslash. For example:
     *
     * `--document-version "\$DEFAULT"`
     *
     * `--document-version "\$LATEST"`
     *
     * `--document-version "3"`
     */
    public val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * Configurations for sending notifications about command status changes on a per-managed node basis.
     */
    public val notificationConfig: aws.sdk.kotlin.services.ssm.model.NotificationConfig? = builder.notificationConfig
    /**
     * The name of the Amazon Simple Storage Service (Amazon S3) bucket.
     */
    public val outputS3BucketName: kotlin.String? = builder.outputS3BucketName
    /**
     * The S3 bucket subfolder.
     */
    public val outputS3KeyPrefix: kotlin.String? = builder.outputS3KeyPrefix
    /**
     * The parameters for the `RUN_COMMAND` task execution.
     */
    public val parameters: Map<String, List<String>>? = builder.parameters
    /**
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.
     */
    public val serviceRoleArn: kotlin.String? = builder.serviceRoleArn
    /**
     * If this time is reached and the command hasn't already started running, it doesn't run.
     */
    public val timeoutSeconds: kotlin.Int? = builder.timeoutSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowRunCommandParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MaintenanceWindowRunCommandParameters(")
        append("cloudWatchOutputConfig=$cloudWatchOutputConfig,")
        append("comment=$comment,")
        append("documentHash=$documentHash,")
        append("documentHashType=$documentHashType,")
        append("documentVersion=$documentVersion,")
        append("notificationConfig=$notificationConfig,")
        append("outputS3BucketName=$outputS3BucketName,")
        append("outputS3KeyPrefix=$outputS3KeyPrefix,")
        append("parameters=*** Sensitive Data Redacted ***,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("timeoutSeconds=$timeoutSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchOutputConfig?.hashCode() ?: 0
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (documentHash?.hashCode() ?: 0)
        result = 31 * result + (documentHashType?.hashCode() ?: 0)
        result = 31 * result + (documentVersion?.hashCode() ?: 0)
        result = 31 * result + (notificationConfig?.hashCode() ?: 0)
        result = 31 * result + (outputS3BucketName?.hashCode() ?: 0)
        result = 31 * result + (outputS3KeyPrefix?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (timeoutSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MaintenanceWindowRunCommandParameters

        if (cloudWatchOutputConfig != other.cloudWatchOutputConfig) return false
        if (comment != other.comment) return false
        if (documentHash != other.documentHash) return false
        if (documentHashType != other.documentHashType) return false
        if (documentVersion != other.documentVersion) return false
        if (notificationConfig != other.notificationConfig) return false
        if (outputS3BucketName != other.outputS3BucketName) return false
        if (outputS3KeyPrefix != other.outputS3KeyPrefix) return false
        if (parameters != other.parameters) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (timeoutSeconds != other.timeoutSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowRunCommandParameters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Configuration options for sending command output to Amazon CloudWatch Logs.
         */
        public var cloudWatchOutputConfig: aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig? = null
        /**
         * Information about the commands to run.
         */
        public var comment: kotlin.String? = null
        /**
         * The SHA-256 or SHA-1 hash created by the system when the document was created. SHA-1 hashes have been deprecated.
         */
        public var documentHash: kotlin.String? = null
        /**
         * SHA-256 or SHA-1. SHA-1 hashes have been deprecated.
         */
        public var documentHashType: aws.sdk.kotlin.services.ssm.model.DocumentHashType? = null
        /**
         * The Amazon Web Services Systems Manager document (SSM document) version to use in the request. You can specify `$DEFAULT`, `$LATEST`, or a specific version number. If you run commands by using the Amazon Web Services CLI, then you must escape the first two options by using a backslash. If you specify a version number, then you don't need to use the backslash. For example:
         *
         * `--document-version "\$DEFAULT"`
         *
         * `--document-version "\$LATEST"`
         *
         * `--document-version "3"`
         */
        public var documentVersion: kotlin.String? = null
        /**
         * Configurations for sending notifications about command status changes on a per-managed node basis.
         */
        public var notificationConfig: aws.sdk.kotlin.services.ssm.model.NotificationConfig? = null
        /**
         * The name of the Amazon Simple Storage Service (Amazon S3) bucket.
         */
        public var outputS3BucketName: kotlin.String? = null
        /**
         * The S3 bucket subfolder.
         */
        public var outputS3KeyPrefix: kotlin.String? = null
        /**
         * The parameters for the `RUN_COMMAND` task execution.
         */
        public var parameters: Map<String, List<String>>? = null
        /**
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications for maintenance window Run Command tasks.
         */
        public var serviceRoleArn: kotlin.String? = null
        /**
         * If this time is reached and the command hasn't already started running, it doesn't run.
         */
        public var timeoutSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowRunCommandParameters) : this() {
            this.cloudWatchOutputConfig = x.cloudWatchOutputConfig
            this.comment = x.comment
            this.documentHash = x.documentHash
            this.documentHashType = x.documentHashType
            this.documentVersion = x.documentVersion
            this.notificationConfig = x.notificationConfig
            this.outputS3BucketName = x.outputS3BucketName
            this.outputS3KeyPrefix = x.outputS3KeyPrefix
            this.parameters = x.parameters
            this.serviceRoleArn = x.serviceRoleArn
            this.timeoutSeconds = x.timeoutSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowRunCommandParameters = MaintenanceWindowRunCommandParameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig] inside the given [block]
         */
        public fun cloudWatchOutputConfig(block: aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig.Builder.() -> kotlin.Unit) {
            this.cloudWatchOutputConfig = aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.NotificationConfig] inside the given [block]
         */
        public fun notificationConfig(block: aws.sdk.kotlin.services.ssm.model.NotificationConfig.Builder.() -> kotlin.Unit) {
            this.notificationConfig = aws.sdk.kotlin.services.ssm.model.NotificationConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
