// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * Information collected from managed nodes based on your inventory policy document
 */
public class InventoryItem private constructor(builder: Builder) {
    /**
     * The time the inventory information was collected.
     */
    public val captureTime: kotlin.String = requireNotNull(builder.captureTime) { "A non-null value must be provided for captureTime" }
    /**
     * The inventory data of the inventory type.
     */
    public val content: List<Map<String, String>>? = builder.content
    /**
     * MD5 hash of the inventory item type contents. The content hash is used to determine whether to update inventory information. The PutInventory API doesn't update the inventory item type contents if the MD5 hash hasn't changed since last update.
     */
    public val contentHash: kotlin.String? = builder.contentHash
    /**
     * A map of associated properties for a specified inventory type. For example, with this attribute, you can specify the `ExecutionId`, `ExecutionType`, `ComplianceType` properties of the `AWS:ComplianceItem` type.
     */
    public val context: Map<String, String>? = builder.context
    /**
     * The schema version for the inventory item.
     */
    public val schemaVersion: kotlin.String = requireNotNull(builder.schemaVersion) { "A non-null value must be provided for schemaVersion" }
    /**
     * The name of the inventory type. Default inventory item type names start with `AWS`. Custom inventory type names will start with Custom. Default inventory item types include the following: `AWS:AWSComponent`, `AWS:Application`, `AWS:InstanceInformation`, `AWS:Network`, and `AWS:WindowsUpdate`.
     */
    public val typeName: kotlin.String = requireNotNull(builder.typeName) { "A non-null value must be provided for typeName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.InventoryItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InventoryItem(")
        append("captureTime=$captureTime,")
        append("content=$content,")
        append("contentHash=$contentHash,")
        append("context=$context,")
        append("schemaVersion=$schemaVersion,")
        append("typeName=$typeName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = captureTime.hashCode()
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (contentHash?.hashCode() ?: 0)
        result = 31 * result + (context?.hashCode() ?: 0)
        result = 31 * result + (schemaVersion.hashCode())
        result = 31 * result + (typeName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InventoryItem

        if (captureTime != other.captureTime) return false
        if (content != other.content) return false
        if (contentHash != other.contentHash) return false
        if (context != other.context) return false
        if (schemaVersion != other.schemaVersion) return false
        if (typeName != other.typeName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.InventoryItem = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time the inventory information was collected.
         */
        public var captureTime: kotlin.String? = null
        /**
         * The inventory data of the inventory type.
         */
        public var content: List<Map<String, String>>? = null
        /**
         * MD5 hash of the inventory item type contents. The content hash is used to determine whether to update inventory information. The PutInventory API doesn't update the inventory item type contents if the MD5 hash hasn't changed since last update.
         */
        public var contentHash: kotlin.String? = null
        /**
         * A map of associated properties for a specified inventory type. For example, with this attribute, you can specify the `ExecutionId`, `ExecutionType`, `ComplianceType` properties of the `AWS:ComplianceItem` type.
         */
        public var context: Map<String, String>? = null
        /**
         * The schema version for the inventory item.
         */
        public var schemaVersion: kotlin.String? = null
        /**
         * The name of the inventory type. Default inventory item type names start with `AWS`. Custom inventory type names will start with Custom. Default inventory item types include the following: `AWS:AWSComponent`, `AWS:Application`, `AWS:InstanceInformation`, `AWS:Network`, and `AWS:WindowsUpdate`.
         */
        public var typeName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.InventoryItem) : this() {
            this.captureTime = x.captureTime
            this.content = x.content
            this.contentHash = x.contentHash
            this.context = x.context
            this.schemaVersion = x.schemaVersion
            this.typeName = x.typeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.InventoryItem = InventoryItem(this)

        internal fun correctErrors(): Builder {
            if (captureTime == null) captureTime = ""
            if (schemaVersion == null) schemaVersion = ""
            if (typeName == null) typeName = ""
            return this
        }
    }
}
