// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * One or more filters. Use a filter to return a more specific list of results.
 */
public class InventoryFilter private constructor(builder: Builder) {
    /**
     * The name of the filter key.
     */
    public val key: kotlin.String = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * The type of filter.
     *
     * The `Exists` filter must be used with aggregators. For more information, see [Aggregating inventory data](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-aggregate.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val type: aws.sdk.kotlin.services.ssm.model.InventoryQueryOperatorType? = builder.type
    /**
     * Inventory filter values. Example: inventory filter where managed node IDs are specified as values `Key=AWS:InstanceInformation.InstanceId,Values= i-a12b3c4d5e6g, i-1a2b3c4d5e6,Type=Equal`.
     */
    public val values: List<String> = requireNotNull(builder.values) { "A non-null value must be provided for values" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.InventoryFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InventoryFilter(")
        append("key=$key,")
        append("type=$type,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = key.hashCode()
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (values.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InventoryFilter

        if (key != other.key) return false
        if (type != other.type) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.InventoryFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the filter key.
         */
        public var key: kotlin.String? = null
        /**
         * The type of filter.
         *
         * The `Exists` filter must be used with aggregators. For more information, see [Aggregating inventory data](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-aggregate.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var type: aws.sdk.kotlin.services.ssm.model.InventoryQueryOperatorType? = null
        /**
         * Inventory filter values. Example: inventory filter where managed node IDs are specified as values `Key=AWS:InstanceInformation.InstanceId,Values= i-a12b3c4d5e6g, i-1a2b3c4d5e6,Type=Equal`.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.InventoryFilter) : this() {
            this.key = x.key
            this.type = x.type
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.InventoryFilter = InventoryFilter(this)

        internal fun correctErrors(): Builder {
            if (key == null) key = ""
            if (values == null) values = emptyList()
            return this
        }
    }
}
