// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * Defines a filter used in DescribeInstancePatchStatesForPatchGroup to scope down the information returned by the API.
 *
 * **Example**: To filter for all managed nodes in a patch group having more than three patches with a `FailedCount` status, use the following for the filter:
 * + Value for `Key`: `FailedCount`
 * + Value for `Type`: `GreaterThan`
 * + Value for `Values`: `3`
 */
public class InstancePatchStateFilter private constructor(builder: Builder) {
    /**
     * The key for the filter. Supported values include the following:
     * + `InstalledCount`
     * + `InstalledOtherCount`
     * + `InstalledPendingRebootCount`
     * + `InstalledRejectedCount`
     * + `MissingCount`
     * + `FailedCount`
     * + `UnreportedNotApplicableCount`
     * + `NotApplicableCount`
     */
    public val key: kotlin.String = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * The type of comparison that should be performed for the value.
     */
    public val type: aws.sdk.kotlin.services.ssm.model.InstancePatchStateOperatorType = requireNotNull(builder.type) { "A non-null value must be provided for type" }
    /**
     * The value for the filter. Must be an integer greater than or equal to 0.
     */
    public val values: List<String> = requireNotNull(builder.values) { "A non-null value must be provided for values" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.InstancePatchStateFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstancePatchStateFilter(")
        append("key=$key,")
        append("type=$type,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = key.hashCode()
        result = 31 * result + (type.hashCode())
        result = 31 * result + (values.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstancePatchStateFilter

        if (key != other.key) return false
        if (type != other.type) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.InstancePatchStateFilter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The key for the filter. Supported values include the following:
         * + `InstalledCount`
         * + `InstalledOtherCount`
         * + `InstalledPendingRebootCount`
         * + `InstalledRejectedCount`
         * + `MissingCount`
         * + `FailedCount`
         * + `UnreportedNotApplicableCount`
         * + `NotApplicableCount`
         */
        public var key: kotlin.String? = null
        /**
         * The type of comparison that should be performed for the value.
         */
        public var type: aws.sdk.kotlin.services.ssm.model.InstancePatchStateOperatorType? = null
        /**
         * The value for the filter. Must be an integer greater than or equal to 0.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.InstancePatchStateFilter) : this() {
            this.key = x.key
            this.type = x.type
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.InstancePatchStateFilter = InstancePatchStateFilter(this)

        internal fun correctErrors(): Builder {
            if (key == null) key = ""
            if (type == null) type = InstancePatchStateOperatorType.SdkUnknown("no value provided")
            if (values == null) values = emptyList()
            return this
        }
    }
}
