// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



public class GetParametersByPathRequest private constructor(builder: Builder) {
    /**
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A token to start the list. Use this token to get the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Filters to limit the request results.
     *
     * The following `Key` values are supported for `GetParametersByPath`: `Type`, `KeyId`, and `Label`.
     *
     * The following `Key` values aren't supported for `GetParametersByPath`: `tag`, `DataType`, `Name`, `Path`, and `Tier`.
     */
    public val parameterFilters: List<ParameterStringFilter>? = builder.parameterFilters
    /**
     * The hierarchy for the parameter. Hierarchies start with a forward slash (/). The hierarchy is the parameter name except the last part of the parameter. For the API call to succeed, the last part of the parameter name can't be in the path. A parameter name hierarchy can have a maximum of 15 levels. Here is an example of a hierarchy: `/Finance/Prod/IAD/WinServ2016/license33 `
     */
    public val path: kotlin.String? = builder.path
    /**
     * Retrieve all parameters within a hierarchy.
     *
     * If a user has access to a path, then the user can access all levels of that path. For example, if a user has permission to access path `/a`, then the user can also access `/a/b`. Even if a user has explicitly been denied access in IAM for parameter `/a/b`, they can still call the GetParametersByPath API operation recursively for `/a` and view `/a/b`.
     */
    public val recursive: kotlin.Boolean? = builder.recursive
    /**
     * Retrieve all parameters in a hierarchy with their value decrypted.
     */
    public val withDecryption: kotlin.Boolean? = builder.withDecryption

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.GetParametersByPathRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetParametersByPathRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("parameterFilters=$parameterFilters,")
        append("path=$path,")
        append("recursive=$recursive,")
        append("withDecryption=$withDecryption")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (parameterFilters?.hashCode() ?: 0)
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (recursive?.hashCode() ?: 0)
        result = 31 * result + (withDecryption?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetParametersByPathRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (parameterFilters != other.parameterFilters) return false
        if (path != other.path) return false
        if (recursive != other.recursive) return false
        if (withDecryption != other.withDecryption) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.GetParametersByPathRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a subsequent call to get the next set of results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A token to start the list. Use this token to get the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Filters to limit the request results.
         *
         * The following `Key` values are supported for `GetParametersByPath`: `Type`, `KeyId`, and `Label`.
         *
         * The following `Key` values aren't supported for `GetParametersByPath`: `tag`, `DataType`, `Name`, `Path`, and `Tier`.
         */
        public var parameterFilters: List<ParameterStringFilter>? = null
        /**
         * The hierarchy for the parameter. Hierarchies start with a forward slash (/). The hierarchy is the parameter name except the last part of the parameter. For the API call to succeed, the last part of the parameter name can't be in the path. A parameter name hierarchy can have a maximum of 15 levels. Here is an example of a hierarchy: `/Finance/Prod/IAD/WinServ2016/license33 `
         */
        public var path: kotlin.String? = null
        /**
         * Retrieve all parameters within a hierarchy.
         *
         * If a user has access to a path, then the user can access all levels of that path. For example, if a user has permission to access path `/a`, then the user can also access `/a/b`. Even if a user has explicitly been denied access in IAM for parameter `/a/b`, they can still call the GetParametersByPath API operation recursively for `/a` and view `/a/b`.
         */
        public var recursive: kotlin.Boolean? = null
        /**
         * Retrieve all parameters in a hierarchy with their value decrypted.
         */
        public var withDecryption: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.GetParametersByPathRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.parameterFilters = x.parameterFilters
            this.path = x.path
            this.recursive = x.recursive
            this.withDecryption = x.withDecryption
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.GetParametersByPathRequest = GetParametersByPathRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
