// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetMaintenanceWindowExecutionTaskResponse private constructor(builder: Builder) {
    /**
     * The details for the CloudWatch alarm you applied to your maintenance window task.
     */
    public val alarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = builder.alarmConfiguration
    /**
     * The time the task execution completed.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The defined maximum number of task executions that could be run in parallel.
     */
    public val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The defined maximum number of task execution errors allowed before scheduling of the task execution would have been stopped.
     */
    public val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * The priority of the task.
     */
    public val priority: kotlin.Int = builder.priority
    /**
     * The role that was assumed when running the task.
     */
    public val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * The time the task execution started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the task.
     */
    public val status: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionStatus? = builder.status
    /**
     * The details explaining the status. Not available for all status values.
     */
    public val statusDetails: kotlin.String? = builder.statusDetails
    /**
     * The Amazon Resource Name (ARN) of the task that ran.
     */
    public val taskArn: kotlin.String? = builder.taskArn
    /**
     * The ID of the specific task execution in the maintenance window task that was retrieved.
     */
    public val taskExecutionId: kotlin.String? = builder.taskExecutionId
    /**
     * The parameters passed to the task when it was run.
     *
     * `TaskParameters` has been deprecated. To specify parameters to pass to a task when it runs, instead use the `Parameters` option in the `TaskInvocationParameters` structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
     *
     * The map has the following format:
     * + `Key`: string, between 1 and 255 characters
     * + `Value`: an array of strings, each between 1 and 255 characters
     */
    public val taskParameters: List<Map<String, MaintenanceWindowTaskParameterValueExpression>>? = builder.taskParameters
    /**
     * The CloudWatch alarms that were invoked by the maintenance window task.
     */
    public val triggeredAlarms: List<AlarmStateInformation>? = builder.triggeredAlarms
    /**
     * The type of task that was run.
     */
    public val type: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskType? = builder.type
    /**
     * The ID of the maintenance window execution that includes the task.
     */
    public val windowExecutionId: kotlin.String? = builder.windowExecutionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMaintenanceWindowExecutionTaskResponse(")
        append("alarmConfiguration=$alarmConfiguration,")
        append("endTime=$endTime,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("priority=$priority,")
        append("serviceRole=$serviceRole,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("statusDetails=$statusDetails,")
        append("taskArn=$taskArn,")
        append("taskExecutionId=$taskExecutionId,")
        append("taskParameters=*** Sensitive Data Redacted ***,")
        append("triggeredAlarms=$triggeredAlarms,")
        append("type=$type,")
        append("windowExecutionId=$windowExecutionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmConfiguration?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (maxErrors?.hashCode() ?: 0)
        result = 31 * result + (priority)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        result = 31 * result + (taskExecutionId?.hashCode() ?: 0)
        result = 31 * result + (taskParameters?.hashCode() ?: 0)
        result = 31 * result + (triggeredAlarms?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (windowExecutionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMaintenanceWindowExecutionTaskResponse

        if (alarmConfiguration != other.alarmConfiguration) return false
        if (endTime != other.endTime) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (priority != other.priority) return false
        if (serviceRole != other.serviceRole) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false
        if (taskArn != other.taskArn) return false
        if (taskExecutionId != other.taskExecutionId) return false
        if (taskParameters != other.taskParameters) return false
        if (triggeredAlarms != other.triggeredAlarms) return false
        if (type != other.type) return false
        if (windowExecutionId != other.windowExecutionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The details for the CloudWatch alarm you applied to your maintenance window task.
         */
        public var alarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = null
        /**
         * The time the task execution completed.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The defined maximum number of task executions that could be run in parallel.
         */
        public var maxConcurrency: kotlin.String? = null
        /**
         * The defined maximum number of task execution errors allowed before scheduling of the task execution would have been stopped.
         */
        public var maxErrors: kotlin.String? = null
        /**
         * The priority of the task.
         */
        public var priority: kotlin.Int = 0
        /**
         * The role that was assumed when running the task.
         */
        public var serviceRole: kotlin.String? = null
        /**
         * The time the task execution started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the task.
         */
        public var status: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionStatus? = null
        /**
         * The details explaining the status. Not available for all status values.
         */
        public var statusDetails: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the task that ran.
         */
        public var taskArn: kotlin.String? = null
        /**
         * The ID of the specific task execution in the maintenance window task that was retrieved.
         */
        public var taskExecutionId: kotlin.String? = null
        /**
         * The parameters passed to the task when it was run.
         *
         * `TaskParameters` has been deprecated. To specify parameters to pass to a task when it runs, instead use the `Parameters` option in the `TaskInvocationParameters` structure. For information about how Systems Manager handles these options for the supported maintenance window task types, see MaintenanceWindowTaskInvocationParameters.
         *
         * The map has the following format:
         * + `Key`: string, between 1 and 255 characters
         * + `Value`: an array of strings, each between 1 and 255 characters
         */
        public var taskParameters: List<Map<String, MaintenanceWindowTaskParameterValueExpression>>? = null
        /**
         * The CloudWatch alarms that were invoked by the maintenance window task.
         */
        public var triggeredAlarms: List<AlarmStateInformation>? = null
        /**
         * The type of task that was run.
         */
        public var type: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskType? = null
        /**
         * The ID of the maintenance window execution that includes the task.
         */
        public var windowExecutionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse) : this() {
            this.alarmConfiguration = x.alarmConfiguration
            this.endTime = x.endTime
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.priority = x.priority
            this.serviceRole = x.serviceRole
            this.startTime = x.startTime
            this.status = x.status
            this.statusDetails = x.statusDetails
            this.taskArn = x.taskArn
            this.taskExecutionId = x.taskExecutionId
            this.taskParameters = x.taskParameters
            this.triggeredAlarms = x.triggeredAlarms
            this.type = x.type
            this.windowExecutionId = x.windowExecutionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse = GetMaintenanceWindowExecutionTaskResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.AlarmConfiguration] inside the given [block]
         */
        public fun alarmConfiguration(block: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.Builder.() -> kotlin.Unit) {
            this.alarmConfiguration = aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
