// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



public class GetCommandInvocationResponse private constructor(builder: Builder) {
    /**
     * Amazon CloudWatch Logs information where Systems Manager sent the command output.
     */
    public val cloudWatchOutputConfig: aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig? = builder.cloudWatchOutputConfig
    /**
     * The parent command ID of the invocation plugin.
     */
    public val commandId: kotlin.String? = builder.commandId
    /**
     * The comment text for the command.
     */
    public val comment: kotlin.String? = builder.comment
    /**
     * The name of the document that was run. For example, `AWS-RunShellScript`.
     */
    public val documentName: kotlin.String? = builder.documentName
    /**
     * The Systems Manager document (SSM document) version used in the request.
     */
    public val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * Duration since `ExecutionStartDateTime`.
     */
    public val executionElapsedTime: kotlin.String? = builder.executionElapsedTime
    /**
     * The date and time the plugin finished running. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the `InvokedAfter` filter.
     *
     * `aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z`
     *
     * If the plugin hasn't started to run, the string is empty.
     */
    public val executionEndDateTime: kotlin.String? = builder.executionEndDateTime
    /**
     * The date and time the plugin started running. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the `InvokedBefore` filter.
     *
     * `aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z`
     *
     * If the plugin hasn't started to run, the string is empty.
     */
    public val executionStartDateTime: kotlin.String? = builder.executionStartDateTime
    /**
     * The ID of the managed node targeted by the command. A *managed node* can be an Amazon Elastic Compute Cloud (Amazon EC2) instance, edge device, or on-premises server or VM in your hybrid environment that is configured for Amazon Web Services Systems Manager.
     */
    public val instanceId: kotlin.String? = builder.instanceId
    /**
     * The name of the plugin, or *step name*, for which details are reported. For example, `aws:RunShellScript` is a plugin.
     */
    public val pluginName: kotlin.String? = builder.pluginName
    /**
     * The error level response code for the plugin script. If the response code is `-1`, then the command hasn't started running on the managed node, or it wasn't received by the node.
     */
    public val responseCode: kotlin.Int = builder.responseCode
    /**
     * The first 8,000 characters written by the plugin to `stderr`. If the command hasn't finished running, then this string is empty.
     */
    public val standardErrorContent: kotlin.String? = builder.standardErrorContent
    /**
     * The URL for the complete text written by the plugin to `stderr`. If the command hasn't finished running, then this string is empty.
     */
    public val standardErrorUrl: kotlin.String? = builder.standardErrorUrl
    /**
     * The first 24,000 characters written by the plugin to `stdout`. If the command hasn't finished running, if `ExecutionStatus` is neither Succeeded nor Failed, then this string is empty.
     */
    public val standardOutputContent: kotlin.String? = builder.standardOutputContent
    /**
     * The URL for the complete text written by the plugin to `stdout` in Amazon Simple Storage Service (Amazon S3). If an S3 bucket wasn't specified, then this string is empty.
     */
    public val standardOutputUrl: kotlin.String? = builder.standardOutputUrl
    /**
     * The status of this invocation plugin. This status can be different than `StatusDetails`.
     */
    public val status: aws.sdk.kotlin.services.ssm.model.CommandInvocationStatus? = builder.status
    /**
     * A detailed status of the command execution for an invocation. `StatusDetails` includes more information than `Status` because it includes states resulting from error and concurrency control parameters. `StatusDetails` can show different results than `Status`. For more information about these statuses, see [Understanding command statuses](https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html) in the *Amazon Web Services Systems Manager User Guide*. `StatusDetails` can be one of the following values:
     * + Pending: The command hasn't been sent to the managed node.
     * + In Progress: The command has been sent to the managed node but hasn't reached a terminal state.
     * + Delayed: The system attempted to send the command to the target, but the target wasn't available. The managed node might not be available because of network issues, because the node was stopped, or for similar reasons. The system will try to send the command again.
     * + Success: The command or plugin ran successfully. This is a terminal state.
     * + Delivery Timed Out: The command wasn't delivered to the managed node before the delivery timeout expired. Delivery timeouts don't count against the parent command's `MaxErrors` limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
     * + Execution Timed Out: The command started to run on the managed node, but the execution wasn't complete before the timeout expired. Execution timeouts count against the `MaxErrors` limit of the parent command. This is a terminal state.
     * + Failed: The command wasn't run successfully on the managed node. For a plugin, this indicates that the result code wasn't zero. For a command invocation, this indicates that the result code for one or more plugins wasn't zero. Invocation failures count against the `MaxErrors` limit of the parent command. This is a terminal state.
     * + Cancelled: The command was terminated before it was completed. This is a terminal state.
     * + Undeliverable: The command can't be delivered to the managed node. The node might not exist or might not be responding. Undeliverable invocations don't count against the parent command's `MaxErrors` limit and don't contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
     * + Terminated: The parent command exceeded its `MaxErrors` limit and subsequent command invocations were canceled by the system. This is a terminal state.
     */
    public val statusDetails: kotlin.String? = builder.statusDetails

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.GetCommandInvocationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetCommandInvocationResponse(")
        append("cloudWatchOutputConfig=$cloudWatchOutputConfig,")
        append("commandId=$commandId,")
        append("comment=$comment,")
        append("documentName=$documentName,")
        append("documentVersion=$documentVersion,")
        append("executionElapsedTime=$executionElapsedTime,")
        append("executionEndDateTime=$executionEndDateTime,")
        append("executionStartDateTime=$executionStartDateTime,")
        append("instanceId=$instanceId,")
        append("pluginName=$pluginName,")
        append("responseCode=$responseCode,")
        append("standardErrorContent=$standardErrorContent,")
        append("standardErrorUrl=$standardErrorUrl,")
        append("standardOutputContent=$standardOutputContent,")
        append("standardOutputUrl=$standardOutputUrl,")
        append("status=$status,")
        append("statusDetails=$statusDetails")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchOutputConfig?.hashCode() ?: 0
        result = 31 * result + (commandId?.hashCode() ?: 0)
        result = 31 * result + (comment?.hashCode() ?: 0)
        result = 31 * result + (documentName?.hashCode() ?: 0)
        result = 31 * result + (documentVersion?.hashCode() ?: 0)
        result = 31 * result + (executionElapsedTime?.hashCode() ?: 0)
        result = 31 * result + (executionEndDateTime?.hashCode() ?: 0)
        result = 31 * result + (executionStartDateTime?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (pluginName?.hashCode() ?: 0)
        result = 31 * result + (responseCode)
        result = 31 * result + (standardErrorContent?.hashCode() ?: 0)
        result = 31 * result + (standardErrorUrl?.hashCode() ?: 0)
        result = 31 * result + (standardOutputContent?.hashCode() ?: 0)
        result = 31 * result + (standardOutputUrl?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetCommandInvocationResponse

        if (cloudWatchOutputConfig != other.cloudWatchOutputConfig) return false
        if (commandId != other.commandId) return false
        if (comment != other.comment) return false
        if (documentName != other.documentName) return false
        if (documentVersion != other.documentVersion) return false
        if (executionElapsedTime != other.executionElapsedTime) return false
        if (executionEndDateTime != other.executionEndDateTime) return false
        if (executionStartDateTime != other.executionStartDateTime) return false
        if (instanceId != other.instanceId) return false
        if (pluginName != other.pluginName) return false
        if (responseCode != other.responseCode) return false
        if (standardErrorContent != other.standardErrorContent) return false
        if (standardErrorUrl != other.standardErrorUrl) return false
        if (standardOutputContent != other.standardOutputContent) return false
        if (standardOutputUrl != other.standardOutputUrl) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.GetCommandInvocationResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Amazon CloudWatch Logs information where Systems Manager sent the command output.
         */
        public var cloudWatchOutputConfig: aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig? = null
        /**
         * The parent command ID of the invocation plugin.
         */
        public var commandId: kotlin.String? = null
        /**
         * The comment text for the command.
         */
        public var comment: kotlin.String? = null
        /**
         * The name of the document that was run. For example, `AWS-RunShellScript`.
         */
        public var documentName: kotlin.String? = null
        /**
         * The Systems Manager document (SSM document) version used in the request.
         */
        public var documentVersion: kotlin.String? = null
        /**
         * Duration since `ExecutionStartDateTime`.
         */
        public var executionElapsedTime: kotlin.String? = null
        /**
         * The date and time the plugin finished running. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the `InvokedAfter` filter.
         *
         * `aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z`
         *
         * If the plugin hasn't started to run, the string is empty.
         */
        public var executionEndDateTime: kotlin.String? = null
        /**
         * The date and time the plugin started running. Date and time are written in ISO 8601 format. For example, June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the `InvokedBefore` filter.
         *
         * `aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z`
         *
         * If the plugin hasn't started to run, the string is empty.
         */
        public var executionStartDateTime: kotlin.String? = null
        /**
         * The ID of the managed node targeted by the command. A *managed node* can be an Amazon Elastic Compute Cloud (Amazon EC2) instance, edge device, or on-premises server or VM in your hybrid environment that is configured for Amazon Web Services Systems Manager.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The name of the plugin, or *step name*, for which details are reported. For example, `aws:RunShellScript` is a plugin.
         */
        public var pluginName: kotlin.String? = null
        /**
         * The error level response code for the plugin script. If the response code is `-1`, then the command hasn't started running on the managed node, or it wasn't received by the node.
         */
        public var responseCode: kotlin.Int = 0
        /**
         * The first 8,000 characters written by the plugin to `stderr`. If the command hasn't finished running, then this string is empty.
         */
        public var standardErrorContent: kotlin.String? = null
        /**
         * The URL for the complete text written by the plugin to `stderr`. If the command hasn't finished running, then this string is empty.
         */
        public var standardErrorUrl: kotlin.String? = null
        /**
         * The first 24,000 characters written by the plugin to `stdout`. If the command hasn't finished running, if `ExecutionStatus` is neither Succeeded nor Failed, then this string is empty.
         */
        public var standardOutputContent: kotlin.String? = null
        /**
         * The URL for the complete text written by the plugin to `stdout` in Amazon Simple Storage Service (Amazon S3). If an S3 bucket wasn't specified, then this string is empty.
         */
        public var standardOutputUrl: kotlin.String? = null
        /**
         * The status of this invocation plugin. This status can be different than `StatusDetails`.
         */
        public var status: aws.sdk.kotlin.services.ssm.model.CommandInvocationStatus? = null
        /**
         * A detailed status of the command execution for an invocation. `StatusDetails` includes more information than `Status` because it includes states resulting from error and concurrency control parameters. `StatusDetails` can show different results than `Status`. For more information about these statuses, see [Understanding command statuses](https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html) in the *Amazon Web Services Systems Manager User Guide*. `StatusDetails` can be one of the following values:
         * + Pending: The command hasn't been sent to the managed node.
         * + In Progress: The command has been sent to the managed node but hasn't reached a terminal state.
         * + Delayed: The system attempted to send the command to the target, but the target wasn't available. The managed node might not be available because of network issues, because the node was stopped, or for similar reasons. The system will try to send the command again.
         * + Success: The command or plugin ran successfully. This is a terminal state.
         * + Delivery Timed Out: The command wasn't delivered to the managed node before the delivery timeout expired. Delivery timeouts don't count against the parent command's `MaxErrors` limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
         * + Execution Timed Out: The command started to run on the managed node, but the execution wasn't complete before the timeout expired. Execution timeouts count against the `MaxErrors` limit of the parent command. This is a terminal state.
         * + Failed: The command wasn't run successfully on the managed node. For a plugin, this indicates that the result code wasn't zero. For a command invocation, this indicates that the result code for one or more plugins wasn't zero. Invocation failures count against the `MaxErrors` limit of the parent command. This is a terminal state.
         * + Cancelled: The command was terminated before it was completed. This is a terminal state.
         * + Undeliverable: The command can't be delivered to the managed node. The node might not exist or might not be responding. Undeliverable invocations don't count against the parent command's `MaxErrors` limit and don't contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
         * + Terminated: The parent command exceeded its `MaxErrors` limit and subsequent command invocations were canceled by the system. This is a terminal state.
         */
        public var statusDetails: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.GetCommandInvocationResponse) : this() {
            this.cloudWatchOutputConfig = x.cloudWatchOutputConfig
            this.commandId = x.commandId
            this.comment = x.comment
            this.documentName = x.documentName
            this.documentVersion = x.documentVersion
            this.executionElapsedTime = x.executionElapsedTime
            this.executionEndDateTime = x.executionEndDateTime
            this.executionStartDateTime = x.executionStartDateTime
            this.instanceId = x.instanceId
            this.pluginName = x.pluginName
            this.responseCode = x.responseCode
            this.standardErrorContent = x.standardErrorContent
            this.standardErrorUrl = x.standardErrorUrl
            this.standardOutputContent = x.standardOutputContent
            this.standardOutputUrl = x.standardOutputUrl
            this.status = x.status
            this.statusDetails = x.statusDetails
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.GetCommandInvocationResponse = GetCommandInvocationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig] inside the given [block]
         */
        public fun cloudWatchOutputConfig(block: aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig.Builder.() -> kotlin.Unit) {
            this.cloudWatchOutputConfig = aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
