// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the name of a SSM document.
 */
public class DocumentIdentifier private constructor(builder: Builder) {
    /**
     * The user in your organization who created the document.
     */
    public val author: kotlin.String? = builder.author
    /**
     * The date the SSM document was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * An optional field where you can specify a friendly name for the SSM document. This value can differ for each version of the document. If you want to update this value, see UpdateDocument.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * The document format, either JSON or YAML.
     */
    public val documentFormat: aws.sdk.kotlin.services.ssm.model.DocumentFormat? = builder.documentFormat
    /**
     * The document type.
     */
    public val documentType: aws.sdk.kotlin.services.ssm.model.DocumentType? = builder.documentType
    /**
     * The document version.
     */
    public val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * The name of the SSM document.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Web Services user that created the document.
     */
    public val owner: kotlin.String? = builder.owner
    /**
     * The operating system platform.
     */
    public val platformTypes: List<PlatformType>? = builder.platformTypes
    /**
     * A list of SSM documents required by a document. For example, an `ApplicationConfiguration` document requires an `ApplicationConfigurationSchema` document.
     */
    public val requires: List<DocumentRequires>? = builder.requires
    /**
     * The current status of a document review.
     */
    public val reviewStatus: aws.sdk.kotlin.services.ssm.model.ReviewStatus? = builder.reviewStatus
    /**
     * The schema version.
     */
    public val schemaVersion: kotlin.String? = builder.schemaVersion
    /**
     * The tags, or metadata, that have been applied to the document.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The target type which defines the kinds of resources the document can run on. For example, `/AWS::EC2::Instance`. For a list of valid resource types, see [Amazon Web Services resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html) in the *CloudFormation User Guide*.
     */
    public val targetType: kotlin.String? = builder.targetType
    /**
     * An optional field specifying the version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed.
     */
    public val versionName: kotlin.String? = builder.versionName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.DocumentIdentifier = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentIdentifier(")
        append("author=$author,")
        append("createdDate=$createdDate,")
        append("displayName=$displayName,")
        append("documentFormat=$documentFormat,")
        append("documentType=$documentType,")
        append("documentVersion=$documentVersion,")
        append("name=$name,")
        append("owner=$owner,")
        append("platformTypes=$platformTypes,")
        append("requires=$requires,")
        append("reviewStatus=$reviewStatus,")
        append("schemaVersion=$schemaVersion,")
        append("tags=$tags,")
        append("targetType=$targetType,")
        append("versionName=$versionName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = author?.hashCode() ?: 0
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (documentFormat?.hashCode() ?: 0)
        result = 31 * result + (documentType?.hashCode() ?: 0)
        result = 31 * result + (documentVersion?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (platformTypes?.hashCode() ?: 0)
        result = 31 * result + (requires?.hashCode() ?: 0)
        result = 31 * result + (reviewStatus?.hashCode() ?: 0)
        result = 31 * result + (schemaVersion?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetType?.hashCode() ?: 0)
        result = 31 * result + (versionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentIdentifier

        if (author != other.author) return false
        if (createdDate != other.createdDate) return false
        if (displayName != other.displayName) return false
        if (documentFormat != other.documentFormat) return false
        if (documentType != other.documentType) return false
        if (documentVersion != other.documentVersion) return false
        if (name != other.name) return false
        if (owner != other.owner) return false
        if (platformTypes != other.platformTypes) return false
        if (requires != other.requires) return false
        if (reviewStatus != other.reviewStatus) return false
        if (schemaVersion != other.schemaVersion) return false
        if (tags != other.tags) return false
        if (targetType != other.targetType) return false
        if (versionName != other.versionName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.DocumentIdentifier = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The user in your organization who created the document.
         */
        public var author: kotlin.String? = null
        /**
         * The date the SSM document was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An optional field where you can specify a friendly name for the SSM document. This value can differ for each version of the document. If you want to update this value, see UpdateDocument.
         */
        public var displayName: kotlin.String? = null
        /**
         * The document format, either JSON or YAML.
         */
        public var documentFormat: aws.sdk.kotlin.services.ssm.model.DocumentFormat? = null
        /**
         * The document type.
         */
        public var documentType: aws.sdk.kotlin.services.ssm.model.DocumentType? = null
        /**
         * The document version.
         */
        public var documentVersion: kotlin.String? = null
        /**
         * The name of the SSM document.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Web Services user that created the document.
         */
        public var owner: kotlin.String? = null
        /**
         * The operating system platform.
         */
        public var platformTypes: List<PlatformType>? = null
        /**
         * A list of SSM documents required by a document. For example, an `ApplicationConfiguration` document requires an `ApplicationConfigurationSchema` document.
         */
        public var requires: List<DocumentRequires>? = null
        /**
         * The current status of a document review.
         */
        public var reviewStatus: aws.sdk.kotlin.services.ssm.model.ReviewStatus? = null
        /**
         * The schema version.
         */
        public var schemaVersion: kotlin.String? = null
        /**
         * The tags, or metadata, that have been applied to the document.
         */
        public var tags: List<Tag>? = null
        /**
         * The target type which defines the kinds of resources the document can run on. For example, `/AWS::EC2::Instance`. For a list of valid resource types, see [Amazon Web Services resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html) in the *CloudFormation User Guide*.
         */
        public var targetType: kotlin.String? = null
        /**
         * An optional field specifying the version of the artifact associated with the document. For example, "Release 12, Update 6". This value is unique across all versions of a document, and can't be changed.
         */
        public var versionName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.DocumentIdentifier) : this() {
            this.author = x.author
            this.createdDate = x.createdDate
            this.displayName = x.displayName
            this.documentFormat = x.documentFormat
            this.documentType = x.documentType
            this.documentVersion = x.documentVersion
            this.name = x.name
            this.owner = x.owner
            this.platformTypes = x.platformTypes
            this.requires = x.requires
            this.reviewStatus = x.reviewStatus
            this.schemaVersion = x.schemaVersion
            this.tags = x.tags
            this.targetType = x.targetType
            this.versionName = x.versionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.DocumentIdentifier = DocumentIdentifier(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
