// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



public class DescribePatchGroupStateResponse private constructor(builder: Builder) {
    /**
     * The number of managed nodes in the patch group.
     */
    public val instances: kotlin.Int = builder.instances
    /**
     * The number of managed nodes where patches that are specified as `Critical` for compliance reporting in the patch baseline aren't installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is `NON_COMPLIANT`.
     */
    public val instancesWithCriticalNonCompliantPatches: kotlin.Int? = builder.instancesWithCriticalNonCompliantPatches
    /**
     * The number of managed nodes with patches from the patch baseline that failed to install.
     */
    public val instancesWithFailedPatches: kotlin.Int = builder.instancesWithFailedPatches
    /**
     * The number of managed nodes with patches installed that aren't defined in the patch baseline.
     */
    public val instancesWithInstalledOtherPatches: kotlin.Int = builder.instancesWithInstalledOtherPatches
    /**
     * The number of managed nodes with installed patches.
     */
    public val instancesWithInstalledPatches: kotlin.Int = builder.instancesWithInstalledPatches
    /**
     * The number of managed nodes with patches installed by Patch Manager that haven't been rebooted after the patch installation. The status of these managed nodes is `NON_COMPLIANT`.
     */
    public val instancesWithInstalledPendingRebootPatches: kotlin.Int? = builder.instancesWithInstalledPendingRebootPatches
    /**
     * The number of managed nodes with patches installed that are specified in a `RejectedPatches` list. Patches with a status of `INSTALLED_REJECTED` were typically installed before they were added to a `RejectedPatches` list.
     *
     * If `ALLOW_AS_DEPENDENCY` is the specified option for `RejectedPatchesAction`, the value of `InstancesWithInstalledRejectedPatches` will always be `0` (zero).
     */
    public val instancesWithInstalledRejectedPatches: kotlin.Int? = builder.instancesWithInstalledRejectedPatches
    /**
     * The number of managed nodes with missing patches from the patch baseline.
     */
    public val instancesWithMissingPatches: kotlin.Int = builder.instancesWithMissingPatches
    /**
     * The number of managed nodes with patches that aren't applicable.
     */
    public val instancesWithNotApplicablePatches: kotlin.Int = builder.instancesWithNotApplicablePatches
    /**
     * The number of managed nodes with patches installed that are specified as other than `Critical` or `Security` but aren't compliant with the patch baseline. The status of these managed nodes is `NON_COMPLIANT`.
     */
    public val instancesWithOtherNonCompliantPatches: kotlin.Int? = builder.instancesWithOtherNonCompliantPatches
    /**
     * The number of managed nodes where patches that are specified as `Security` in a patch advisory aren't installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is `NON_COMPLIANT`.
     */
    public val instancesWithSecurityNonCompliantPatches: kotlin.Int? = builder.instancesWithSecurityNonCompliantPatches
    /**
     * The number of managed nodes with `NotApplicable` patches beyond the supported limit, which aren't reported by name to Inventory. Inventory is a capability of Amazon Web Services Systems Manager.
     */
    public val instancesWithUnreportedNotApplicablePatches: kotlin.Int? = builder.instancesWithUnreportedNotApplicablePatches

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.DescribePatchGroupStateResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribePatchGroupStateResponse(")
        append("instances=$instances,")
        append("instancesWithCriticalNonCompliantPatches=$instancesWithCriticalNonCompliantPatches,")
        append("instancesWithFailedPatches=$instancesWithFailedPatches,")
        append("instancesWithInstalledOtherPatches=$instancesWithInstalledOtherPatches,")
        append("instancesWithInstalledPatches=$instancesWithInstalledPatches,")
        append("instancesWithInstalledPendingRebootPatches=$instancesWithInstalledPendingRebootPatches,")
        append("instancesWithInstalledRejectedPatches=$instancesWithInstalledRejectedPatches,")
        append("instancesWithMissingPatches=$instancesWithMissingPatches,")
        append("instancesWithNotApplicablePatches=$instancesWithNotApplicablePatches,")
        append("instancesWithOtherNonCompliantPatches=$instancesWithOtherNonCompliantPatches,")
        append("instancesWithSecurityNonCompliantPatches=$instancesWithSecurityNonCompliantPatches,")
        append("instancesWithUnreportedNotApplicablePatches=$instancesWithUnreportedNotApplicablePatches")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instances
        result = 31 * result + (instancesWithCriticalNonCompliantPatches ?: 0)
        result = 31 * result + (instancesWithFailedPatches)
        result = 31 * result + (instancesWithInstalledOtherPatches)
        result = 31 * result + (instancesWithInstalledPatches)
        result = 31 * result + (instancesWithInstalledPendingRebootPatches ?: 0)
        result = 31 * result + (instancesWithInstalledRejectedPatches ?: 0)
        result = 31 * result + (instancesWithMissingPatches)
        result = 31 * result + (instancesWithNotApplicablePatches)
        result = 31 * result + (instancesWithOtherNonCompliantPatches ?: 0)
        result = 31 * result + (instancesWithSecurityNonCompliantPatches ?: 0)
        result = 31 * result + (instancesWithUnreportedNotApplicablePatches ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribePatchGroupStateResponse

        if (instances != other.instances) return false
        if (instancesWithCriticalNonCompliantPatches != other.instancesWithCriticalNonCompliantPatches) return false
        if (instancesWithFailedPatches != other.instancesWithFailedPatches) return false
        if (instancesWithInstalledOtherPatches != other.instancesWithInstalledOtherPatches) return false
        if (instancesWithInstalledPatches != other.instancesWithInstalledPatches) return false
        if (instancesWithInstalledPendingRebootPatches != other.instancesWithInstalledPendingRebootPatches) return false
        if (instancesWithInstalledRejectedPatches != other.instancesWithInstalledRejectedPatches) return false
        if (instancesWithMissingPatches != other.instancesWithMissingPatches) return false
        if (instancesWithNotApplicablePatches != other.instancesWithNotApplicablePatches) return false
        if (instancesWithOtherNonCompliantPatches != other.instancesWithOtherNonCompliantPatches) return false
        if (instancesWithSecurityNonCompliantPatches != other.instancesWithSecurityNonCompliantPatches) return false
        if (instancesWithUnreportedNotApplicablePatches != other.instancesWithUnreportedNotApplicablePatches) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.DescribePatchGroupStateResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of managed nodes in the patch group.
         */
        public var instances: kotlin.Int = 0
        /**
         * The number of managed nodes where patches that are specified as `Critical` for compliance reporting in the patch baseline aren't installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is `NON_COMPLIANT`.
         */
        public var instancesWithCriticalNonCompliantPatches: kotlin.Int? = null
        /**
         * The number of managed nodes with patches from the patch baseline that failed to install.
         */
        public var instancesWithFailedPatches: kotlin.Int = 0
        /**
         * The number of managed nodes with patches installed that aren't defined in the patch baseline.
         */
        public var instancesWithInstalledOtherPatches: kotlin.Int = 0
        /**
         * The number of managed nodes with installed patches.
         */
        public var instancesWithInstalledPatches: kotlin.Int = 0
        /**
         * The number of managed nodes with patches installed by Patch Manager that haven't been rebooted after the patch installation. The status of these managed nodes is `NON_COMPLIANT`.
         */
        public var instancesWithInstalledPendingRebootPatches: kotlin.Int? = null
        /**
         * The number of managed nodes with patches installed that are specified in a `RejectedPatches` list. Patches with a status of `INSTALLED_REJECTED` were typically installed before they were added to a `RejectedPatches` list.
         *
         * If `ALLOW_AS_DEPENDENCY` is the specified option for `RejectedPatchesAction`, the value of `InstancesWithInstalledRejectedPatches` will always be `0` (zero).
         */
        public var instancesWithInstalledRejectedPatches: kotlin.Int? = null
        /**
         * The number of managed nodes with missing patches from the patch baseline.
         */
        public var instancesWithMissingPatches: kotlin.Int = 0
        /**
         * The number of managed nodes with patches that aren't applicable.
         */
        public var instancesWithNotApplicablePatches: kotlin.Int = 0
        /**
         * The number of managed nodes with patches installed that are specified as other than `Critical` or `Security` but aren't compliant with the patch baseline. The status of these managed nodes is `NON_COMPLIANT`.
         */
        public var instancesWithOtherNonCompliantPatches: kotlin.Int? = null
        /**
         * The number of managed nodes where patches that are specified as `Security` in a patch advisory aren't installed. These patches might be missing, have failed installation, were rejected, or were installed but awaiting a required managed node reboot. The status of these managed nodes is `NON_COMPLIANT`.
         */
        public var instancesWithSecurityNonCompliantPatches: kotlin.Int? = null
        /**
         * The number of managed nodes with `NotApplicable` patches beyond the supported limit, which aren't reported by name to Inventory. Inventory is a capability of Amazon Web Services Systems Manager.
         */
        public var instancesWithUnreportedNotApplicablePatches: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.DescribePatchGroupStateResponse) : this() {
            this.instances = x.instances
            this.instancesWithCriticalNonCompliantPatches = x.instancesWithCriticalNonCompliantPatches
            this.instancesWithFailedPatches = x.instancesWithFailedPatches
            this.instancesWithInstalledOtherPatches = x.instancesWithInstalledOtherPatches
            this.instancesWithInstalledPatches = x.instancesWithInstalledPatches
            this.instancesWithInstalledPendingRebootPatches = x.instancesWithInstalledPendingRebootPatches
            this.instancesWithInstalledRejectedPatches = x.instancesWithInstalledRejectedPatches
            this.instancesWithMissingPatches = x.instancesWithMissingPatches
            this.instancesWithNotApplicablePatches = x.instancesWithNotApplicablePatches
            this.instancesWithOtherNonCompliantPatches = x.instancesWithOtherNonCompliantPatches
            this.instancesWithSecurityNonCompliantPatches = x.instancesWithSecurityNonCompliantPatches
            this.instancesWithUnreportedNotApplicablePatches = x.instancesWithUnreportedNotApplicablePatches
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.DescribePatchGroupStateResponse = DescribePatchGroupStateResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
