// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * Information about the compliance as defined by the resource type. For example, for a patch resource type, `Items` includes information about the PatchSeverity, Classification, and so on.
 */
public class ComplianceItem private constructor(builder: Builder) {
    /**
     * The compliance type. For example, Association (for a State Manager association), Patch, or Custom:`string` are all valid compliance types.
     */
    public val complianceType: kotlin.String? = builder.complianceType
    /**
     * A "Key": "Value" tag combination for the compliance item.
     */
    public val details: Map<String, String>? = builder.details
    /**
     * A summary for the compliance item. The summary includes an execution ID, the execution type (for example, command), and the execution time.
     */
    public val executionSummary: aws.sdk.kotlin.services.ssm.model.ComplianceExecutionSummary? = builder.executionSummary
    /**
     * An ID for the compliance item. For example, if the compliance item is a Windows patch, the ID could be the number of the KB article; for example: KB4010320.
     */
    public val id: kotlin.String? = builder.id
    /**
     * An ID for the resource. For a managed node, this is the node ID.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * The type of resource. `ManagedInstance` is currently the only supported resource type.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * The severity of the compliance status. Severity can be one of the following: Critical, High, Medium, Low, Informational, Unspecified.
     */
    public val severity: aws.sdk.kotlin.services.ssm.model.ComplianceSeverity? = builder.severity
    /**
     * The status of the compliance item. An item is either COMPLIANT, NON_COMPLIANT, or an empty string (for Windows patches that aren't applicable).
     */
    public val status: aws.sdk.kotlin.services.ssm.model.ComplianceStatus? = builder.status
    /**
     * A title for the compliance item. For example, if the compliance item is a Windows patch, the title could be the title of the KB article for the patch; for example: Security Update for Active Directory Federation Services.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.ComplianceItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComplianceItem(")
        append("complianceType=$complianceType,")
        append("details=$details,")
        append("executionSummary=$executionSummary,")
        append("id=$id,")
        append("resourceId=$resourceId,")
        append("resourceType=$resourceType,")
        append("severity=$severity,")
        append("status=$status,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = complianceType?.hashCode() ?: 0
        result = 31 * result + (details?.hashCode() ?: 0)
        result = 31 * result + (executionSummary?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComplianceItem

        if (complianceType != other.complianceType) return false
        if (details != other.details) return false
        if (executionSummary != other.executionSummary) return false
        if (id != other.id) return false
        if (resourceId != other.resourceId) return false
        if (resourceType != other.resourceType) return false
        if (severity != other.severity) return false
        if (status != other.status) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.ComplianceItem = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The compliance type. For example, Association (for a State Manager association), Patch, or Custom:`string` are all valid compliance types.
         */
        public var complianceType: kotlin.String? = null
        /**
         * A "Key": "Value" tag combination for the compliance item.
         */
        public var details: Map<String, String>? = null
        /**
         * A summary for the compliance item. The summary includes an execution ID, the execution type (for example, command), and the execution time.
         */
        public var executionSummary: aws.sdk.kotlin.services.ssm.model.ComplianceExecutionSummary? = null
        /**
         * An ID for the compliance item. For example, if the compliance item is a Windows patch, the ID could be the number of the KB article; for example: KB4010320.
         */
        public var id: kotlin.String? = null
        /**
         * An ID for the resource. For a managed node, this is the node ID.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The type of resource. `ManagedInstance` is currently the only supported resource type.
         */
        public var resourceType: kotlin.String? = null
        /**
         * The severity of the compliance status. Severity can be one of the following: Critical, High, Medium, Low, Informational, Unspecified.
         */
        public var severity: aws.sdk.kotlin.services.ssm.model.ComplianceSeverity? = null
        /**
         * The status of the compliance item. An item is either COMPLIANT, NON_COMPLIANT, or an empty string (for Windows patches that aren't applicable).
         */
        public var status: aws.sdk.kotlin.services.ssm.model.ComplianceStatus? = null
        /**
         * A title for the compliance item. For example, if the compliance item is a Windows patch, the title could be the title of the KB article for the patch; for example: Security Update for Active Directory Federation Services.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.ComplianceItem) : this() {
            this.complianceType = x.complianceType
            this.details = x.details
            this.executionSummary = x.executionSummary
            this.id = x.id
            this.resourceId = x.resourceId
            this.resourceType = x.resourceType
            this.severity = x.severity
            this.status = x.status
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.ComplianceItem = ComplianceItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.ComplianceExecutionSummary] inside the given [block]
         */
        public fun executionSummary(block: aws.sdk.kotlin.services.ssm.model.ComplianceExecutionSummary.Builder.() -> kotlin.Unit) {
            this.executionSummary = aws.sdk.kotlin.services.ssm.model.ComplianceExecutionSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
