// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes plugin details.
 */
public class CommandPlugin private constructor(builder: Builder) {
    /**
     * The name of the plugin. Must be one of the following: `aws:updateAgent`, `aws:domainjoin`, `aws:applications`, `aws:runPowerShellScript`, `aws:psmodule`, `aws:cloudWatch`, `aws:runShellScript`, or `aws:updateSSMAgent`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Output of the plugin execution.
     */
    public val output: kotlin.String? = builder.output
    /**
     * The S3 bucket where the responses to the command executions should be stored. This was requested when issuing the command. For example, in the following response:
     *
     * `doc-example-bucket/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-02573cafcfEXAMPLE/awsrunShellScript`
     *
     * `doc-example-bucket` is the name of the S3 bucket;
     *
     * `ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix` is the name of the S3 prefix;
     *
     * `i-02573cafcfEXAMPLE` is the managed node ID;
     *
     * `awsrunShellScript` is the name of the plugin.
     */
    public val outputS3BucketName: kotlin.String? = builder.outputS3BucketName
    /**
     * The S3 directory path inside the bucket where the responses to the command executions should be stored. This was requested when issuing the command. For example, in the following response:
     *
     * `doc-example-bucket/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-02573cafcfEXAMPLE/awsrunShellScript`
     *
     * `doc-example-bucket` is the name of the S3 bucket;
     *
     * `ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix` is the name of the S3 prefix;
     *
     * `i-02573cafcfEXAMPLE` is the managed node ID;
     *
     * `awsrunShellScript` is the name of the plugin.
     */
    public val outputS3KeyPrefix: kotlin.String? = builder.outputS3KeyPrefix
    /**
     * (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Amazon Web Services Systems Manager automatically determines the S3 bucket region.
     */
    public val outputS3Region: kotlin.String? = builder.outputS3Region
    /**
     * A numeric response code generated after running the plugin.
     */
    public val responseCode: kotlin.Int = builder.responseCode
    /**
     * The time the plugin stopped running. Could stop prematurely if, for example, a cancel command was sent.
     */
    public val responseFinishDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.responseFinishDateTime
    /**
     * The time the plugin started running.
     */
    public val responseStartDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.responseStartDateTime
    /**
     * The URL for the complete text written by the plugin to stderr. If execution isn't yet complete, then this string is empty.
     */
    public val standardErrorUrl: kotlin.String? = builder.standardErrorUrl
    /**
     * The URL for the complete text written by the plugin to stdout in Amazon S3. If the S3 bucket for the command wasn't specified, then this string is empty.
     */
    public val standardOutputUrl: kotlin.String? = builder.standardOutputUrl
    /**
     * The status of this plugin. You can run a document with multiple plugins.
     */
    public val status: aws.sdk.kotlin.services.ssm.model.CommandPluginStatus? = builder.status
    /**
     * A detailed status of the plugin execution. `StatusDetails` includes more information than Status because it includes states resulting from error and concurrency control parameters. StatusDetails can show different results than Status. For more information about these statuses, see [Understanding command statuses](https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html) in the *Amazon Web Services Systems Manager User Guide*. StatusDetails can be one of the following values:
     * + Pending: The command hasn't been sent to the managed node.
     * + In Progress: The command has been sent to the managed node but hasn't reached a terminal state.
     * + Success: The execution of the command or plugin was successfully completed. This is a terminal state.
     * + Delivery Timed Out: The command wasn't delivered to the managed node before the delivery timeout expired. Delivery timeouts don't count against the parent command's `MaxErrors` limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
     * + Execution Timed Out: Command execution started on the managed node, but the execution wasn't complete before the execution timeout expired. Execution timeouts count against the `MaxErrors` limit of the parent command. This is a terminal state.
     * + Failed: The command wasn't successful on the managed node. For a plugin, this indicates that the result code wasn't zero. For a command invocation, this indicates that the result code for one or more plugins wasn't zero. Invocation failures count against the MaxErrors limit of the parent command. This is a terminal state.
     * + Cancelled: The command was terminated before it was completed. This is a terminal state.
     * + Undeliverable: The command can't be delivered to the managed node. The managed node might not exist, or it might not be responding. Undeliverable invocations don't count against the parent command's MaxErrors limit, and they don't contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
     * + Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were canceled by the system. This is a terminal state.
     */
    public val statusDetails: kotlin.String? = builder.statusDetails

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.CommandPlugin = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CommandPlugin(")
        append("name=$name,")
        append("output=$output,")
        append("outputS3BucketName=$outputS3BucketName,")
        append("outputS3KeyPrefix=$outputS3KeyPrefix,")
        append("outputS3Region=$outputS3Region,")
        append("responseCode=$responseCode,")
        append("responseFinishDateTime=$responseFinishDateTime,")
        append("responseStartDateTime=$responseStartDateTime,")
        append("standardErrorUrl=$standardErrorUrl,")
        append("standardOutputUrl=$standardOutputUrl,")
        append("status=$status,")
        append("statusDetails=$statusDetails")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (output?.hashCode() ?: 0)
        result = 31 * result + (outputS3BucketName?.hashCode() ?: 0)
        result = 31 * result + (outputS3KeyPrefix?.hashCode() ?: 0)
        result = 31 * result + (outputS3Region?.hashCode() ?: 0)
        result = 31 * result + (responseCode)
        result = 31 * result + (responseFinishDateTime?.hashCode() ?: 0)
        result = 31 * result + (responseStartDateTime?.hashCode() ?: 0)
        result = 31 * result + (standardErrorUrl?.hashCode() ?: 0)
        result = 31 * result + (standardOutputUrl?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CommandPlugin

        if (name != other.name) return false
        if (output != other.output) return false
        if (outputS3BucketName != other.outputS3BucketName) return false
        if (outputS3KeyPrefix != other.outputS3KeyPrefix) return false
        if (outputS3Region != other.outputS3Region) return false
        if (responseCode != other.responseCode) return false
        if (responseFinishDateTime != other.responseFinishDateTime) return false
        if (responseStartDateTime != other.responseStartDateTime) return false
        if (standardErrorUrl != other.standardErrorUrl) return false
        if (standardOutputUrl != other.standardOutputUrl) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.CommandPlugin = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the plugin. Must be one of the following: `aws:updateAgent`, `aws:domainjoin`, `aws:applications`, `aws:runPowerShellScript`, `aws:psmodule`, `aws:cloudWatch`, `aws:runShellScript`, or `aws:updateSSMAgent`.
         */
        public var name: kotlin.String? = null
        /**
         * Output of the plugin execution.
         */
        public var output: kotlin.String? = null
        /**
         * The S3 bucket where the responses to the command executions should be stored. This was requested when issuing the command. For example, in the following response:
         *
         * `doc-example-bucket/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-02573cafcfEXAMPLE/awsrunShellScript`
         *
         * `doc-example-bucket` is the name of the S3 bucket;
         *
         * `ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix` is the name of the S3 prefix;
         *
         * `i-02573cafcfEXAMPLE` is the managed node ID;
         *
         * `awsrunShellScript` is the name of the plugin.
         */
        public var outputS3BucketName: kotlin.String? = null
        /**
         * The S3 directory path inside the bucket where the responses to the command executions should be stored. This was requested when issuing the command. For example, in the following response:
         *
         * `doc-example-bucket/ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix/i-02573cafcfEXAMPLE/awsrunShellScript`
         *
         * `doc-example-bucket` is the name of the S3 bucket;
         *
         * `ab19cb99-a030-46dd-9dfc-8eSAMPLEPre-Fix` is the name of the S3 prefix;
         *
         * `i-02573cafcfEXAMPLE` is the managed node ID;
         *
         * `awsrunShellScript` is the name of the plugin.
         */
        public var outputS3KeyPrefix: kotlin.String? = null
        /**
         * (Deprecated) You can no longer specify this parameter. The system ignores it. Instead, Amazon Web Services Systems Manager automatically determines the S3 bucket region.
         */
        public var outputS3Region: kotlin.String? = null
        /**
         * A numeric response code generated after running the plugin.
         */
        public var responseCode: kotlin.Int = 0
        /**
         * The time the plugin stopped running. Could stop prematurely if, for example, a cancel command was sent.
         */
        public var responseFinishDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time the plugin started running.
         */
        public var responseStartDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The URL for the complete text written by the plugin to stderr. If execution isn't yet complete, then this string is empty.
         */
        public var standardErrorUrl: kotlin.String? = null
        /**
         * The URL for the complete text written by the plugin to stdout in Amazon S3. If the S3 bucket for the command wasn't specified, then this string is empty.
         */
        public var standardOutputUrl: kotlin.String? = null
        /**
         * The status of this plugin. You can run a document with multiple plugins.
         */
        public var status: aws.sdk.kotlin.services.ssm.model.CommandPluginStatus? = null
        /**
         * A detailed status of the plugin execution. `StatusDetails` includes more information than Status because it includes states resulting from error and concurrency control parameters. StatusDetails can show different results than Status. For more information about these statuses, see [Understanding command statuses](https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html) in the *Amazon Web Services Systems Manager User Guide*. StatusDetails can be one of the following values:
         * + Pending: The command hasn't been sent to the managed node.
         * + In Progress: The command has been sent to the managed node but hasn't reached a terminal state.
         * + Success: The execution of the command or plugin was successfully completed. This is a terminal state.
         * + Delivery Timed Out: The command wasn't delivered to the managed node before the delivery timeout expired. Delivery timeouts don't count against the parent command's `MaxErrors` limit, but they do contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
         * + Execution Timed Out: Command execution started on the managed node, but the execution wasn't complete before the execution timeout expired. Execution timeouts count against the `MaxErrors` limit of the parent command. This is a terminal state.
         * + Failed: The command wasn't successful on the managed node. For a plugin, this indicates that the result code wasn't zero. For a command invocation, this indicates that the result code for one or more plugins wasn't zero. Invocation failures count against the MaxErrors limit of the parent command. This is a terminal state.
         * + Cancelled: The command was terminated before it was completed. This is a terminal state.
         * + Undeliverable: The command can't be delivered to the managed node. The managed node might not exist, or it might not be responding. Undeliverable invocations don't count against the parent command's MaxErrors limit, and they don't contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
         * + Terminated: The parent command exceeded its MaxErrors limit and subsequent command invocations were canceled by the system. This is a terminal state.
         */
        public var statusDetails: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.CommandPlugin) : this() {
            this.name = x.name
            this.output = x.output
            this.outputS3BucketName = x.outputS3BucketName
            this.outputS3KeyPrefix = x.outputS3KeyPrefix
            this.outputS3Region = x.outputS3Region
            this.responseCode = x.responseCode
            this.responseFinishDateTime = x.responseFinishDateTime
            this.responseStartDateTime = x.responseStartDateTime
            this.standardErrorUrl = x.standardErrorUrl
            this.standardOutputUrl = x.standardOutputUrl
            this.status = x.status
            this.statusDetails = x.statusDetails
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.CommandPlugin = CommandPlugin(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
