// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed information about the current state of an individual Automation execution.
 */
public class AutomationExecution private constructor(builder: Builder) {
    /**
     * The details for the CloudWatch alarm applied to your automation.
     */
    public val alarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = builder.alarmConfiguration
    /**
     * The ID of a State Manager association used in the Automation operation.
     */
    public val associationId: kotlin.String? = builder.associationId
    /**
     * The execution ID.
     */
    public val automationExecutionId: kotlin.String? = builder.automationExecutionId
    /**
     * The execution status of the Automation.
     */
    public val automationExecutionStatus: aws.sdk.kotlin.services.ssm.model.AutomationExecutionStatus? = builder.automationExecutionStatus
    /**
     * The subtype of the Automation operation. Currently, the only supported value is `ChangeRequest`.
     */
    public val automationSubtype: aws.sdk.kotlin.services.ssm.model.AutomationSubtype? = builder.automationSubtype
    /**
     * The name of the Change Manager change request.
     */
    public val changeRequestName: kotlin.String? = builder.changeRequestName
    /**
     * The action of the step that is currently running.
     */
    public val currentAction: kotlin.String? = builder.currentAction
    /**
     * The name of the step that is currently running.
     */
    public val currentStepName: kotlin.String? = builder.currentStepName
    /**
     * The name of the Automation runbook used during the execution.
     */
    public val documentName: kotlin.String? = builder.documentName
    /**
     * The version of the document to use during execution.
     */
    public val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * The Amazon Resource Name (ARN) of the user who ran the automation.
     */
    public val executedBy: kotlin.String? = builder.executedBy
    /**
     * The time the execution finished.
     */
    public val executionEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.executionEndTime
    /**
     * The time the execution started.
     */
    public val executionStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.executionStartTime
    /**
     * A message describing why an execution has failed, if the status is set to Failed.
     */
    public val failureMessage: kotlin.String? = builder.failureMessage
    /**
     * The `MaxConcurrency` value specified by the user when the execution started.
     */
    public val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The MaxErrors value specified by the user when the execution started.
     */
    public val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * The automation execution mode.
     */
    public val mode: aws.sdk.kotlin.services.ssm.model.ExecutionMode? = builder.mode
    /**
     * The ID of an OpsItem that is created to represent a Change Manager change request.
     */
    public val opsItemId: kotlin.String? = builder.opsItemId
    /**
     * The list of execution outputs as defined in the Automation runbook.
     */
    public val outputs: Map<String, List<String>>? = builder.outputs
    /**
     * The key-value map of execution parameters, which were supplied when calling StartAutomationExecution.
     */
    public val parameters: Map<String, List<String>>? = builder.parameters
    /**
     * The AutomationExecutionId of the parent automation.
     */
    public val parentAutomationExecutionId: kotlin.String? = builder.parentAutomationExecutionId
    /**
     * An aggregate of step execution statuses displayed in the Amazon Web Services Systems Manager console for a multi-Region and multi-account Automation execution.
     */
    public val progressCounters: aws.sdk.kotlin.services.ssm.model.ProgressCounters? = builder.progressCounters
    /**
     * A list of resolved targets in the rate control execution.
     */
    public val resolvedTargets: aws.sdk.kotlin.services.ssm.model.ResolvedTargets? = builder.resolvedTargets
    /**
     * Information about the Automation runbooks that are run as part of a runbook workflow.
     *
     * The Automation runbooks specified for the runbook workflow can't run until all required approvals for the change request have been received.
     */
    public val runbooks: List<Runbook>? = builder.runbooks
    /**
     * The date and time the Automation operation is scheduled to start.
     */
    public val scheduledTime: aws.smithy.kotlin.runtime.time.Instant? = builder.scheduledTime
    /**
     * A list of details about the current state of all steps that comprise an execution. An Automation runbook contains a list of steps that are run in order.
     */
    public val stepExecutions: List<StepExecution>? = builder.stepExecutions
    /**
     * A boolean value that indicates if the response contains the full list of the Automation step executions. If true, use the DescribeAutomationStepExecutions API operation to get the full list of step executions.
     */
    public val stepExecutionsTruncated: kotlin.Boolean = builder.stepExecutionsTruncated
    /**
     * The target of the execution.
     */
    public val target: kotlin.String? = builder.target
    /**
     * The combination of Amazon Web Services Regions and/or Amazon Web Services accounts where you want to run the Automation.
     */
    public val targetLocations: List<TargetLocation>? = builder.targetLocations
    /**
     * The specified key-value mapping of document parameters to target resources.
     */
    public val targetMaps: List<Map<String, List<String>>>? = builder.targetMaps
    /**
     * The parameter name.
     */
    public val targetParameterName: kotlin.String? = builder.targetParameterName
    /**
     * The specified targets.
     */
    public val targets: List<Target>? = builder.targets
    /**
     * The CloudWatch alarm that was invoked by the automation.
     */
    public val triggeredAlarms: List<AlarmStateInformation>? = builder.triggeredAlarms
    /**
     * Variables defined for the automation.
     */
    public val variables: Map<String, List<String>>? = builder.variables

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.AutomationExecution = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutomationExecution(")
        append("alarmConfiguration=$alarmConfiguration,")
        append("associationId=$associationId,")
        append("automationExecutionId=$automationExecutionId,")
        append("automationExecutionStatus=$automationExecutionStatus,")
        append("automationSubtype=$automationSubtype,")
        append("changeRequestName=$changeRequestName,")
        append("currentAction=$currentAction,")
        append("currentStepName=$currentStepName,")
        append("documentName=$documentName,")
        append("documentVersion=$documentVersion,")
        append("executedBy=$executedBy,")
        append("executionEndTime=$executionEndTime,")
        append("executionStartTime=$executionStartTime,")
        append("failureMessage=$failureMessage,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("mode=$mode,")
        append("opsItemId=$opsItemId,")
        append("outputs=$outputs,")
        append("parameters=$parameters,")
        append("parentAutomationExecutionId=$parentAutomationExecutionId,")
        append("progressCounters=$progressCounters,")
        append("resolvedTargets=$resolvedTargets,")
        append("runbooks=$runbooks,")
        append("scheduledTime=$scheduledTime,")
        append("stepExecutions=$stepExecutions,")
        append("stepExecutionsTruncated=$stepExecutionsTruncated,")
        append("target=$target,")
        append("targetLocations=$targetLocations,")
        append("targetMaps=$targetMaps,")
        append("targetParameterName=$targetParameterName,")
        append("targets=$targets,")
        append("triggeredAlarms=$triggeredAlarms,")
        append("variables=$variables")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmConfiguration?.hashCode() ?: 0
        result = 31 * result + (associationId?.hashCode() ?: 0)
        result = 31 * result + (automationExecutionId?.hashCode() ?: 0)
        result = 31 * result + (automationExecutionStatus?.hashCode() ?: 0)
        result = 31 * result + (automationSubtype?.hashCode() ?: 0)
        result = 31 * result + (changeRequestName?.hashCode() ?: 0)
        result = 31 * result + (currentAction?.hashCode() ?: 0)
        result = 31 * result + (currentStepName?.hashCode() ?: 0)
        result = 31 * result + (documentName?.hashCode() ?: 0)
        result = 31 * result + (documentVersion?.hashCode() ?: 0)
        result = 31 * result + (executedBy?.hashCode() ?: 0)
        result = 31 * result + (executionEndTime?.hashCode() ?: 0)
        result = 31 * result + (executionStartTime?.hashCode() ?: 0)
        result = 31 * result + (failureMessage?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (maxErrors?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (opsItemId?.hashCode() ?: 0)
        result = 31 * result + (outputs?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (parentAutomationExecutionId?.hashCode() ?: 0)
        result = 31 * result + (progressCounters?.hashCode() ?: 0)
        result = 31 * result + (resolvedTargets?.hashCode() ?: 0)
        result = 31 * result + (runbooks?.hashCode() ?: 0)
        result = 31 * result + (scheduledTime?.hashCode() ?: 0)
        result = 31 * result + (stepExecutions?.hashCode() ?: 0)
        result = 31 * result + (stepExecutionsTruncated.hashCode())
        result = 31 * result + (target?.hashCode() ?: 0)
        result = 31 * result + (targetLocations?.hashCode() ?: 0)
        result = 31 * result + (targetMaps?.hashCode() ?: 0)
        result = 31 * result + (targetParameterName?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (triggeredAlarms?.hashCode() ?: 0)
        result = 31 * result + (variables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutomationExecution

        if (alarmConfiguration != other.alarmConfiguration) return false
        if (associationId != other.associationId) return false
        if (automationExecutionId != other.automationExecutionId) return false
        if (automationExecutionStatus != other.automationExecutionStatus) return false
        if (automationSubtype != other.automationSubtype) return false
        if (changeRequestName != other.changeRequestName) return false
        if (currentAction != other.currentAction) return false
        if (currentStepName != other.currentStepName) return false
        if (documentName != other.documentName) return false
        if (documentVersion != other.documentVersion) return false
        if (executedBy != other.executedBy) return false
        if (executionEndTime != other.executionEndTime) return false
        if (executionStartTime != other.executionStartTime) return false
        if (failureMessage != other.failureMessage) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (mode != other.mode) return false
        if (opsItemId != other.opsItemId) return false
        if (outputs != other.outputs) return false
        if (parameters != other.parameters) return false
        if (parentAutomationExecutionId != other.parentAutomationExecutionId) return false
        if (progressCounters != other.progressCounters) return false
        if (resolvedTargets != other.resolvedTargets) return false
        if (runbooks != other.runbooks) return false
        if (scheduledTime != other.scheduledTime) return false
        if (stepExecutions != other.stepExecutions) return false
        if (stepExecutionsTruncated != other.stepExecutionsTruncated) return false
        if (target != other.target) return false
        if (targetLocations != other.targetLocations) return false
        if (targetMaps != other.targetMaps) return false
        if (targetParameterName != other.targetParameterName) return false
        if (targets != other.targets) return false
        if (triggeredAlarms != other.triggeredAlarms) return false
        if (variables != other.variables) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.AutomationExecution = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The details for the CloudWatch alarm applied to your automation.
         */
        public var alarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = null
        /**
         * The ID of a State Manager association used in the Automation operation.
         */
        public var associationId: kotlin.String? = null
        /**
         * The execution ID.
         */
        public var automationExecutionId: kotlin.String? = null
        /**
         * The execution status of the Automation.
         */
        public var automationExecutionStatus: aws.sdk.kotlin.services.ssm.model.AutomationExecutionStatus? = null
        /**
         * The subtype of the Automation operation. Currently, the only supported value is `ChangeRequest`.
         */
        public var automationSubtype: aws.sdk.kotlin.services.ssm.model.AutomationSubtype? = null
        /**
         * The name of the Change Manager change request.
         */
        public var changeRequestName: kotlin.String? = null
        /**
         * The action of the step that is currently running.
         */
        public var currentAction: kotlin.String? = null
        /**
         * The name of the step that is currently running.
         */
        public var currentStepName: kotlin.String? = null
        /**
         * The name of the Automation runbook used during the execution.
         */
        public var documentName: kotlin.String? = null
        /**
         * The version of the document to use during execution.
         */
        public var documentVersion: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the user who ran the automation.
         */
        public var executedBy: kotlin.String? = null
        /**
         * The time the execution finished.
         */
        public var executionEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time the execution started.
         */
        public var executionStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A message describing why an execution has failed, if the status is set to Failed.
         */
        public var failureMessage: kotlin.String? = null
        /**
         * The `MaxConcurrency` value specified by the user when the execution started.
         */
        public var maxConcurrency: kotlin.String? = null
        /**
         * The MaxErrors value specified by the user when the execution started.
         */
        public var maxErrors: kotlin.String? = null
        /**
         * The automation execution mode.
         */
        public var mode: aws.sdk.kotlin.services.ssm.model.ExecutionMode? = null
        /**
         * The ID of an OpsItem that is created to represent a Change Manager change request.
         */
        public var opsItemId: kotlin.String? = null
        /**
         * The list of execution outputs as defined in the Automation runbook.
         */
        public var outputs: Map<String, List<String>>? = null
        /**
         * The key-value map of execution parameters, which were supplied when calling StartAutomationExecution.
         */
        public var parameters: Map<String, List<String>>? = null
        /**
         * The AutomationExecutionId of the parent automation.
         */
        public var parentAutomationExecutionId: kotlin.String? = null
        /**
         * An aggregate of step execution statuses displayed in the Amazon Web Services Systems Manager console for a multi-Region and multi-account Automation execution.
         */
        public var progressCounters: aws.sdk.kotlin.services.ssm.model.ProgressCounters? = null
        /**
         * A list of resolved targets in the rate control execution.
         */
        public var resolvedTargets: aws.sdk.kotlin.services.ssm.model.ResolvedTargets? = null
        /**
         * Information about the Automation runbooks that are run as part of a runbook workflow.
         *
         * The Automation runbooks specified for the runbook workflow can't run until all required approvals for the change request have been received.
         */
        public var runbooks: List<Runbook>? = null
        /**
         * The date and time the Automation operation is scheduled to start.
         */
        public var scheduledTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of details about the current state of all steps that comprise an execution. An Automation runbook contains a list of steps that are run in order.
         */
        public var stepExecutions: List<StepExecution>? = null
        /**
         * A boolean value that indicates if the response contains the full list of the Automation step executions. If true, use the DescribeAutomationStepExecutions API operation to get the full list of step executions.
         */
        public var stepExecutionsTruncated: kotlin.Boolean = false
        /**
         * The target of the execution.
         */
        public var target: kotlin.String? = null
        /**
         * The combination of Amazon Web Services Regions and/or Amazon Web Services accounts where you want to run the Automation.
         */
        public var targetLocations: List<TargetLocation>? = null
        /**
         * The specified key-value mapping of document parameters to target resources.
         */
        public var targetMaps: List<Map<String, List<String>>>? = null
        /**
         * The parameter name.
         */
        public var targetParameterName: kotlin.String? = null
        /**
         * The specified targets.
         */
        public var targets: List<Target>? = null
        /**
         * The CloudWatch alarm that was invoked by the automation.
         */
        public var triggeredAlarms: List<AlarmStateInformation>? = null
        /**
         * Variables defined for the automation.
         */
        public var variables: Map<String, List<String>>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.AutomationExecution) : this() {
            this.alarmConfiguration = x.alarmConfiguration
            this.associationId = x.associationId
            this.automationExecutionId = x.automationExecutionId
            this.automationExecutionStatus = x.automationExecutionStatus
            this.automationSubtype = x.automationSubtype
            this.changeRequestName = x.changeRequestName
            this.currentAction = x.currentAction
            this.currentStepName = x.currentStepName
            this.documentName = x.documentName
            this.documentVersion = x.documentVersion
            this.executedBy = x.executedBy
            this.executionEndTime = x.executionEndTime
            this.executionStartTime = x.executionStartTime
            this.failureMessage = x.failureMessage
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.mode = x.mode
            this.opsItemId = x.opsItemId
            this.outputs = x.outputs
            this.parameters = x.parameters
            this.parentAutomationExecutionId = x.parentAutomationExecutionId
            this.progressCounters = x.progressCounters
            this.resolvedTargets = x.resolvedTargets
            this.runbooks = x.runbooks
            this.scheduledTime = x.scheduledTime
            this.stepExecutions = x.stepExecutions
            this.stepExecutionsTruncated = x.stepExecutionsTruncated
            this.target = x.target
            this.targetLocations = x.targetLocations
            this.targetMaps = x.targetMaps
            this.targetParameterName = x.targetParameterName
            this.targets = x.targets
            this.triggeredAlarms = x.triggeredAlarms
            this.variables = x.variables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.AutomationExecution = AutomationExecution(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.AlarmConfiguration] inside the given [block]
         */
        public fun alarmConfiguration(block: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.Builder.() -> kotlin.Unit) {
            this.alarmConfiguration = aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.ProgressCounters] inside the given [block]
         */
        public fun progressCounters(block: aws.sdk.kotlin.services.ssm.model.ProgressCounters.Builder.() -> kotlin.Unit) {
            this.progressCounters = aws.sdk.kotlin.services.ssm.model.ProgressCounters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.ResolvedTargets] inside the given [block]
         */
        public fun resolvedTargets(block: aws.sdk.kotlin.services.ssm.model.ResolvedTargets.Builder.() -> kotlin.Unit) {
            this.resolvedTargets = aws.sdk.kotlin.services.ssm.model.ResolvedTargets.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
