// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the association version.
 */
public class AssociationVersionInfo private constructor(builder: Builder) {
    /**
     * By default, when you create a new associations, the system runs it immediately after it is created and then according to the schedule you specified. Specify this option if you don't want an association to run immediately after you create it. This parameter isn't supported for rate expressions.
     */
    public val applyOnlyAtCronInterval: kotlin.Boolean = builder.applyOnlyAtCronInterval
    /**
     * The ID created by the system when the association was created.
     */
    public val associationId: kotlin.String? = builder.associationId
    /**
     * The name specified for the association version when the association version was created.
     */
    public val associationName: kotlin.String? = builder.associationName
    /**
     * The association version.
     */
    public val associationVersion: kotlin.String? = builder.associationVersion
    /**
     * The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated under. The associations for this version only run when that Change Calendar is open. For more information, see [Amazon Web Services Systems Manager Change Calendar](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar).
     */
    public val calendarNames: List<String>? = builder.calendarNames
    /**
     * The severity level that is assigned to the association.
     */
    public val complianceSeverity: aws.sdk.kotlin.services.ssm.model.AssociationComplianceSeverity? = builder.complianceSeverity
    /**
     * The date the association version was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The version of an Amazon Web Services Systems Manager document (SSM document) used when the association version was created.
     */
    public val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.
     *
     * If a new managed node starts and attempts to run an association while Systems Manager is running `MaxConcurrency` associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for `MaxConcurrency`.
     */
    public val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set `MaxError` to 10%, then the system stops sending the request when the sixth error is received.
     *
     * Executions that are already running an association when `MaxErrors` is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set `MaxConcurrency` to 1 so that executions proceed one at a time.
     */
    public val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * The name specified when the association was created.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The location in Amazon S3 specified for the association when the association version was created.
     */
    public val outputLocation: aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation? = builder.outputLocation
    /**
     * Parameters specified when the association version was created.
     */
    public val parameters: Map<String, List<String>>? = builder.parameters
    /**
     * The cron or rate schedule specified for the association when the association version was created.
     */
    public val scheduleExpression: kotlin.String? = builder.scheduleExpression
    /**
     * Number of days to wait after the scheduled day to run an association.
     */
    public val scheduleOffset: kotlin.Int? = builder.scheduleOffset
    /**
     * The mode for generating association compliance. You can specify `AUTO` or `MANUAL`. In `AUTO` mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is `COMPLIANT`. If the association execution doesn't run successfully, the association is `NON-COMPLIANT`.
     *
     * In `MANUAL` mode, you must specify the `AssociationId` as a parameter for the PutComplianceItems API operation. In this case, compliance data isn't managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the PutComplianceItems API operation.
     *
     * By default, all associations use `AUTO` mode.
     */
    public val syncCompliance: aws.sdk.kotlin.services.ssm.model.AssociationSyncCompliance? = builder.syncCompliance
    /**
     * The combination of Amazon Web Services Regions and Amazon Web Services accounts where you wanted to run the association when this association version was created.
     */
    public val targetLocations: List<TargetLocation>? = builder.targetLocations
    /**
     * A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be specified together.
     */
    public val targetMaps: List<Map<String, List<String>>>? = builder.targetMaps
    /**
     * The targets specified for the association when the association version was created.
     */
    public val targets: List<Target>? = builder.targets

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.AssociationVersionInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssociationVersionInfo(")
        append("applyOnlyAtCronInterval=$applyOnlyAtCronInterval,")
        append("associationId=$associationId,")
        append("associationName=$associationName,")
        append("associationVersion=$associationVersion,")
        append("calendarNames=$calendarNames,")
        append("complianceSeverity=$complianceSeverity,")
        append("createdDate=$createdDate,")
        append("documentVersion=$documentVersion,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("name=$name,")
        append("outputLocation=$outputLocation,")
        append("parameters=*** Sensitive Data Redacted ***,")
        append("scheduleExpression=$scheduleExpression,")
        append("scheduleOffset=$scheduleOffset,")
        append("syncCompliance=$syncCompliance,")
        append("targetLocations=$targetLocations,")
        append("targetMaps=$targetMaps,")
        append("targets=$targets")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyOnlyAtCronInterval.hashCode()
        result = 31 * result + (associationId?.hashCode() ?: 0)
        result = 31 * result + (associationName?.hashCode() ?: 0)
        result = 31 * result + (associationVersion?.hashCode() ?: 0)
        result = 31 * result + (calendarNames?.hashCode() ?: 0)
        result = 31 * result + (complianceSeverity?.hashCode() ?: 0)
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (documentVersion?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (maxErrors?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputLocation?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (scheduleOffset ?: 0)
        result = 31 * result + (syncCompliance?.hashCode() ?: 0)
        result = 31 * result + (targetLocations?.hashCode() ?: 0)
        result = 31 * result + (targetMaps?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssociationVersionInfo

        if (applyOnlyAtCronInterval != other.applyOnlyAtCronInterval) return false
        if (associationId != other.associationId) return false
        if (associationName != other.associationName) return false
        if (associationVersion != other.associationVersion) return false
        if (calendarNames != other.calendarNames) return false
        if (complianceSeverity != other.complianceSeverity) return false
        if (createdDate != other.createdDate) return false
        if (documentVersion != other.documentVersion) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (name != other.name) return false
        if (outputLocation != other.outputLocation) return false
        if (parameters != other.parameters) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (scheduleOffset != other.scheduleOffset) return false
        if (syncCompliance != other.syncCompliance) return false
        if (targetLocations != other.targetLocations) return false
        if (targetMaps != other.targetMaps) return false
        if (targets != other.targets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.AssociationVersionInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * By default, when you create a new associations, the system runs it immediately after it is created and then according to the schedule you specified. Specify this option if you don't want an association to run immediately after you create it. This parameter isn't supported for rate expressions.
         */
        public var applyOnlyAtCronInterval: kotlin.Boolean = false
        /**
         * The ID created by the system when the association was created.
         */
        public var associationId: kotlin.String? = null
        /**
         * The name specified for the association version when the association version was created.
         */
        public var associationName: kotlin.String? = null
        /**
         * The association version.
         */
        public var associationVersion: kotlin.String? = null
        /**
         * The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated under. The associations for this version only run when that Change Calendar is open. For more information, see [Amazon Web Services Systems Manager Change Calendar](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar).
         */
        public var calendarNames: List<String>? = null
        /**
         * The severity level that is assigned to the association.
         */
        public var complianceSeverity: aws.sdk.kotlin.services.ssm.model.AssociationComplianceSeverity? = null
        /**
         * The date the association version was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The version of an Amazon Web Services Systems Manager document (SSM document) used when the association version was created.
         */
        public var documentVersion: kotlin.String? = null
        /**
         * The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.
         *
         * If a new managed node starts and attempts to run an association while Systems Manager is running `MaxConcurrency` associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for `MaxConcurrency`.
         */
        public var maxConcurrency: kotlin.String? = null
        /**
         * The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set `MaxError` to 10%, then the system stops sending the request when the sixth error is received.
         *
         * Executions that are already running an association when `MaxErrors` is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set `MaxConcurrency` to 1 so that executions proceed one at a time.
         */
        public var maxErrors: kotlin.String? = null
        /**
         * The name specified when the association was created.
         */
        public var name: kotlin.String? = null
        /**
         * The location in Amazon S3 specified for the association when the association version was created.
         */
        public var outputLocation: aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation? = null
        /**
         * Parameters specified when the association version was created.
         */
        public var parameters: Map<String, List<String>>? = null
        /**
         * The cron or rate schedule specified for the association when the association version was created.
         */
        public var scheduleExpression: kotlin.String? = null
        /**
         * Number of days to wait after the scheduled day to run an association.
         */
        public var scheduleOffset: kotlin.Int? = null
        /**
         * The mode for generating association compliance. You can specify `AUTO` or `MANUAL`. In `AUTO` mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is `COMPLIANT`. If the association execution doesn't run successfully, the association is `NON-COMPLIANT`.
         *
         * In `MANUAL` mode, you must specify the `AssociationId` as a parameter for the PutComplianceItems API operation. In this case, compliance data isn't managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the PutComplianceItems API operation.
         *
         * By default, all associations use `AUTO` mode.
         */
        public var syncCompliance: aws.sdk.kotlin.services.ssm.model.AssociationSyncCompliance? = null
        /**
         * The combination of Amazon Web Services Regions and Amazon Web Services accounts where you wanted to run the association when this association version was created.
         */
        public var targetLocations: List<TargetLocation>? = null
        /**
         * A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be specified together.
         */
        public var targetMaps: List<Map<String, List<String>>>? = null
        /**
         * The targets specified for the association when the association version was created.
         */
        public var targets: List<Target>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.AssociationVersionInfo) : this() {
            this.applyOnlyAtCronInterval = x.applyOnlyAtCronInterval
            this.associationId = x.associationId
            this.associationName = x.associationName
            this.associationVersion = x.associationVersion
            this.calendarNames = x.calendarNames
            this.complianceSeverity = x.complianceSeverity
            this.createdDate = x.createdDate
            this.documentVersion = x.documentVersion
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.name = x.name
            this.outputLocation = x.outputLocation
            this.parameters = x.parameters
            this.scheduleExpression = x.scheduleExpression
            this.scheduleOffset = x.scheduleOffset
            this.syncCompliance = x.syncCompliance
            this.targetLocations = x.targetLocations
            this.targetMaps = x.targetMaps
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.AssociationVersionInfo = AssociationVersionInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation] inside the given [block]
         */
        public fun outputLocation(block: aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation.Builder.() -> kotlin.Unit) {
            this.outputLocation = aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
