// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.serde

import aws.sdk.kotlin.services.sqs.model.ListQueueTagsResponse
import aws.sdk.kotlin.services.sqs.model.SqsException
import aws.smithy.kotlin.runtime.awsprotocol.AwsQueryCompatibleErrorDetails
import aws.smithy.kotlin.runtime.awsprotocol.X_AMZN_QUERY_ERROR_HEADER
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.setAwsQueryCompatibleErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class ListQueueTagsOperationDeserializer: HttpDeserializer.NonStreaming<ListQueueTagsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListQueueTagsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListQueueTagsError(context, call, payload)
        }
        val builder = ListQueueTagsResponse.Builder()

        if (payload != null) {
            deserializeListQueueTagsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListQueueTagsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SqsException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    var queryErrorDetails: AwsQueryCompatibleErrorDetails? = null
    call.response.headers[X_AMZN_QUERY_ERROR_HEADER]?.let {
        queryErrorDetails = try {
            AwsQueryCompatibleErrorDetails.parse(it)
        } catch (ex: Exception) {
            throw SqsException("Failed to parse awsQuery-compatible error", ex).also {
                setAseErrorMetadata(it, wrappedResponse, errorDetails)
            }
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidAddress" -> InvalidAddressDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperation" -> UnsupportedOperationDeserializer().deserialize(context, wrappedCall, payload)
        "RequestThrottled" -> RequestThrottledDeserializer().deserialize(context, wrappedCall, payload)
        "QueueDoesNotExist" -> QueueDoesNotExistDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSecurity" -> InvalidSecurityDeserializer().deserialize(context, wrappedCall, payload)
        else -> SqsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    queryErrorDetails?.let { setAwsQueryCompatibleErrorMetadata(ex, it) }
    throw ex
}

private fun deserializeListQueueTagsOperationBody(builder: ListQueueTagsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
