// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.serde

import aws.sdk.kotlin.services.sqs.model.ListMessageMoveTasksResponse
import aws.sdk.kotlin.services.sqs.model.ListMessageMoveTasksResultEntry
import aws.sdk.kotlin.services.sqs.model.SqsException
import aws.smithy.kotlin.runtime.awsprotocol.AwsQueryCompatibleErrorDetails
import aws.smithy.kotlin.runtime.awsprotocol.X_AMZN_QUERY_ERROR_HEADER
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.setAwsQueryCompatibleErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListMessageMoveTasksOperationDeserializer: HttpDeserializer.NonStreaming<ListMessageMoveTasksResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListMessageMoveTasksResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListMessageMoveTasksError(context, call, payload)
        }
        val builder = ListMessageMoveTasksResponse.Builder()

        if (payload != null) {
            deserializeListMessageMoveTasksOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListMessageMoveTasksError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SqsException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    var queryErrorDetails: AwsQueryCompatibleErrorDetails? = null
    call.response.headers[X_AMZN_QUERY_ERROR_HEADER]?.let {
        queryErrorDetails = try {
            AwsQueryCompatibleErrorDetails.parse(it)
        } catch (ex: Exception) {
            throw SqsException("Failed to parse awsQuery-compatible error", ex).also {
                setAseErrorMetadata(it, wrappedResponse, errorDetails)
            }
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidAddress" -> InvalidAddressDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedOperation" -> UnsupportedOperationDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RequestThrottled" -> RequestThrottledDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidSecurity" -> InvalidSecurityDeserializer().deserialize(context, wrappedCall, payload)
        else -> SqsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    queryErrorDetails?.let { setAwsQueryCompatibleErrorMetadata(ex, it) }
    throw ex
}

private fun deserializeListMessageMoveTasksOperationBody(builder: ListMessageMoveTasksResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Results"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESULTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RESULTS_DESCRIPTOR.index -> builder.results =
                    deserializer.deserializeList(RESULTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ListMessageMoveTasksResultEntry>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeListMessageMoveTasksResultEntryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
