// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartMessageMoveTaskRequest private constructor(builder: Builder) {
    /**
     * The ARN of the queue that receives the moved messages. You can use this field to specify the destination queue where you would like to redrive messages. If this field is left blank, the messages will be redriven back to their respective original source queues.
     */
    public val destinationArn: kotlin.String? = builder.destinationArn
    /**
     * The number of messages to be moved per second (the message movement rate). You can use this field to define a fixed message movement rate. The maximum value for messages per second is 500. If this field is left blank, the system will optimize the rate based on the queue message backlog size, which may vary throughout the duration of the message movement task.
     */
    public val maxNumberOfMessagesPerSecond: kotlin.Int? = builder.maxNumberOfMessagesPerSecond
    /**
     * The ARN of the queue that contains the messages to be moved to another queue. Currently, only ARNs of dead-letter queues (DLQs) whose sources are other Amazon SQS queues are accepted. DLQs whose sources are non-SQS queues, such as Lambda or Amazon SNS topics, are not currently supported.
     */
    public val sourceArn: kotlin.String? = builder.sourceArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sqs.model.StartMessageMoveTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartMessageMoveTaskRequest(")
        append("destinationArn=$destinationArn,")
        append("maxNumberOfMessagesPerSecond=$maxNumberOfMessagesPerSecond,")
        append("sourceArn=$sourceArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationArn?.hashCode() ?: 0
        result = 31 * result + (maxNumberOfMessagesPerSecond ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartMessageMoveTaskRequest

        if (destinationArn != other.destinationArn) return false
        if (maxNumberOfMessagesPerSecond != other.maxNumberOfMessagesPerSecond) return false
        if (sourceArn != other.sourceArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sqs.model.StartMessageMoveTaskRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the queue that receives the moved messages. You can use this field to specify the destination queue where you would like to redrive messages. If this field is left blank, the messages will be redriven back to their respective original source queues.
         */
        public var destinationArn: kotlin.String? = null
        /**
         * The number of messages to be moved per second (the message movement rate). You can use this field to define a fixed message movement rate. The maximum value for messages per second is 500. If this field is left blank, the system will optimize the rate based on the queue message backlog size, which may vary throughout the duration of the message movement task.
         */
        public var maxNumberOfMessagesPerSecond: kotlin.Int? = null
        /**
         * The ARN of the queue that contains the messages to be moved to another queue. Currently, only ARNs of dead-letter queues (DLQs) whose sources are other Amazon SQS queues are accepted. DLQs whose sources are non-SQS queues, such as Lambda or Amazon SNS topics, are not currently supported.
         */
        public var sourceArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sqs.model.StartMessageMoveTaskRequest) : this() {
            this.destinationArn = x.destinationArn
            this.maxNumberOfMessagesPerSecond = x.maxNumberOfMessagesPerSecond
            this.sourceArn = x.sourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sqs.model.StartMessageMoveTaskRequest = StartMessageMoveTaskRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
