// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Encloses a `MessageId` for a successfully-enqueued message in a ` <a>SendMessageBatch</a>.`
 */
public class SendMessageBatchResultEntry private constructor(builder: Builder) {
    /**
     * An identifier for the message in this batch.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see [RFC1321](https://www.ietf.org/rfc/rfc1321.txt).
     */
    public val md5OfMessageAttributes: kotlin.String? = builder.md5OfMessageAttributes
    /**
     * An MD5 digest of the non-URL-encoded message body string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see [RFC1321](https://www.ietf.org/rfc/rfc1321.txt).
     */
    public val md5OfMessageBody: kotlin.String = requireNotNull(builder.md5OfMessageBody) { "A non-null value must be provided for md5OfMessageBody" }
    /**
     * An MD5 digest of the non-URL-encoded message system attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see [RFC1321](https://www.ietf.org/rfc/rfc1321.txt).
     */
    public val md5OfMessageSystemAttributes: kotlin.String? = builder.md5OfMessageSystemAttributes
    /**
     * An identifier for the message.
     */
    public val messageId: kotlin.String = requireNotNull(builder.messageId) { "A non-null value must be provided for messageId" }
    /**
     * This parameter applies only to FIFO (first-in-first-out) queues.
     *
     * The large, non-consecutive number that Amazon SQS assigns to each message.
     *
     * The length of `SequenceNumber` is 128 bits. As `SequenceNumber` continues to increase for a particular `MessageGroupId`.
     */
    public val sequenceNumber: kotlin.String? = builder.sequenceNumber

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sqs.model.SendMessageBatchResultEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SendMessageBatchResultEntry(")
        append("id=$id,")
        append("md5OfMessageAttributes=$md5OfMessageAttributes,")
        append("md5OfMessageBody=$md5OfMessageBody,")
        append("md5OfMessageSystemAttributes=$md5OfMessageSystemAttributes,")
        append("messageId=$messageId,")
        append("sequenceNumber=$sequenceNumber")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = id.hashCode()
        result = 31 * result + (md5OfMessageAttributes?.hashCode() ?: 0)
        result = 31 * result + (md5OfMessageBody.hashCode())
        result = 31 * result + (md5OfMessageSystemAttributes?.hashCode() ?: 0)
        result = 31 * result + (messageId.hashCode())
        result = 31 * result + (sequenceNumber?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SendMessageBatchResultEntry

        if (id != other.id) return false
        if (md5OfMessageAttributes != other.md5OfMessageAttributes) return false
        if (md5OfMessageBody != other.md5OfMessageBody) return false
        if (md5OfMessageSystemAttributes != other.md5OfMessageSystemAttributes) return false
        if (messageId != other.messageId) return false
        if (sequenceNumber != other.sequenceNumber) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sqs.model.SendMessageBatchResultEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An identifier for the message in this batch.
         */
        public var id: kotlin.String? = null
        /**
         * An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see [RFC1321](https://www.ietf.org/rfc/rfc1321.txt).
         */
        public var md5OfMessageAttributes: kotlin.String? = null
        /**
         * An MD5 digest of the non-URL-encoded message body string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see [RFC1321](https://www.ietf.org/rfc/rfc1321.txt).
         */
        public var md5OfMessageBody: kotlin.String? = null
        /**
         * An MD5 digest of the non-URL-encoded message system attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see [RFC1321](https://www.ietf.org/rfc/rfc1321.txt).
         */
        public var md5OfMessageSystemAttributes: kotlin.String? = null
        /**
         * An identifier for the message.
         */
        public var messageId: kotlin.String? = null
        /**
         * This parameter applies only to FIFO (first-in-first-out) queues.
         *
         * The large, non-consecutive number that Amazon SQS assigns to each message.
         *
         * The length of `SequenceNumber` is 128 bits. As `SequenceNumber` continues to increase for a particular `MessageGroupId`.
         */
        public var sequenceNumber: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sqs.model.SendMessageBatchResultEntry) : this() {
            this.id = x.id
            this.md5OfMessageAttributes = x.md5OfMessageAttributes
            this.md5OfMessageBody = x.md5OfMessageBody
            this.md5OfMessageSystemAttributes = x.md5OfMessageSystemAttributes
            this.messageId = x.messageId
            this.sequenceNumber = x.sequenceNumber
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sqs.model.SendMessageBatchResultEntry = SendMessageBatchResultEntry(this)

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (md5OfMessageBody == null) md5OfMessageBody = ""
            if (messageId == null) messageId = ""
            return this
        }
    }
}
