// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An Amazon SQS message.
 */
public class Message private constructor(builder: Builder) {
    /**
     * A map of the attributes requested in ` <a>ReceiveMessage</a> ` to their respective values. Supported attributes:
     * + `ApproximateReceiveCount`
     * + `ApproximateFirstReceiveTimestamp`
     * + `MessageDeduplicationId`
     * + `MessageGroupId`
     * + `SenderId`
     * + `SentTimestamp`
     * + `SequenceNumber`
     *
     * `ApproximateFirstReceiveTimestamp` and `SentTimestamp` are each returned as an integer representing the [epoch time](http://en.wikipedia.org/wiki/Unix_time) in milliseconds.
     */
    public val attributes: Map<MessageSystemAttributeName, String>? = builder.attributes
    /**
     * The message's contents (not URL-encoded).
     */
    public val body: kotlin.String? = builder.body
    /**
     * An MD5 digest of the non-URL-encoded message body string.
     */
    public val md5OfBody: kotlin.String? = builder.md5OfBody
    /**
     * An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see [RFC1321](https://www.ietf.org/rfc/rfc1321.txt).
     */
    public val md5OfMessageAttributes: kotlin.String? = builder.md5OfMessageAttributes
    /**
     * Each message attribute consists of a `Name`, `Type`, and `Value`. For more information, see [Amazon SQS message attributes](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes) in the *Amazon SQS Developer Guide*.
     */
    public val messageAttributes: Map<String, MessageAttributeValue>? = builder.messageAttributes
    /**
     * A unique identifier for the message. A `MessageId`is considered unique across all Amazon Web Services accounts for an extended period of time.
     */
    public val messageId: kotlin.String? = builder.messageId
    /**
     * An identifier associated with the act of receiving the message. A new receipt handle is returned every time you receive a message. When deleting a message, you provide the last received receipt handle to delete the message.
     */
    public val receiptHandle: kotlin.String? = builder.receiptHandle

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sqs.model.Message = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Message(")
        append("attributes=$attributes,")
        append("body=$body,")
        append("md5OfBody=$md5OfBody,")
        append("md5OfMessageAttributes=$md5OfMessageAttributes,")
        append("messageAttributes=$messageAttributes,")
        append("messageId=$messageId,")
        append("receiptHandle=$receiptHandle")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (md5OfBody?.hashCode() ?: 0)
        result = 31 * result + (md5OfMessageAttributes?.hashCode() ?: 0)
        result = 31 * result + (messageAttributes?.hashCode() ?: 0)
        result = 31 * result + (messageId?.hashCode() ?: 0)
        result = 31 * result + (receiptHandle?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Message

        if (attributes != other.attributes) return false
        if (body != other.body) return false
        if (md5OfBody != other.md5OfBody) return false
        if (md5OfMessageAttributes != other.md5OfMessageAttributes) return false
        if (messageAttributes != other.messageAttributes) return false
        if (messageId != other.messageId) return false
        if (receiptHandle != other.receiptHandle) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sqs.model.Message = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A map of the attributes requested in ` <a>ReceiveMessage</a> ` to their respective values. Supported attributes:
         * + `ApproximateReceiveCount`
         * + `ApproximateFirstReceiveTimestamp`
         * + `MessageDeduplicationId`
         * + `MessageGroupId`
         * + `SenderId`
         * + `SentTimestamp`
         * + `SequenceNumber`
         *
         * `ApproximateFirstReceiveTimestamp` and `SentTimestamp` are each returned as an integer representing the [epoch time](http://en.wikipedia.org/wiki/Unix_time) in milliseconds.
         */
        public var attributes: Map<MessageSystemAttributeName, String>? = null
        /**
         * The message's contents (not URL-encoded).
         */
        public var body: kotlin.String? = null
        /**
         * An MD5 digest of the non-URL-encoded message body string.
         */
        public var md5OfBody: kotlin.String? = null
        /**
         * An MD5 digest of the non-URL-encoded message attribute string. You can use this attribute to verify that Amazon SQS received the message correctly. Amazon SQS URL-decodes the message before creating the MD5 digest. For information about MD5, see [RFC1321](https://www.ietf.org/rfc/rfc1321.txt).
         */
        public var md5OfMessageAttributes: kotlin.String? = null
        /**
         * Each message attribute consists of a `Name`, `Type`, and `Value`. For more information, see [Amazon SQS message attributes](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes) in the *Amazon SQS Developer Guide*.
         */
        public var messageAttributes: Map<String, MessageAttributeValue>? = null
        /**
         * A unique identifier for the message. A `MessageId`is considered unique across all Amazon Web Services accounts for an extended period of time.
         */
        public var messageId: kotlin.String? = null
        /**
         * An identifier associated with the act of receiving the message. A new receipt handle is returned every time you receive a message. When deleting a message, you provide the last received receipt handle to delete the message.
         */
        public var receiptHandle: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sqs.model.Message) : this() {
            this.attributes = x.attributes
            this.body = x.body
            this.md5OfBody = x.md5OfBody
            this.md5OfMessageAttributes = x.md5OfMessageAttributes
            this.messageAttributes = x.messageAttributes
            this.messageId = x.messageId
            this.receiptHandle = x.receiptHandle
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sqs.model.Message = Message(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
