// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.serde

import aws.sdk.kotlin.services.sqs.model.SendMessageResponse
import aws.sdk.kotlin.services.sqs.model.SqsException
import aws.smithy.kotlin.runtime.awsprotocol.AwsQueryCompatibleErrorDetails
import aws.smithy.kotlin.runtime.awsprotocol.X_AMZN_QUERY_ERROR_HEADER
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.setAwsQueryCompatibleErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SendMessageOperationDeserializer: HttpDeserialize<SendMessageResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): SendMessageResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSendMessageError(context, call)
        }
        val builder = SendMessageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSendMessageOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwSendMessageError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SqsException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    var queryErrorDetails: AwsQueryCompatibleErrorDetails? = null
    call.response.headers[X_AMZN_QUERY_ERROR_HEADER]?.let {
        queryErrorDetails = try {
            AwsQueryCompatibleErrorDetails.parse(it)
        } catch (ex: Exception) {
            throw SqsException("Failed to parse awsQuery-compatible error", ex).also {
                setAseErrorMetadata(it, wrappedResponse, errorDetails)
            }
        }
    }

    val ex = when(errorDetails.code) {
        "KmsAccessDenied" -> KmsAccessDeniedDeserializer().deserialize(context, wrappedCall)
        "KmsNotFound" -> KmsNotFoundDeserializer().deserialize(context, wrappedCall)
        "RequestThrottled" -> RequestThrottledDeserializer().deserialize(context, wrappedCall)
        "QueueDoesNotExist" -> QueueDoesNotExistDeserializer().deserialize(context, wrappedCall)
        "KmsInvalidState" -> KmsInvalidStateDeserializer().deserialize(context, wrappedCall)
        "InvalidSecurity" -> InvalidSecurityDeserializer().deserialize(context, wrappedCall)
        "InvalidAddress" -> InvalidAddressDeserializer().deserialize(context, wrappedCall)
        "KmsInvalidKeyUsage" -> KmsInvalidKeyUsageDeserializer().deserialize(context, wrappedCall)
        "KmsThrottled" -> KmsThrottledDeserializer().deserialize(context, wrappedCall)
        "UnsupportedOperation" -> UnsupportedOperationDeserializer().deserialize(context, wrappedCall)
        "InvalidMessageContents" -> InvalidMessageContentsDeserializer().deserialize(context, wrappedCall)
        "KmsDisabled" -> KmsDisabledDeserializer().deserialize(context, wrappedCall)
        "KmsOptInRequired" -> KmsOptInRequiredDeserializer().deserialize(context, wrappedCall)
        else -> SqsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    queryErrorDetails?.let { setAwsQueryCompatibleErrorMetadata(ex, it) }
    throw ex
}

private fun deserializeSendMessageOperationBody(builder: SendMessageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MD5OFMESSAGEATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MD5OfMessageAttributes"))
    val MD5OFMESSAGEBODY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MD5OfMessageBody"))
    val MD5OFMESSAGESYSTEMATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MD5OfMessageSystemAttributes"))
    val MESSAGEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MessageId"))
    val SEQUENCENUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SequenceNumber"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MD5OFMESSAGEATTRIBUTES_DESCRIPTOR)
        field(MD5OFMESSAGEBODY_DESCRIPTOR)
        field(MD5OFMESSAGESYSTEMATTRIBUTES_DESCRIPTOR)
        field(MESSAGEID_DESCRIPTOR)
        field(SEQUENCENUMBER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MD5OFMESSAGEATTRIBUTES_DESCRIPTOR.index -> builder.md5OfMessageAttributes = deserializeString()
                MD5OFMESSAGEBODY_DESCRIPTOR.index -> builder.md5OfMessageBody = deserializeString()
                MD5OFMESSAGESYSTEMATTRIBUTES_DESCRIPTOR.index -> builder.md5OfMessageSystemAttributes = deserializeString()
                MESSAGEID_DESCRIPTOR.index -> builder.messageId = deserializeString()
                SEQUENCENUMBER_DESCRIPTOR.index -> builder.sequenceNumber = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
