// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.model



/**
 *
 */
public class ReceiveMessageRequest private constructor(builder: Builder) {
    /**
     * A list of attributes that need to be returned along with each message. These attributes include:
     * + `All` – Returns all values.
     * + `ApproximateFirstReceiveTimestamp` – Returns the time the message was first received from the queue ([epoch time](http://en.wikipedia.org/wiki/Unix_time) in milliseconds).
     * + `ApproximateReceiveCount` – Returns the number of times a message has been received across all queues but not deleted.
     * + `AWSTraceHeader` – Returns the X-Ray trace header string.
     * + `SenderId`
     *    + For a user, returns the user ID, for example `ABCDEFGHI1JKLMNOPQ23R`.
     *    + For an IAM role, returns the IAM role ID, for example `ABCDE1F2GH3I4JK5LMNOP:i-a123b456`.
     * + `SentTimestamp` – Returns the time the message was sent to the queue ([epoch time](http://en.wikipedia.org/wiki/Unix_time) in milliseconds).
     * + `SqsManagedSseEnabled` – Enables server-side queue encryption using SQS owned encryption keys. Only one server-side encryption option is supported per queue (for example, [SSE-KMS](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html) or [SSE-SQS](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html)).
     * + `MessageDeduplicationId` – Returns the value provided by the producer that calls the ` <a>SendMessage</a> ` action.
     * + `MessageGroupId` – Returns the value provided by the producer that calls the ` <a>SendMessage</a> ` action. Messages with the same `MessageGroupId` are returned in sequence.
     * + `SequenceNumber` – Returns the value provided by Amazon SQS.
     */
    public val attributeNames: List<QueueAttributeName>? = builder.attributeNames
    /**
     * The maximum number of messages to return. Amazon SQS never returns more messages than this value (however, fewer messages might be returned). Valid values: 1 to 10. Default: 1.
     */
    public val maxNumberOfMessages: kotlin.Int? = builder.maxNumberOfMessages
    /**
     * The name of the message attribute, where *N* is the index.
     * + The name can contain alphanumeric characters and the underscore (`_`), hyphen (`-`), and period (`.`).
     * + The name is case-sensitive and must be unique among all attribute names for the message.
     * + The name must not start with AWS-reserved prefixes such as `AWS.` or `Amazon.` (or any casing variants).
     * + The name must not start or end with a period (`.`), and it should not have periods in succession (`..`).
     * + The name can be up to 256 characters long.
     *
     * When using `ReceiveMessage`, you can send a list of attribute names to receive, or you can return all of the attributes by specifying `All` or `.*` in your request. You can also use all message attributes starting with a prefix, for example `bar.*`.
     */
    public val messageAttributeNames: List<String>? = builder.messageAttributeNames
    /**
     * The URL of the Amazon SQS queue from which messages are received.
     *
     * Queue URLs and names are case-sensitive.
     */
    public val queueUrl: kotlin.String? = builder.queueUrl
    /**
     * This parameter applies only to FIFO (first-in-first-out) queues.
     *
     * The token used for deduplication of `ReceiveMessage` calls. If a networking issue occurs after a `ReceiveMessage` action, and instead of a response you receive a generic error, it is possible to retry the same action with an identical `ReceiveRequestAttemptId` to retrieve the same set of messages, even if their visibility timeout has not yet expired.
     * + You can use `ReceiveRequestAttemptId` only for 5 minutes after a `ReceiveMessage` action.
     * + When you set `FifoQueue`, a caller of the `ReceiveMessage` action can provide a `ReceiveRequestAttemptId` explicitly.
     * + If a caller of the `ReceiveMessage` action doesn't provide a `ReceiveRequestAttemptId`, Amazon SQS generates a `ReceiveRequestAttemptId`.
     * + It is possible to retry the `ReceiveMessage` action with the same `ReceiveRequestAttemptId` if none of the messages have been modified (deleted or had their visibility changes).
     * + During a visibility timeout, subsequent calls with the same `ReceiveRequestAttemptId` return the same messages and receipt handles. If a retry occurs within the deduplication interval, it resets the visibility timeout. For more information, see [Visibility Timeout](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html) in the *Amazon SQS Developer Guide*.If a caller of the `ReceiveMessage` action still processes messages when the visibility timeout expires and messages become visible, another worker consuming from the same queue can receive the same messages and therefore process duplicates. Also, if a consumer whose message processing time is longer than the visibility timeout tries to delete the processed messages, the action fails with an error.To mitigate this effect, ensure that your application observes a safe threshold before the visibility timeout expires and extend the visibility timeout as necessary.
     * + While messages with a particular `MessageGroupId` are invisible, no more messages belonging to the same `MessageGroupId` are returned until the visibility timeout expires. You can still receive messages with another `MessageGroupId` as long as it is also visible.
     * + If a caller of `ReceiveMessage` can't track the `ReceiveRequestAttemptId`, no retries work until the original visibility timeout expires. As a result, delays might occur but the messages in the queue remain in a strict order.
     *
     * The maximum length of `ReceiveRequestAttemptId` is 128 characters. `ReceiveRequestAttemptId` can contain alphanumeric characters (`a-z`, `A-Z`, `0-9`) and punctuation (`!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~`).
     *
     * For best practices of using `ReceiveRequestAttemptId`, see [Using the ReceiveRequestAttemptId Request Parameter](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-receiverequestattemptid-request-parameter.html) in the *Amazon SQS Developer Guide*.
     */
    public val receiveRequestAttemptId: kotlin.String? = builder.receiveRequestAttemptId
    /**
     * The duration (in seconds) that the received messages are hidden from subsequent retrieve requests after being retrieved by a `ReceiveMessage` request.
     */
    public val visibilityTimeout: kotlin.Int? = builder.visibilityTimeout
    /**
     * The duration (in seconds) for which the call waits for a message to arrive in the queue before returning. If a message is available, the call returns sooner than `WaitTimeSeconds`. If no messages are available and the wait time expires, the call returns successfully with an empty list of messages.
     *
     * To avoid HTTP errors, ensure that the HTTP response timeout for `ReceiveMessage` requests is longer than the `WaitTimeSeconds` parameter. For example, with the Java SDK, you can set HTTP transport settings using the [ NettyNioAsyncHttpClient](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/http/nio/netty/NettyNioAsyncHttpClient.html) for asynchronous clients, or the [ ApacheHttpClient](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/http/apache/ApacheHttpClient.html) for synchronous clients.
     */
    public val waitTimeSeconds: kotlin.Int? = builder.waitTimeSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sqs.model.ReceiveMessageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReceiveMessageRequest(")
        append("attributeNames=$attributeNames,")
        append("maxNumberOfMessages=$maxNumberOfMessages,")
        append("messageAttributeNames=$messageAttributeNames,")
        append("queueUrl=$queueUrl,")
        append("receiveRequestAttemptId=$receiveRequestAttemptId,")
        append("visibilityTimeout=$visibilityTimeout,")
        append("waitTimeSeconds=$waitTimeSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeNames?.hashCode() ?: 0
        result = 31 * result + (maxNumberOfMessages ?: 0)
        result = 31 * result + (messageAttributeNames?.hashCode() ?: 0)
        result = 31 * result + (queueUrl?.hashCode() ?: 0)
        result = 31 * result + (receiveRequestAttemptId?.hashCode() ?: 0)
        result = 31 * result + (visibilityTimeout ?: 0)
        result = 31 * result + (waitTimeSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReceiveMessageRequest

        if (attributeNames != other.attributeNames) return false
        if (maxNumberOfMessages != other.maxNumberOfMessages) return false
        if (messageAttributeNames != other.messageAttributeNames) return false
        if (queueUrl != other.queueUrl) return false
        if (receiveRequestAttemptId != other.receiveRequestAttemptId) return false
        if (visibilityTimeout != other.visibilityTimeout) return false
        if (waitTimeSeconds != other.waitTimeSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sqs.model.ReceiveMessageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of attributes that need to be returned along with each message. These attributes include:
         * + `All` – Returns all values.
         * + `ApproximateFirstReceiveTimestamp` – Returns the time the message was first received from the queue ([epoch time](http://en.wikipedia.org/wiki/Unix_time) in milliseconds).
         * + `ApproximateReceiveCount` – Returns the number of times a message has been received across all queues but not deleted.
         * + `AWSTraceHeader` – Returns the X-Ray trace header string.
         * + `SenderId`
         *    + For a user, returns the user ID, for example `ABCDEFGHI1JKLMNOPQ23R`.
         *    + For an IAM role, returns the IAM role ID, for example `ABCDE1F2GH3I4JK5LMNOP:i-a123b456`.
         * + `SentTimestamp` – Returns the time the message was sent to the queue ([epoch time](http://en.wikipedia.org/wiki/Unix_time) in milliseconds).
         * + `SqsManagedSseEnabled` – Enables server-side queue encryption using SQS owned encryption keys. Only one server-side encryption option is supported per queue (for example, [SSE-KMS](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html) or [SSE-SQS](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html)).
         * + `MessageDeduplicationId` – Returns the value provided by the producer that calls the ` <a>SendMessage</a> ` action.
         * + `MessageGroupId` – Returns the value provided by the producer that calls the ` <a>SendMessage</a> ` action. Messages with the same `MessageGroupId` are returned in sequence.
         * + `SequenceNumber` – Returns the value provided by Amazon SQS.
         */
        public var attributeNames: List<QueueAttributeName>? = null
        /**
         * The maximum number of messages to return. Amazon SQS never returns more messages than this value (however, fewer messages might be returned). Valid values: 1 to 10. Default: 1.
         */
        public var maxNumberOfMessages: kotlin.Int? = null
        /**
         * The name of the message attribute, where *N* is the index.
         * + The name can contain alphanumeric characters and the underscore (`_`), hyphen (`-`), and period (`.`).
         * + The name is case-sensitive and must be unique among all attribute names for the message.
         * + The name must not start with AWS-reserved prefixes such as `AWS.` or `Amazon.` (or any casing variants).
         * + The name must not start or end with a period (`.`), and it should not have periods in succession (`..`).
         * + The name can be up to 256 characters long.
         *
         * When using `ReceiveMessage`, you can send a list of attribute names to receive, or you can return all of the attributes by specifying `All` or `.*` in your request. You can also use all message attributes starting with a prefix, for example `bar.*`.
         */
        public var messageAttributeNames: List<String>? = null
        /**
         * The URL of the Amazon SQS queue from which messages are received.
         *
         * Queue URLs and names are case-sensitive.
         */
        public var queueUrl: kotlin.String? = null
        /**
         * This parameter applies only to FIFO (first-in-first-out) queues.
         *
         * The token used for deduplication of `ReceiveMessage` calls. If a networking issue occurs after a `ReceiveMessage` action, and instead of a response you receive a generic error, it is possible to retry the same action with an identical `ReceiveRequestAttemptId` to retrieve the same set of messages, even if their visibility timeout has not yet expired.
         * + You can use `ReceiveRequestAttemptId` only for 5 minutes after a `ReceiveMessage` action.
         * + When you set `FifoQueue`, a caller of the `ReceiveMessage` action can provide a `ReceiveRequestAttemptId` explicitly.
         * + If a caller of the `ReceiveMessage` action doesn't provide a `ReceiveRequestAttemptId`, Amazon SQS generates a `ReceiveRequestAttemptId`.
         * + It is possible to retry the `ReceiveMessage` action with the same `ReceiveRequestAttemptId` if none of the messages have been modified (deleted or had their visibility changes).
         * + During a visibility timeout, subsequent calls with the same `ReceiveRequestAttemptId` return the same messages and receipt handles. If a retry occurs within the deduplication interval, it resets the visibility timeout. For more information, see [Visibility Timeout](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html) in the *Amazon SQS Developer Guide*.If a caller of the `ReceiveMessage` action still processes messages when the visibility timeout expires and messages become visible, another worker consuming from the same queue can receive the same messages and therefore process duplicates. Also, if a consumer whose message processing time is longer than the visibility timeout tries to delete the processed messages, the action fails with an error.To mitigate this effect, ensure that your application observes a safe threshold before the visibility timeout expires and extend the visibility timeout as necessary.
         * + While messages with a particular `MessageGroupId` are invisible, no more messages belonging to the same `MessageGroupId` are returned until the visibility timeout expires. You can still receive messages with another `MessageGroupId` as long as it is also visible.
         * + If a caller of `ReceiveMessage` can't track the `ReceiveRequestAttemptId`, no retries work until the original visibility timeout expires. As a result, delays might occur but the messages in the queue remain in a strict order.
         *
         * The maximum length of `ReceiveRequestAttemptId` is 128 characters. `ReceiveRequestAttemptId` can contain alphanumeric characters (`a-z`, `A-Z`, `0-9`) and punctuation (`!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~`).
         *
         * For best practices of using `ReceiveRequestAttemptId`, see [Using the ReceiveRequestAttemptId Request Parameter](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-receiverequestattemptid-request-parameter.html) in the *Amazon SQS Developer Guide*.
         */
        public var receiveRequestAttemptId: kotlin.String? = null
        /**
         * The duration (in seconds) that the received messages are hidden from subsequent retrieve requests after being retrieved by a `ReceiveMessage` request.
         */
        public var visibilityTimeout: kotlin.Int? = null
        /**
         * The duration (in seconds) for which the call waits for a message to arrive in the queue before returning. If a message is available, the call returns sooner than `WaitTimeSeconds`. If no messages are available and the wait time expires, the call returns successfully with an empty list of messages.
         *
         * To avoid HTTP errors, ensure that the HTTP response timeout for `ReceiveMessage` requests is longer than the `WaitTimeSeconds` parameter. For example, with the Java SDK, you can set HTTP transport settings using the [ NettyNioAsyncHttpClient](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/http/nio/netty/NettyNioAsyncHttpClient.html) for asynchronous clients, or the [ ApacheHttpClient](https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/http/apache/ApacheHttpClient.html) for synchronous clients.
         */
        public var waitTimeSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sqs.model.ReceiveMessageRequest) : this() {
            this.attributeNames = x.attributeNames
            this.maxNumberOfMessages = x.maxNumberOfMessages
            this.messageAttributeNames = x.messageAttributeNames
            this.queueUrl = x.queueUrl
            this.receiveRequestAttemptId = x.receiveRequestAttemptId
            this.visibilityTimeout = x.visibilityTimeout
            this.waitTimeSeconds = x.waitTimeSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sqs.model.ReceiveMessageRequest = ReceiveMessageRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
