// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.sqs.auth.DefaultSqsAuthSchemeProvider
import aws.sdk.kotlin.services.sqs.auth.SqsAuthSchemeProvider
import aws.sdk.kotlin.services.sqs.endpoints.DefaultSqsEndpointProvider
import aws.sdk.kotlin.services.sqs.endpoints.SqsEndpointParameters
import aws.sdk.kotlin.services.sqs.endpoints.SqsEndpointProvider
import aws.sdk.kotlin.services.sqs.model.AddPermissionRequest
import aws.sdk.kotlin.services.sqs.model.AddPermissionResponse
import aws.sdk.kotlin.services.sqs.model.CancelMessageMoveTaskRequest
import aws.sdk.kotlin.services.sqs.model.CancelMessageMoveTaskResponse
import aws.sdk.kotlin.services.sqs.model.ChangeMessageVisibilityBatchRequest
import aws.sdk.kotlin.services.sqs.model.ChangeMessageVisibilityBatchResponse
import aws.sdk.kotlin.services.sqs.model.ChangeMessageVisibilityRequest
import aws.sdk.kotlin.services.sqs.model.ChangeMessageVisibilityResponse
import aws.sdk.kotlin.services.sqs.model.CreateQueueRequest
import aws.sdk.kotlin.services.sqs.model.CreateQueueResponse
import aws.sdk.kotlin.services.sqs.model.DeleteMessageBatchRequest
import aws.sdk.kotlin.services.sqs.model.DeleteMessageBatchResponse
import aws.sdk.kotlin.services.sqs.model.DeleteMessageRequest
import aws.sdk.kotlin.services.sqs.model.DeleteMessageResponse
import aws.sdk.kotlin.services.sqs.model.DeleteQueueRequest
import aws.sdk.kotlin.services.sqs.model.DeleteQueueResponse
import aws.sdk.kotlin.services.sqs.model.GetQueueAttributesRequest
import aws.sdk.kotlin.services.sqs.model.GetQueueAttributesResponse
import aws.sdk.kotlin.services.sqs.model.GetQueueUrlRequest
import aws.sdk.kotlin.services.sqs.model.GetQueueUrlResponse
import aws.sdk.kotlin.services.sqs.model.ListDeadLetterSourceQueuesRequest
import aws.sdk.kotlin.services.sqs.model.ListDeadLetterSourceQueuesResponse
import aws.sdk.kotlin.services.sqs.model.ListMessageMoveTasksRequest
import aws.sdk.kotlin.services.sqs.model.ListMessageMoveTasksResponse
import aws.sdk.kotlin.services.sqs.model.ListQueueTagsRequest
import aws.sdk.kotlin.services.sqs.model.ListQueueTagsResponse
import aws.sdk.kotlin.services.sqs.model.ListQueuesRequest
import aws.sdk.kotlin.services.sqs.model.ListQueuesResponse
import aws.sdk.kotlin.services.sqs.model.PurgeQueueRequest
import aws.sdk.kotlin.services.sqs.model.PurgeQueueResponse
import aws.sdk.kotlin.services.sqs.model.ReceiveMessageRequest
import aws.sdk.kotlin.services.sqs.model.ReceiveMessageResponse
import aws.sdk.kotlin.services.sqs.model.RemovePermissionRequest
import aws.sdk.kotlin.services.sqs.model.RemovePermissionResponse
import aws.sdk.kotlin.services.sqs.model.SendMessageBatchRequest
import aws.sdk.kotlin.services.sqs.model.SendMessageBatchResponse
import aws.sdk.kotlin.services.sqs.model.SendMessageRequest
import aws.sdk.kotlin.services.sqs.model.SendMessageResponse
import aws.sdk.kotlin.services.sqs.model.SetQueueAttributesRequest
import aws.sdk.kotlin.services.sqs.model.SetQueueAttributesResponse
import aws.sdk.kotlin.services.sqs.model.StartMessageMoveTaskRequest
import aws.sdk.kotlin.services.sqs.model.StartMessageMoveTaskResponse
import aws.sdk.kotlin.services.sqs.model.TagQueueRequest
import aws.sdk.kotlin.services.sqs.model.TagQueueResponse
import aws.sdk.kotlin.services.sqs.model.UntagQueueRequest
import aws.sdk.kotlin.services.sqs.model.UntagQueueResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "SQS"
public const val SdkVersion: String = "1.0.6"

/**
 * Welcome to the *Amazon SQS API Reference*.
 *
 * Amazon SQS is a reliable, highly-scalable hosted queue for storing messages as they travel between applications or microservices. Amazon SQS moves data between distributed application components and helps you decouple these components.
 *
 * For information on the permissions you need to use this API, see [Identity and access management](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-authentication-and-access-control.html) in the *Amazon SQS Developer Guide.*
 *
 * You can use [Amazon Web Services SDKs](http://aws.amazon.com/tools/#sdk) to access Amazon SQS using your favorite programming language. The SDKs perform tasks such as the following automatically:
 * + Cryptographically sign your service requests
 * + Retry requests
 * + Handle error responses
 *
 * **Additional information**
 * + [Amazon SQS Product Page](http://aws.amazon.com/sqs/)
 * + *Amazon SQS Developer Guide*
 *    + [Making API Requests](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-making-api-requests.html)
 *    + [Amazon SQS Message Attributes](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes)
 *    + [Amazon SQS Dead-Letter Queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html)
 * + *Command Line Interface*[Amazon SQS in the ](http://docs.aws.amazon.com/cli/latest/reference/sqs/index.html)
 * + *Amazon Web Services General Reference*
 *    + [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#sqs_region)
 */
public interface SqsClient : SdkClient {
    /**
     * SqsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SqsClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Sqs",
                "SQS",
                "sqs",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SqsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SqsClient = DefaultSqsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SqsEndpointProvider = builder.endpointProvider ?: DefaultSqsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: SqsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSqsAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "SQS"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SqsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SqsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds a permission to a queue for a specific [principal](https://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P). This allows sharing access to the queue.
     *
     * When you create a queue, you have full control access rights for the queue. Only you, the owner of the queue, can grant or deny permissions to the queue. For more information about these permissions, see [Allow Developers to Write Messages to a Shared Queue](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-writing-an-sqs-policy.html#write-messages-to-shared-queue) in the *Amazon SQS Developer Guide*.
     *
     * + `AddPermission` generates a policy for you. You can use ` <a>SetQueueAttributes</a> ` to upload your policy. For more information, see [Using Custom Policies with the Amazon SQS Access Policy Language](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-creating-custom-policies.html) in the *Amazon SQS Developer Guide*.
     * + An Amazon SQS policy can have a maximum of seven actions per statement.
     * + To remove the ability to change queue permissions, you must deny permission to the `AddPermission`, `RemovePermission`, and `SetQueueAttributes` actions in your IAM policy.
     * + Amazon SQS `AddPermission` does not support adding a non-account principal.
     * Cross-account permissions don't apply to this action. For more information, see [Grant cross-account permissions to a role and a username](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name) in the *Amazon SQS Developer Guide*.
     */
    public suspend fun addPermission(input: AddPermissionRequest): AddPermissionResponse

    /**
     * Cancels a specified message movement task. A message movement can only be cancelled when the current status is RUNNING. Cancelling a message movement task does not revert the messages that have already been moved. It can only stop the messages that have not been moved yet.
     *
     * + This action is currently limited to supporting message redrive from [dead-letter queues (DLQs)](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html) only. In this context, the source queue is the dead-letter queue (DLQ), while the destination queue can be the original source queue (from which the messages were driven to the dead-letter-queue), or a custom destination queue.
     * + Currently, only standard queues are supported.
     * + Only one active message movement task is supported per queue at any given time.
     */
    public suspend fun cancelMessageMoveTask(input: CancelMessageMoveTaskRequest): CancelMessageMoveTaskResponse

    /**
     * Changes the visibility timeout of a specified message in a queue to a new value. The default visibility timeout for a message is 30 seconds. The minimum is 0 seconds. The maximum is 12 hours. For more information, see [Visibility Timeout](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html) in the *Amazon SQS Developer Guide*.
     *
     * For example, if the default timeout for a queue is 60 seconds, 15 seconds have elapsed since you received the message, and you send a ChangeMessageVisibility call with `VisibilityTimeout` set to 10 seconds, the 10 seconds begin to count from the time that you make the `ChangeMessageVisibility` call. Thus, any attempt to change the visibility timeout or to delete that message 10 seconds after you initially change the visibility timeout (a total of 25 seconds) might result in an error.
     *
     * An Amazon SQS message has three basic states:
     * + Sent to a queue by a producer.
     * + Received from the queue by a consumer.
     * + Deleted from the queue.
     *
     * A message is considered to be *stored* after it is sent to a queue by a producer, but not yet received from the queue by a consumer (that is, between states 1 and 2). There is no limit to the number of stored messages. A message is considered to be *in flight* after it is received from a queue by a consumer, but not yet deleted from the queue (that is, between states 2 and 3). There is a limit to the number of in flight messages.
     *
     * Limits that apply to in flight messages are unrelated to the *unlimited* number of stored messages.
     *
     * For most standard queues (depending on queue traffic and message backlog), there can be a maximum of approximately 120,000 in flight messages (received from a queue by a consumer, but not yet deleted from the queue). If you reach this limit, Amazon SQS returns the `OverLimit` error message. To avoid reaching the limit, you should delete messages from the queue after they're processed. You can also increase the number of queues you use to process your messages. To request a limit increase, [file a support request](https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&limitType=service-code-sqs).
     *
     * For FIFO queues, there can be a maximum of 20,000 in flight messages (received from a queue by a consumer, but not yet deleted from the queue). If you reach this limit, Amazon SQS returns no error messages.
     *
     * If you attempt to set the `VisibilityTimeout` to a value greater than the maximum time left, Amazon SQS returns an error. Amazon SQS doesn't automatically recalculate and increase the timeout to the maximum remaining time.
     *
     * Unlike with a queue, when you change the visibility timeout for a specific message the timeout value is applied immediately but isn't saved in memory for that message. If you don't delete a message after it is received, the visibility timeout for the message reverts to the original timeout value (not to the value you set using the `ChangeMessageVisibility` action) the next time the message is received.
     */
    public suspend fun changeMessageVisibility(input: ChangeMessageVisibilityRequest): ChangeMessageVisibilityResponse

    /**
     * Changes the visibility timeout of multiple messages. This is a batch version of ` <a>ChangeMessageVisibility</a>.` The result of the action on each message is reported individually in the response. You can send up to 10 ` <a>ChangeMessageVisibility</a> ` requests with each `ChangeMessageVisibilityBatch` action.
     *
     * Because the batch request can result in a combination of successful and unsuccessful actions, you should check for batch errors even when the call returns an HTTP status code of `200`.
     */
    public suspend fun changeMessageVisibilityBatch(input: ChangeMessageVisibilityBatchRequest): ChangeMessageVisibilityBatchResponse

    /**
     * Creates a new standard or FIFO queue. You can pass one or more attributes in the request. Keep the following in mind:
     * + If you don't specify the `FifoQueue` attribute, Amazon SQS creates a standard queue.You can't change the queue type after you create it and you can't convert an existing standard queue into a FIFO queue. You must either create a new FIFO queue for your application or delete your existing standard queue and recreate it as a FIFO queue. For more information, see [Moving From a Standard Queue to a FIFO Queue](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-moving) in the *Amazon SQS Developer Guide*.
     * + If you don't provide a value for an attribute, the queue is created with the default value for the attribute.
     * + If you delete a queue, you must wait at least 60 seconds before creating a queue with the same name.
     *
     * To successfully create a new queue, you must provide a queue name that adheres to the [limits related to queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/limits-queues.html) and is unique within the scope of your queues.
     *
     * After you create a queue, you must wait at least one second after the queue is created to be able to use the queue.
     *
     * To get the queue URL, use the ` <a>GetQueueUrl</a> ` action. ` <a>GetQueueUrl</a> ` requires only the `QueueName` parameter. be aware of existing queue names:
     * + If you provide the name of an existing queue along with the exact names and values of all the queue's attributes, `CreateQueue` returns the queue URL for the existing queue.
     * + If the queue name, attribute names, or attribute values don't match an existing queue, `CreateQueue` returns an error.
     *
     * Cross-account permissions don't apply to this action. For more information, see [Grant cross-account permissions to a role and a username](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name) in the *Amazon SQS Developer Guide*.
     */
    public suspend fun createQueue(input: CreateQueueRequest): CreateQueueResponse

    /**
     * Deletes the specified message from the specified queue. To select the message to delete, use the `ReceiptHandle` of the message (*not* the `MessageId` which you receive when you send the message). Amazon SQS can delete a message from a queue even if a visibility timeout setting causes the message to be locked by another consumer. Amazon SQS automatically deletes messages left in a queue longer than the retention period configured for the queue.
     *
     * The `ReceiptHandle` is associated with a *specific instance* of receiving a message. If you receive a message more than once, the `ReceiptHandle` is different each time you receive a message. When you use the `DeleteMessage` action, you must provide the most recently received `ReceiptHandle` for the message (otherwise, the request succeeds, but the message will not be deleted).
     *
     * For standard queues, it is possible to receive a message even after you delete it. This might happen on rare occasions if one of the servers which stores a copy of the message is unavailable when you send the request to delete the message. The copy remains on the server and might be returned to you during a subsequent receive request. You should ensure that your application is idempotent, so that receiving a message more than once does not cause issues.
     */
    public suspend fun deleteMessage(input: DeleteMessageRequest): DeleteMessageResponse

    /**
     * Deletes up to ten messages from the specified queue. This is a batch version of ` <a>DeleteMessage</a>.` The result of the action on each message is reported individually in the response.
     *
     * Because the batch request can result in a combination of successful and unsuccessful actions, you should check for batch errors even when the call returns an HTTP status code of `200`.
     */
    public suspend fun deleteMessageBatch(input: DeleteMessageBatchRequest): DeleteMessageBatchResponse

    /**
     * Deletes the queue specified by the `QueueUrl`, regardless of the queue's contents.
     *
     * Be careful with the `DeleteQueue` action: When you delete a queue, any messages in the queue are no longer available.
     *
     * When you delete a queue, the deletion process takes up to 60 seconds. Requests you send involving that queue during the 60 seconds might succeed. For example, a ` <a>SendMessage</a> ` request might succeed, but after 60 seconds the queue and the message you sent no longer exist.
     *
     * When you delete a queue, you must wait at least 60 seconds before creating a queue with the same name.
     *
     * Cross-account permissions don't apply to this action. For more information, see [Grant cross-account permissions to a role and a username](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name) in the *Amazon SQS Developer Guide*.
     *
     * The delete operation uses the HTTP `GET` verb.
     */
    public suspend fun deleteQueue(input: DeleteQueueRequest): DeleteQueueResponse

    /**
     * Gets attributes for the specified queue.
     *
     * To determine whether a queue is [FIFO](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html), you can check whether `QueueName` ends with the `.fifo` suffix.
     */
    public suspend fun getQueueAttributes(input: GetQueueAttributesRequest): GetQueueAttributesResponse

    /**
     * Returns the URL of an existing Amazon SQS queue.
     *
     * To access a queue that belongs to another AWS account, use the `QueueOwnerAWSAccountId` parameter to specify the account ID of the queue's owner. The queue's owner must grant you permission to access the queue. For more information about shared queue access, see ` <a>AddPermission</a> ` or see [Allow Developers to Write Messages to a Shared Queue](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-writing-an-sqs-policy.html#write-messages-to-shared-queue) in the *Amazon SQS Developer Guide*.
     */
    public suspend fun getQueueUrl(input: GetQueueUrlRequest): GetQueueUrlResponse

    /**
     * Returns a list of your queues that have the `RedrivePolicy` queue attribute configured with a dead-letter queue.
     *
     *  The `ListDeadLetterSourceQueues` methods supports pagination. Set parameter `MaxResults` in the request to specify the maximum number of results to be returned in the response. If you do not set `MaxResults`, the response includes a maximum of 1,000 results. If you set `MaxResults` and there are additional results to display, the response includes a value for `NextToken`. Use `NextToken` as a parameter in your next request to `ListDeadLetterSourceQueues` to receive the next page of results.
     *
     * For more information about using dead-letter queues, see [Using Amazon SQS Dead-Letter Queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html) in the *Amazon SQS Developer Guide*.
     */
    public suspend fun listDeadLetterSourceQueues(input: ListDeadLetterSourceQueuesRequest): ListDeadLetterSourceQueuesResponse

    /**
     * Gets the most recent message movement tasks (up to 10) under a specific source queue.
     *
     * + This action is currently limited to supporting message redrive from [dead-letter queues (DLQs)](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html) only. In this context, the source queue is the dead-letter queue (DLQ), while the destination queue can be the original source queue (from which the messages were driven to the dead-letter-queue), or a custom destination queue.
     * + Currently, only standard queues are supported.
     * + Only one active message movement task is supported per queue at any given time.
     */
    public suspend fun listMessageMoveTasks(input: ListMessageMoveTasksRequest): ListMessageMoveTasksResponse

    /**
     * List all cost allocation tags added to the specified Amazon SQS queue. For an overview, see [Tagging Your Amazon SQS Queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html) in the *Amazon SQS Developer Guide*.
     *
     * Cross-account permissions don't apply to this action. For more information, see [Grant cross-account permissions to a role and a username](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name) in the *Amazon SQS Developer Guide*.
     */
    public suspend fun listQueueTags(input: ListQueueTagsRequest): ListQueueTagsResponse

    /**
     * Returns a list of your queues in the current region. The response includes a maximum of 1,000 results. If you specify a value for the optional `QueueNamePrefix` parameter, only queues with a name that begins with the specified value are returned.
     *
     *  The `listQueues` methods supports pagination. Set parameter `MaxResults` in the request to specify the maximum number of results to be returned in the response. If you do not set `MaxResults`, the response includes a maximum of 1,000 results. If you set `MaxResults` and there are additional results to display, the response includes a value for `NextToken`. Use `NextToken` as a parameter in your next request to `listQueues` to receive the next page of results.
     *
     * Cross-account permissions don't apply to this action. For more information, see [Grant cross-account permissions to a role and a username](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name) in the *Amazon SQS Developer Guide*.
     */
    public suspend fun listQueues(input: ListQueuesRequest = ListQueuesRequest { }): ListQueuesResponse

    /**
     * Deletes available messages in a queue (including in-flight messages) specified by the `QueueURL` parameter.
     *
     * When you use the `PurgeQueue` action, you can't retrieve any messages deleted from a queue.
     *
     * The message deletion process takes up to 60 seconds. We recommend waiting for 60 seconds regardless of your queue's size.
     *
     * Messages sent to the queue *before* you call `PurgeQueue` might be received but are deleted within the next minute.
     *
     * Messages sent to the queue *after* you call `PurgeQueue` might be deleted while the queue is being purged.
     */
    public suspend fun purgeQueue(input: PurgeQueueRequest): PurgeQueueResponse

    /**
     * Retrieves one or more messages (up to 10), from the specified queue. Using the `WaitTimeSeconds` parameter enables long-poll support. For more information, see [Amazon SQS Long Polling](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-long-polling.html) in the *Amazon SQS Developer Guide*.
     *
     * Short poll is the default behavior where a weighted random set of machines is sampled on a `ReceiveMessage` call. Thus, only the messages on the sampled machines are returned. If the number of messages in the queue is small (fewer than 1,000), you most likely get fewer messages than you requested per `ReceiveMessage` call. If the number of messages in the queue is extremely small, you might not receive any messages in a particular `ReceiveMessage` response. If this happens, repeat the request.
     *
     * For each message returned, the response includes the following:
     * + The message body.
     * + An MD5 digest of the message body. For information about MD5, see [RFC1321](https://www.ietf.org/rfc/rfc1321.txt).
     * + The `MessageId` you received when you sent the message to the queue.
     * + The receipt handle.
     * + The message attributes.
     * + An MD5 digest of the message attributes.
     *
     * The receipt handle is the identifier you must provide when deleting the message. For more information, see [Queue and Message Identifiers](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-message-identifiers.html) in the *Amazon SQS Developer Guide*.
     *
     * You can provide the `VisibilityTimeout` parameter in your request. The parameter is applied to the messages that Amazon SQS returns in the response. If you don't include the parameter, the overall visibility timeout for the queue is used for the returned messages. For more information, see [Visibility Timeout](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html) in the *Amazon SQS Developer Guide*.
     *
     * A message that isn't deleted or a message whose visibility isn't extended before the visibility timeout expires counts as a failed receive. Depending on the configuration of the queue, the message might be sent to the dead-letter queue.
     *
     * In the future, new attributes might be added. If you write code that calls this action, we recommend that you structure your code so that it can handle new attributes gracefully.
     */
    public suspend fun receiveMessage(input: ReceiveMessageRequest): ReceiveMessageResponse

    /**
     * Revokes any permissions in the queue policy that matches the specified `Label` parameter.
     *
     * + Only the owner of a queue can remove permissions from it.
     * + Cross-account permissions don't apply to this action. For more information, see [Grant cross-account permissions to a role and a username](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name) in the *Amazon SQS Developer Guide*.
     * + To remove the ability to change queue permissions, you must deny permission to the `AddPermission`, `RemovePermission`, and `SetQueueAttributes` actions in your IAM policy.
     */
    public suspend fun removePermission(input: RemovePermissionRequest): RemovePermissionResponse

    /**
     * Delivers a message to the specified queue.
     *
     * A message can include only XML, JSON, and unformatted text. The following Unicode characters are allowed:
     *
     * `#x9` | `#xA` | `#xD` | `#x20` to `#xD7FF` | `#xE000` to `#xFFFD` | `#x10000` to `#x10FFFF`
     *
     * Any characters not included in this list will be rejected. For more information, see the [W3C specification for characters](http://www.w3.org/TR/REC-xml/#charsets).
     */
    public suspend fun sendMessage(input: SendMessageRequest): SendMessageResponse

    /**
     * You can use `SendMessageBatch` to send up to 10 messages to the specified queue by assigning either identical or different values to each message (or by not assigning values at all). This is a batch version of ` <a>SendMessage</a>.` For a FIFO queue, multiple messages within a single batch are enqueued in the order they are sent.
     *
     * The result of sending each message is reported individually in the response. Because the batch request can result in a combination of successful and unsuccessful actions, you should check for batch errors even when the call returns an HTTP status code of `200`.
     *
     * The maximum allowed individual message size and the maximum total payload size (the sum of the individual lengths of all of the batched messages) are both 256 KiB (262,144 bytes).
     *
     * A message can include only XML, JSON, and unformatted text. The following Unicode characters are allowed:
     *
     * `#x9` | `#xA` | `#xD` | `#x20` to `#xD7FF` | `#xE000` to `#xFFFD` | `#x10000` to `#x10FFFF`
     *
     * Any characters not included in this list will be rejected. For more information, see the [W3C specification for characters](http://www.w3.org/TR/REC-xml/#charsets).
     *
     * If you don't specify the `DelaySeconds` parameter for an entry, Amazon SQS uses the default value for the queue.
     */
    public suspend fun sendMessageBatch(input: SendMessageBatchRequest): SendMessageBatchResponse

    /**
     * Sets the value of one or more queue attributes. When you change a queue's attributes, the change can take up to 60 seconds for most of the attributes to propagate throughout the Amazon SQS system. Changes made to the `MessageRetentionPeriod` attribute can take up to 15 minutes and will impact existing messages in the queue potentially causing them to be expired and deleted if the `MessageRetentionPeriod` is reduced below the age of existing messages.
     *
     * + In the future, new attributes might be added. If you write code that calls this action, we recommend that you structure your code so that it can handle new attributes gracefully.
     * + Cross-account permissions don't apply to this action. For more information, see [Grant cross-account permissions to a role and a username](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name) in the *Amazon SQS Developer Guide*.
     * + To remove the ability to change queue permissions, you must deny permission to the `AddPermission`, `RemovePermission`, and `SetQueueAttributes` actions in your IAM policy.
     */
    public suspend fun setQueueAttributes(input: SetQueueAttributesRequest): SetQueueAttributesResponse

    /**
     * Starts an asynchronous task to move messages from a specified source queue to a specified destination queue.
     *
     * + This action is currently limited to supporting message redrive from queues that are configured as [dead-letter queues (DLQs)](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html) of other Amazon SQS queues only. Non-SQS queue sources of dead-letter queues, such as Lambda or Amazon SNS topics, are currently not supported.
     * + In dead-letter queues redrive context, the `StartMessageMoveTask` the source queue is the DLQ, while the destination queue can be the original source queue (from which the messages were driven to the dead-letter-queue), or a custom destination queue.
     * + Currently, only standard queues support redrive. FIFO queues don't support redrive.
     * + Only one active message movement task is supported per queue at any given time.
     */
    public suspend fun startMessageMoveTask(input: StartMessageMoveTaskRequest): StartMessageMoveTaskResponse

    /**
     * Add cost allocation tags to the specified Amazon SQS queue. For an overview, see [Tagging Your Amazon SQS Queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html) in the *Amazon SQS Developer Guide*.
     *
     * When you use queue tags, keep the following guidelines in mind:
     * + Adding more than 50 tags to a queue isn't recommended.
     * + Tags don't have any semantic meaning. Amazon SQS interprets tags as character strings.
     * + Tags are case-sensitive.
     * + A new tag with a key identical to that of an existing tag overwrites the existing tag.
     *
     * For a full list of tag restrictions, see [Quotas related to queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-limits.html#limits-queues) in the *Amazon SQS Developer Guide*.
     *
     * Cross-account permissions don't apply to this action. For more information, see [Grant cross-account permissions to a role and a username](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name) in the *Amazon SQS Developer Guide*.
     */
    public suspend fun tagQueue(input: TagQueueRequest): TagQueueResponse

    /**
     * Remove cost allocation tags from the specified Amazon SQS queue. For an overview, see [Tagging Your Amazon SQS Queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html) in the *Amazon SQS Developer Guide*.
     *
     * Cross-account permissions don't apply to this action. For more information, see [Grant cross-account permissions to a role and a username](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name) in the *Amazon SQS Developer Guide*.
     */
    public suspend fun untagQueue(input: UntagQueueRequest): UntagQueueResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SqsClient.withConfig(block: SqsClient.Config.Builder.() -> Unit): SqsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSqsClient(newConfig)
}

/**
 * Adds a permission to a queue for a specific [principal](https://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P). This allows sharing access to the queue.
 *
 * When you create a queue, you have full control access rights for the queue. Only you, the owner of the queue, can grant or deny permissions to the queue. For more information about these permissions, see [Allow Developers to Write Messages to a Shared Queue](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-writing-an-sqs-policy.html#write-messages-to-shared-queue) in the *Amazon SQS Developer Guide*.
 *
 * + `AddPermission` generates a policy for you. You can use ` <a>SetQueueAttributes</a> ` to upload your policy. For more information, see [Using Custom Policies with the Amazon SQS Access Policy Language](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-creating-custom-policies.html) in the *Amazon SQS Developer Guide*.
 * + An Amazon SQS policy can have a maximum of seven actions per statement.
 * + To remove the ability to change queue permissions, you must deny permission to the `AddPermission`, `RemovePermission`, and `SetQueueAttributes` actions in your IAM policy.
 * + Amazon SQS `AddPermission` does not support adding a non-account principal.
 * Cross-account permissions don't apply to this action. For more information, see [Grant cross-account permissions to a role and a username](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name) in the *Amazon SQS Developer Guide*.
 */
public suspend inline fun SqsClient.addPermission(crossinline block: AddPermissionRequest.Builder.() -> Unit): AddPermissionResponse = addPermission(AddPermissionRequest.Builder().apply(block).build())

/**
 * Cancels a specified message movement task. A message movement can only be cancelled when the current status is RUNNING. Cancelling a message movement task does not revert the messages that have already been moved. It can only stop the messages that have not been moved yet.
 *
 * + This action is currently limited to supporting message redrive from [dead-letter queues (DLQs)](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html) only. In this context, the source queue is the dead-letter queue (DLQ), while the destination queue can be the original source queue (from which the messages were driven to the dead-letter-queue), or a custom destination queue.
 * + Currently, only standard queues are supported.
 * + Only one active message movement task is supported per queue at any given time.
 */
public suspend inline fun SqsClient.cancelMessageMoveTask(crossinline block: CancelMessageMoveTaskRequest.Builder.() -> Unit): CancelMessageMoveTaskResponse = cancelMessageMoveTask(CancelMessageMoveTaskRequest.Builder().apply(block).build())

/**
 * Changes the visibility timeout of a specified message in a queue to a new value. The default visibility timeout for a message is 30 seconds. The minimum is 0 seconds. The maximum is 12 hours. For more information, see [Visibility Timeout](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html) in the *Amazon SQS Developer Guide*.
 *
 * For example, if the default timeout for a queue is 60 seconds, 15 seconds have elapsed since you received the message, and you send a ChangeMessageVisibility call with `VisibilityTimeout` set to 10 seconds, the 10 seconds begin to count from the time that you make the `ChangeMessageVisibility` call. Thus, any attempt to change the visibility timeout or to delete that message 10 seconds after you initially change the visibility timeout (a total of 25 seconds) might result in an error.
 *
 * An Amazon SQS message has three basic states:
 * + Sent to a queue by a producer.
 * + Received from the queue by a consumer.
 * + Deleted from the queue.
 *
 * A message is considered to be *stored* after it is sent to a queue by a producer, but not yet received from the queue by a consumer (that is, between states 1 and 2). There is no limit to the number of stored messages. A message is considered to be *in flight* after it is received from a queue by a consumer, but not yet deleted from the queue (that is, between states 2 and 3). There is a limit to the number of in flight messages.
 *
 * Limits that apply to in flight messages are unrelated to the *unlimited* number of stored messages.
 *
 * For most standard queues (depending on queue traffic and message backlog), there can be a maximum of approximately 120,000 in flight messages (received from a queue by a consumer, but not yet deleted from the queue). If you reach this limit, Amazon SQS returns the `OverLimit` error message. To avoid reaching the limit, you should delete messages from the queue after they're processed. You can also increase the number of queues you use to process your messages. To request a limit increase, [file a support request](https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&limitType=service-code-sqs).
 *
 * For FIFO queues, there can be a maximum of 20,000 in flight messages (received from a queue by a consumer, but not yet deleted from the queue). If you reach this limit, Amazon SQS returns no error messages.
 *
 * If you attempt to set the `VisibilityTimeout` to a value greater than the maximum time left, Amazon SQS returns an error. Amazon SQS doesn't automatically recalculate and increase the timeout to the maximum remaining time.
 *
 * Unlike with a queue, when you change the visibility timeout for a specific message the timeout value is applied immediately but isn't saved in memory for that message. If you don't delete a message after it is received, the visibility timeout for the message reverts to the original timeout value (not to the value you set using the `ChangeMessageVisibility` action) the next time the message is received.
 */
public suspend inline fun SqsClient.changeMessageVisibility(crossinline block: ChangeMessageVisibilityRequest.Builder.() -> Unit): ChangeMessageVisibilityResponse = changeMessageVisibility(ChangeMessageVisibilityRequest.Builder().apply(block).build())

/**
 * Changes the visibility timeout of multiple messages. This is a batch version of ` <a>ChangeMessageVisibility</a>.` The result of the action on each message is reported individually in the response. You can send up to 10 ` <a>ChangeMessageVisibility</a> ` requests with each `ChangeMessageVisibilityBatch` action.
 *
 * Because the batch request can result in a combination of successful and unsuccessful actions, you should check for batch errors even when the call returns an HTTP status code of `200`.
 */
public suspend inline fun SqsClient.changeMessageVisibilityBatch(crossinline block: ChangeMessageVisibilityBatchRequest.Builder.() -> Unit): ChangeMessageVisibilityBatchResponse = changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest.Builder().apply(block).build())

/**
 * Creates a new standard or FIFO queue. You can pass one or more attributes in the request. Keep the following in mind:
 * + If you don't specify the `FifoQueue` attribute, Amazon SQS creates a standard queue.You can't change the queue type after you create it and you can't convert an existing standard queue into a FIFO queue. You must either create a new FIFO queue for your application or delete your existing standard queue and recreate it as a FIFO queue. For more information, see [Moving From a Standard Queue to a FIFO Queue](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-moving) in the *Amazon SQS Developer Guide*.
 * + If you don't provide a value for an attribute, the queue is created with the default value for the attribute.
 * + If you delete a queue, you must wait at least 60 seconds before creating a queue with the same name.
 *
 * To successfully create a new queue, you must provide a queue name that adheres to the [limits related to queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/limits-queues.html) and is unique within the scope of your queues.
 *
 * After you create a queue, you must wait at least one second after the queue is created to be able to use the queue.
 *
 * To get the queue URL, use the ` <a>GetQueueUrl</a> ` action. ` <a>GetQueueUrl</a> ` requires only the `QueueName` parameter. be aware of existing queue names:
 * + If you provide the name of an existing queue along with the exact names and values of all the queue's attributes, `CreateQueue` returns the queue URL for the existing queue.
 * + If the queue name, attribute names, or attribute values don't match an existing queue, `CreateQueue` returns an error.
 *
 * Cross-account permissions don't apply to this action. For more information, see [Grant cross-account permissions to a role and a username](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name) in the *Amazon SQS Developer Guide*.
 */
public suspend inline fun SqsClient.createQueue(crossinline block: CreateQueueRequest.Builder.() -> Unit): CreateQueueResponse = createQueue(CreateQueueRequest.Builder().apply(block).build())

/**
 * Deletes the specified message from the specified queue. To select the message to delete, use the `ReceiptHandle` of the message (*not* the `MessageId` which you receive when you send the message). Amazon SQS can delete a message from a queue even if a visibility timeout setting causes the message to be locked by another consumer. Amazon SQS automatically deletes messages left in a queue longer than the retention period configured for the queue.
 *
 * The `ReceiptHandle` is associated with a *specific instance* of receiving a message. If you receive a message more than once, the `ReceiptHandle` is different each time you receive a message. When you use the `DeleteMessage` action, you must provide the most recently received `ReceiptHandle` for the message (otherwise, the request succeeds, but the message will not be deleted).
 *
 * For standard queues, it is possible to receive a message even after you delete it. This might happen on rare occasions if one of the servers which stores a copy of the message is unavailable when you send the request to delete the message. The copy remains on the server and might be returned to you during a subsequent receive request. You should ensure that your application is idempotent, so that receiving a message more than once does not cause issues.
 */
public suspend inline fun SqsClient.deleteMessage(crossinline block: DeleteMessageRequest.Builder.() -> Unit): DeleteMessageResponse = deleteMessage(DeleteMessageRequest.Builder().apply(block).build())

/**
 * Deletes up to ten messages from the specified queue. This is a batch version of ` <a>DeleteMessage</a>.` The result of the action on each message is reported individually in the response.
 *
 * Because the batch request can result in a combination of successful and unsuccessful actions, you should check for batch errors even when the call returns an HTTP status code of `200`.
 */
public suspend inline fun SqsClient.deleteMessageBatch(crossinline block: DeleteMessageBatchRequest.Builder.() -> Unit): DeleteMessageBatchResponse = deleteMessageBatch(DeleteMessageBatchRequest.Builder().apply(block).build())

/**
 * Deletes the queue specified by the `QueueUrl`, regardless of the queue's contents.
 *
 * Be careful with the `DeleteQueue` action: When you delete a queue, any messages in the queue are no longer available.
 *
 * When you delete a queue, the deletion process takes up to 60 seconds. Requests you send involving that queue during the 60 seconds might succeed. For example, a ` <a>SendMessage</a> ` request might succeed, but after 60 seconds the queue and the message you sent no longer exist.
 *
 * When you delete a queue, you must wait at least 60 seconds before creating a queue with the same name.
 *
 * Cross-account permissions don't apply to this action. For more information, see [Grant cross-account permissions to a role and a username](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name) in the *Amazon SQS Developer Guide*.
 *
 * The delete operation uses the HTTP `GET` verb.
 */
public suspend inline fun SqsClient.deleteQueue(crossinline block: DeleteQueueRequest.Builder.() -> Unit): DeleteQueueResponse = deleteQueue(DeleteQueueRequest.Builder().apply(block).build())

/**
 * Gets attributes for the specified queue.
 *
 * To determine whether a queue is [FIFO](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html), you can check whether `QueueName` ends with the `.fifo` suffix.
 */
public suspend inline fun SqsClient.getQueueAttributes(crossinline block: GetQueueAttributesRequest.Builder.() -> Unit): GetQueueAttributesResponse = getQueueAttributes(GetQueueAttributesRequest.Builder().apply(block).build())

/**
 * Returns the URL of an existing Amazon SQS queue.
 *
 * To access a queue that belongs to another AWS account, use the `QueueOwnerAWSAccountId` parameter to specify the account ID of the queue's owner. The queue's owner must grant you permission to access the queue. For more information about shared queue access, see ` <a>AddPermission</a> ` or see [Allow Developers to Write Messages to a Shared Queue](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-writing-an-sqs-policy.html#write-messages-to-shared-queue) in the *Amazon SQS Developer Guide*.
 */
public suspend inline fun SqsClient.getQueueUrl(crossinline block: GetQueueUrlRequest.Builder.() -> Unit): GetQueueUrlResponse = getQueueUrl(GetQueueUrlRequest.Builder().apply(block).build())

/**
 * Returns a list of your queues that have the `RedrivePolicy` queue attribute configured with a dead-letter queue.
 *
 *  The `ListDeadLetterSourceQueues` methods supports pagination. Set parameter `MaxResults` in the request to specify the maximum number of results to be returned in the response. If you do not set `MaxResults`, the response includes a maximum of 1,000 results. If you set `MaxResults` and there are additional results to display, the response includes a value for `NextToken`. Use `NextToken` as a parameter in your next request to `ListDeadLetterSourceQueues` to receive the next page of results.
 *
 * For more information about using dead-letter queues, see [Using Amazon SQS Dead-Letter Queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html) in the *Amazon SQS Developer Guide*.
 */
public suspend inline fun SqsClient.listDeadLetterSourceQueues(crossinline block: ListDeadLetterSourceQueuesRequest.Builder.() -> Unit): ListDeadLetterSourceQueuesResponse = listDeadLetterSourceQueues(ListDeadLetterSourceQueuesRequest.Builder().apply(block).build())

/**
 * Gets the most recent message movement tasks (up to 10) under a specific source queue.
 *
 * + This action is currently limited to supporting message redrive from [dead-letter queues (DLQs)](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html) only. In this context, the source queue is the dead-letter queue (DLQ), while the destination queue can be the original source queue (from which the messages were driven to the dead-letter-queue), or a custom destination queue.
 * + Currently, only standard queues are supported.
 * + Only one active message movement task is supported per queue at any given time.
 */
public suspend inline fun SqsClient.listMessageMoveTasks(crossinline block: ListMessageMoveTasksRequest.Builder.() -> Unit): ListMessageMoveTasksResponse = listMessageMoveTasks(ListMessageMoveTasksRequest.Builder().apply(block).build())

/**
 * List all cost allocation tags added to the specified Amazon SQS queue. For an overview, see [Tagging Your Amazon SQS Queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html) in the *Amazon SQS Developer Guide*.
 *
 * Cross-account permissions don't apply to this action. For more information, see [Grant cross-account permissions to a role and a username](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name) in the *Amazon SQS Developer Guide*.
 */
public suspend inline fun SqsClient.listQueueTags(crossinline block: ListQueueTagsRequest.Builder.() -> Unit): ListQueueTagsResponse = listQueueTags(ListQueueTagsRequest.Builder().apply(block).build())

/**
 * Returns a list of your queues in the current region. The response includes a maximum of 1,000 results. If you specify a value for the optional `QueueNamePrefix` parameter, only queues with a name that begins with the specified value are returned.
 *
 *  The `listQueues` methods supports pagination. Set parameter `MaxResults` in the request to specify the maximum number of results to be returned in the response. If you do not set `MaxResults`, the response includes a maximum of 1,000 results. If you set `MaxResults` and there are additional results to display, the response includes a value for `NextToken`. Use `NextToken` as a parameter in your next request to `listQueues` to receive the next page of results.
 *
 * Cross-account permissions don't apply to this action. For more information, see [Grant cross-account permissions to a role and a username](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name) in the *Amazon SQS Developer Guide*.
 */
public suspend inline fun SqsClient.listQueues(crossinline block: ListQueuesRequest.Builder.() -> Unit): ListQueuesResponse = listQueues(ListQueuesRequest.Builder().apply(block).build())

/**
 * Deletes available messages in a queue (including in-flight messages) specified by the `QueueURL` parameter.
 *
 * When you use the `PurgeQueue` action, you can't retrieve any messages deleted from a queue.
 *
 * The message deletion process takes up to 60 seconds. We recommend waiting for 60 seconds regardless of your queue's size.
 *
 * Messages sent to the queue *before* you call `PurgeQueue` might be received but are deleted within the next minute.
 *
 * Messages sent to the queue *after* you call `PurgeQueue` might be deleted while the queue is being purged.
 */
public suspend inline fun SqsClient.purgeQueue(crossinline block: PurgeQueueRequest.Builder.() -> Unit): PurgeQueueResponse = purgeQueue(PurgeQueueRequest.Builder().apply(block).build())

/**
 * Retrieves one or more messages (up to 10), from the specified queue. Using the `WaitTimeSeconds` parameter enables long-poll support. For more information, see [Amazon SQS Long Polling](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-long-polling.html) in the *Amazon SQS Developer Guide*.
 *
 * Short poll is the default behavior where a weighted random set of machines is sampled on a `ReceiveMessage` call. Thus, only the messages on the sampled machines are returned. If the number of messages in the queue is small (fewer than 1,000), you most likely get fewer messages than you requested per `ReceiveMessage` call. If the number of messages in the queue is extremely small, you might not receive any messages in a particular `ReceiveMessage` response. If this happens, repeat the request.
 *
 * For each message returned, the response includes the following:
 * + The message body.
 * + An MD5 digest of the message body. For information about MD5, see [RFC1321](https://www.ietf.org/rfc/rfc1321.txt).
 * + The `MessageId` you received when you sent the message to the queue.
 * + The receipt handle.
 * + The message attributes.
 * + An MD5 digest of the message attributes.
 *
 * The receipt handle is the identifier you must provide when deleting the message. For more information, see [Queue and Message Identifiers](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-message-identifiers.html) in the *Amazon SQS Developer Guide*.
 *
 * You can provide the `VisibilityTimeout` parameter in your request. The parameter is applied to the messages that Amazon SQS returns in the response. If you don't include the parameter, the overall visibility timeout for the queue is used for the returned messages. For more information, see [Visibility Timeout](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html) in the *Amazon SQS Developer Guide*.
 *
 * A message that isn't deleted or a message whose visibility isn't extended before the visibility timeout expires counts as a failed receive. Depending on the configuration of the queue, the message might be sent to the dead-letter queue.
 *
 * In the future, new attributes might be added. If you write code that calls this action, we recommend that you structure your code so that it can handle new attributes gracefully.
 */
public suspend inline fun SqsClient.receiveMessage(crossinline block: ReceiveMessageRequest.Builder.() -> Unit): ReceiveMessageResponse = receiveMessage(ReceiveMessageRequest.Builder().apply(block).build())

/**
 * Revokes any permissions in the queue policy that matches the specified `Label` parameter.
 *
 * + Only the owner of a queue can remove permissions from it.
 * + Cross-account permissions don't apply to this action. For more information, see [Grant cross-account permissions to a role and a username](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name) in the *Amazon SQS Developer Guide*.
 * + To remove the ability to change queue permissions, you must deny permission to the `AddPermission`, `RemovePermission`, and `SetQueueAttributes` actions in your IAM policy.
 */
public suspend inline fun SqsClient.removePermission(crossinline block: RemovePermissionRequest.Builder.() -> Unit): RemovePermissionResponse = removePermission(RemovePermissionRequest.Builder().apply(block).build())

/**
 * Delivers a message to the specified queue.
 *
 * A message can include only XML, JSON, and unformatted text. The following Unicode characters are allowed:
 *
 * `#x9` | `#xA` | `#xD` | `#x20` to `#xD7FF` | `#xE000` to `#xFFFD` | `#x10000` to `#x10FFFF`
 *
 * Any characters not included in this list will be rejected. For more information, see the [W3C specification for characters](http://www.w3.org/TR/REC-xml/#charsets).
 */
public suspend inline fun SqsClient.sendMessage(crossinline block: SendMessageRequest.Builder.() -> Unit): SendMessageResponse = sendMessage(SendMessageRequest.Builder().apply(block).build())

/**
 * You can use `SendMessageBatch` to send up to 10 messages to the specified queue by assigning either identical or different values to each message (or by not assigning values at all). This is a batch version of ` <a>SendMessage</a>.` For a FIFO queue, multiple messages within a single batch are enqueued in the order they are sent.
 *
 * The result of sending each message is reported individually in the response. Because the batch request can result in a combination of successful and unsuccessful actions, you should check for batch errors even when the call returns an HTTP status code of `200`.
 *
 * The maximum allowed individual message size and the maximum total payload size (the sum of the individual lengths of all of the batched messages) are both 256 KiB (262,144 bytes).
 *
 * A message can include only XML, JSON, and unformatted text. The following Unicode characters are allowed:
 *
 * `#x9` | `#xA` | `#xD` | `#x20` to `#xD7FF` | `#xE000` to `#xFFFD` | `#x10000` to `#x10FFFF`
 *
 * Any characters not included in this list will be rejected. For more information, see the [W3C specification for characters](http://www.w3.org/TR/REC-xml/#charsets).
 *
 * If you don't specify the `DelaySeconds` parameter for an entry, Amazon SQS uses the default value for the queue.
 */
public suspend inline fun SqsClient.sendMessageBatch(crossinline block: SendMessageBatchRequest.Builder.() -> Unit): SendMessageBatchResponse = sendMessageBatch(SendMessageBatchRequest.Builder().apply(block).build())

/**
 * Sets the value of one or more queue attributes. When you change a queue's attributes, the change can take up to 60 seconds for most of the attributes to propagate throughout the Amazon SQS system. Changes made to the `MessageRetentionPeriod` attribute can take up to 15 minutes and will impact existing messages in the queue potentially causing them to be expired and deleted if the `MessageRetentionPeriod` is reduced below the age of existing messages.
 *
 * + In the future, new attributes might be added. If you write code that calls this action, we recommend that you structure your code so that it can handle new attributes gracefully.
 * + Cross-account permissions don't apply to this action. For more information, see [Grant cross-account permissions to a role and a username](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name) in the *Amazon SQS Developer Guide*.
 * + To remove the ability to change queue permissions, you must deny permission to the `AddPermission`, `RemovePermission`, and `SetQueueAttributes` actions in your IAM policy.
 */
public suspend inline fun SqsClient.setQueueAttributes(crossinline block: SetQueueAttributesRequest.Builder.() -> Unit): SetQueueAttributesResponse = setQueueAttributes(SetQueueAttributesRequest.Builder().apply(block).build())

/**
 * Starts an asynchronous task to move messages from a specified source queue to a specified destination queue.
 *
 * + This action is currently limited to supporting message redrive from queues that are configured as [dead-letter queues (DLQs)](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html) of other Amazon SQS queues only. Non-SQS queue sources of dead-letter queues, such as Lambda or Amazon SNS topics, are currently not supported.
 * + In dead-letter queues redrive context, the `StartMessageMoveTask` the source queue is the DLQ, while the destination queue can be the original source queue (from which the messages were driven to the dead-letter-queue), or a custom destination queue.
 * + Currently, only standard queues support redrive. FIFO queues don't support redrive.
 * + Only one active message movement task is supported per queue at any given time.
 */
public suspend inline fun SqsClient.startMessageMoveTask(crossinline block: StartMessageMoveTaskRequest.Builder.() -> Unit): StartMessageMoveTaskResponse = startMessageMoveTask(StartMessageMoveTaskRequest.Builder().apply(block).build())

/**
 * Add cost allocation tags to the specified Amazon SQS queue. For an overview, see [Tagging Your Amazon SQS Queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html) in the *Amazon SQS Developer Guide*.
 *
 * When you use queue tags, keep the following guidelines in mind:
 * + Adding more than 50 tags to a queue isn't recommended.
 * + Tags don't have any semantic meaning. Amazon SQS interprets tags as character strings.
 * + Tags are case-sensitive.
 * + A new tag with a key identical to that of an existing tag overwrites the existing tag.
 *
 * For a full list of tag restrictions, see [Quotas related to queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-limits.html#limits-queues) in the *Amazon SQS Developer Guide*.
 *
 * Cross-account permissions don't apply to this action. For more information, see [Grant cross-account permissions to a role and a username](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name) in the *Amazon SQS Developer Guide*.
 */
public suspend inline fun SqsClient.tagQueue(crossinline block: TagQueueRequest.Builder.() -> Unit): TagQueueResponse = tagQueue(TagQueueRequest.Builder().apply(block).build())

/**
 * Remove cost allocation tags from the specified Amazon SQS queue. For an overview, see [Tagging Your Amazon SQS Queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html) in the *Amazon SQS Developer Guide*.
 *
 * Cross-account permissions don't apply to this action. For more information, see [Grant cross-account permissions to a role and a username](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name) in the *Amazon SQS Developer Guide*.
 */
public suspend inline fun SqsClient.untagQueue(crossinline block: UntagQueueRequest.Builder.() -> Unit): UntagQueueResponse = untagQueue(UntagQueueRequest.Builder().apply(block).build())
