// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.serde

import aws.sdk.kotlin.services.sqs.model.BatchResultErrorEntry
import aws.sdk.kotlin.services.sqs.model.SendMessageBatchResponse
import aws.sdk.kotlin.services.sqs.model.SendMessageBatchResultEntry
import aws.sdk.kotlin.services.sqs.model.SqsException
import aws.smithy.kotlin.runtime.awsprotocol.AwsQueryCompatibleErrorDetails
import aws.smithy.kotlin.runtime.awsprotocol.X_AMZN_QUERY_ERROR_HEADER
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.setAwsQueryCompatibleErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class SendMessageBatchOperationDeserializer: HttpDeserialize<SendMessageBatchResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): SendMessageBatchResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSendMessageBatchError(context, call)
        }
        val builder = SendMessageBatchResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSendMessageBatchOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwSendMessageBatchError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SqsException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    var queryErrorDetails: AwsQueryCompatibleErrorDetails? = null
    call.response.headers[X_AMZN_QUERY_ERROR_HEADER]?.let {
        queryErrorDetails = try {
            AwsQueryCompatibleErrorDetails.parse(it)
        } catch (ex: Exception) {
            throw SqsException("Failed to parse awsQuery-compatible error", ex).also {
                setAseErrorMetadata(it, wrappedResponse, errorDetails)
            }
        }
    }

    val ex = when(errorDetails.code) {
        "BatchRequestTooLong" -> BatchRequestTooLongDeserializer().deserialize(context, wrappedCall)
        "KmsAccessDenied" -> KmsAccessDeniedDeserializer().deserialize(context, wrappedCall)
        "EmptyBatchRequest" -> EmptyBatchRequestDeserializer().deserialize(context, wrappedCall)
        "KmsNotFound" -> KmsNotFoundDeserializer().deserialize(context, wrappedCall)
        "RequestThrottled" -> RequestThrottledDeserializer().deserialize(context, wrappedCall)
        "InvalidBatchEntryId" -> InvalidBatchEntryIdDeserializer().deserialize(context, wrappedCall)
        "QueueDoesNotExist" -> QueueDoesNotExistDeserializer().deserialize(context, wrappedCall)
        "KmsInvalidState" -> KmsInvalidStateDeserializer().deserialize(context, wrappedCall)
        "InvalidSecurity" -> InvalidSecurityDeserializer().deserialize(context, wrappedCall)
        "BatchEntryIdsNotDistinct" -> BatchEntryIdsNotDistinctDeserializer().deserialize(context, wrappedCall)
        "InvalidAddress" -> InvalidAddressDeserializer().deserialize(context, wrappedCall)
        "KmsInvalidKeyUsage" -> KmsInvalidKeyUsageDeserializer().deserialize(context, wrappedCall)
        "KmsThrottled" -> KmsThrottledDeserializer().deserialize(context, wrappedCall)
        "UnsupportedOperation" -> UnsupportedOperationDeserializer().deserialize(context, wrappedCall)
        "TooManyEntriesInBatchRequest" -> TooManyEntriesInBatchRequestDeserializer().deserialize(context, wrappedCall)
        "KmsDisabled" -> KmsDisabledDeserializer().deserialize(context, wrappedCall)
        "KmsOptInRequired" -> KmsOptInRequiredDeserializer().deserialize(context, wrappedCall)
        else -> SqsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    queryErrorDetails?.let { setAwsQueryCompatibleErrorMetadata(ex, it) }
    throw ex
}

private fun deserializeSendMessageBatchOperationBody(builder: SendMessageBatchResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Failed"))
    val SUCCESSFUL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Successful"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILED_DESCRIPTOR)
        field(SUCCESSFUL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILED_DESCRIPTOR.index -> builder.failed =
                    deserializer.deserializeList(FAILED_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchResultErrorEntry>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchResultErrorEntryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUCCESSFUL_DESCRIPTOR.index -> builder.successful =
                    deserializer.deserializeList(SUCCESSFUL_DESCRIPTOR) {
                        val col0 = mutableListOf<SendMessageBatchResultEntry>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSendMessageBatchResultEntryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
