// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.serde

import aws.sdk.kotlin.services.sqs.model.QueueAttributeName
import aws.sdk.kotlin.services.sqs.model.ReceiveMessageRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ReceiveMessageOperationSerializer: HttpSerialize<ReceiveMessageRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ReceiveMessageRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeReceiveMessageOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.0")
        }
        return builder
    }
}

private fun serializeReceiveMessageOperationBody(context: ExecutionContext, input: ReceiveMessageRequest): ByteArray {
    val serializer = JsonSerializer()
    val ATTRIBUTENAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AttributeNames"))
    val MAXNUMBEROFMESSAGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxNumberOfMessages"))
    val MESSAGEATTRIBUTENAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("MessageAttributeNames"))
    val QUEUEURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QueueUrl"))
    val RECEIVEREQUESTATTEMPTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ReceiveRequestAttemptId"))
    val VISIBILITYTIMEOUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("VisibilityTimeout"))
    val WAITTIMESECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("WaitTimeSeconds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTENAMES_DESCRIPTOR)
        field(MAXNUMBEROFMESSAGES_DESCRIPTOR)
        field(MESSAGEATTRIBUTENAMES_DESCRIPTOR)
        field(QUEUEURL_DESCRIPTOR)
        field(RECEIVEREQUESTATTEMPTID_DESCRIPTOR)
        field(VISIBILITYTIMEOUT_DESCRIPTOR)
        field(WAITTIMESECONDS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.attributeNames != null) {
            listField(ATTRIBUTENAMES_DESCRIPTOR) {
                for (el0 in input.attributeNames) {
                    serializeString(el0.value)
                }
            }
        }
        input.maxNumberOfMessages?.let { field(MAXNUMBEROFMESSAGES_DESCRIPTOR, it) }
        if (input.messageAttributeNames != null) {
            listField(MESSAGEATTRIBUTENAMES_DESCRIPTOR) {
                for (el0 in input.messageAttributeNames) {
                    serializeString(el0)
                }
            }
        }
        input.queueUrl?.let { field(QUEUEURL_DESCRIPTOR, it) }
        input.receiveRequestAttemptId?.let { field(RECEIVEREQUESTATTEMPTID_DESCRIPTOR, it) }
        input.visibilityTimeout?.let { field(VISIBILITYTIMEOUT_DESCRIPTOR, it) }
        input.waitTimeSeconds?.let { field(WAITTIMESECONDS_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
