// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.serde

import aws.sdk.kotlin.services.sqs.model.DeleteQueueResponse
import aws.sdk.kotlin.services.sqs.model.SqsException
import aws.smithy.kotlin.runtime.awsprotocol.AwsQueryCompatibleErrorDetails
import aws.smithy.kotlin.runtime.awsprotocol.X_AMZN_QUERY_ERROR_HEADER
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.setAwsQueryCompatibleErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteQueueOperationDeserializer: HttpDeserialize<DeleteQueueResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteQueueResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteQueueError(context, call)
        }
        val builder = DeleteQueueResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteQueueError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SqsException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    var queryErrorDetails: AwsQueryCompatibleErrorDetails? = null
    call.response.headers[X_AMZN_QUERY_ERROR_HEADER]?.let {
        queryErrorDetails = try {
            AwsQueryCompatibleErrorDetails.parse(it)
        } catch (ex: Exception) {
            throw SqsException("Failed to parse awsQuery-compatible error", ex).also {
                setAseErrorMetadata(it, wrappedResponse, errorDetails)
            }
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidAddress" -> InvalidAddressDeserializer().deserialize(context, wrappedCall)
        "UnsupportedOperation" -> UnsupportedOperationDeserializer().deserialize(context, wrappedCall)
        "RequestThrottled" -> RequestThrottledDeserializer().deserialize(context, wrappedCall)
        "QueueDoesNotExist" -> QueueDoesNotExistDeserializer().deserialize(context, wrappedCall)
        "InvalidSecurity" -> InvalidSecurityDeserializer().deserialize(context, wrappedCall)
        else -> SqsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    queryErrorDetails?.let { setAwsQueryCompatibleErrorMetadata(ex, it) }
    throw ex
}
