// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.paginators

import aws.sdk.kotlin.services.sqs.SqsClient
import aws.sdk.kotlin.services.sqs.model.ListDeadLetterSourceQueuesRequest
import aws.sdk.kotlin.services.sqs.model.ListDeadLetterSourceQueuesResponse
import aws.sdk.kotlin.services.sqs.model.ListQueuesRequest
import aws.sdk.kotlin.services.sqs.model.ListQueuesResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListDeadLetterSourceQueuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDeadLetterSourceQueuesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeadLetterSourceQueuesResponse]
 */
public fun SqsClient.listDeadLetterSourceQueuesPaginated(initialRequest: ListDeadLetterSourceQueuesRequest): Flow<ListDeadLetterSourceQueuesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDeadLetterSourceQueuesPaginated.listDeadLetterSourceQueues(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDeadLetterSourceQueuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDeadLetterSourceQueuesResponse]
 */
public fun SqsClient.listDeadLetterSourceQueuesPaginated(block: ListDeadLetterSourceQueuesRequest.Builder.() -> Unit): Flow<ListDeadLetterSourceQueuesResponse> =
    listDeadLetterSourceQueuesPaginated(ListDeadLetterSourceQueuesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDeadLetterSourceQueuesPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listDeadLetterSourceQueuesResponseString")
public fun Flow<ListDeadLetterSourceQueuesResponse>.queueUrls(): Flow<String> =
    transform() { response ->
        response.queueUrls?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListQueuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListQueuesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQueuesResponse]
 */
public fun SqsClient.listQueuesPaginated(initialRequest: ListQueuesRequest = ListQueuesRequest { }): Flow<ListQueuesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listQueuesPaginated.listQueues(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListQueuesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListQueuesResponse]
 */
public fun SqsClient.listQueuesPaginated(block: ListQueuesRequest.Builder.() -> Unit): Flow<ListQueuesResponse> =
    listQueuesPaginated(ListQueuesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listQueuesPaginated]
 * to access the nested member [String]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [String]
 */
@JvmName("listQueuesResponseString")
public fun Flow<ListQueuesResponse>.queueUrls(): Flow<String> =
    transform() { response ->
        response.queueUrls?.forEach {
            emit(it)
        }
    }
