// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.model



/**
 *
 */
public class SendMessageRequest private constructor(builder: Builder) {
    /**
     * The length of time, in seconds, for which to delay a specific message. Valid values: 0 to 900. Maximum: 15 minutes. Messages with a positive `DelaySeconds` value become available for processing after the delay period is finished. If you don't specify a value, the default value for the queue applies.
     *
     * When you set `FifoQueue`, you can't set `DelaySeconds` per message. You can set this parameter only on a queue level.
     */
    public val delaySeconds: kotlin.Int? = builder.delaySeconds
    /**
     * Each message attribute consists of a `Name`, `Type`, and `Value`. For more information, see [Amazon SQS message attributes](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes) in the *Amazon SQS Developer Guide*.
     */
    public val messageAttributes: Map<String, MessageAttributeValue>? = builder.messageAttributes
    /**
     * The message to send. The minimum size is one character. The maximum size is 256 KiB.
     *
     * A message can include only XML, JSON, and unformatted text. The following Unicode characters are allowed:
     *
     * `#x9` | `#xA` | `#xD` | `#x20` to `#xD7FF` | `#xE000` to `#xFFFD` | `#x10000` to `#x10FFFF`
     *
     * Any characters not included in this list will be rejected. For more information, see the [W3C specification for characters](http://www.w3.org/TR/REC-xml/#charsets).
     */
    public val messageBody: kotlin.String? = builder.messageBody
    /**
     * This parameter applies only to FIFO (first-in-first-out) queues.
     *
     * The token used for deduplication of sent messages. If a message with a particular `MessageDeduplicationId` is sent successfully, any messages sent with the same `MessageDeduplicationId` are accepted successfully but aren't delivered during the 5-minute deduplication interval. For more information, see [ Exactly-once processing](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html) in the *Amazon SQS Developer Guide*.
     * + Every message must have a unique `MessageDeduplicationId`,
     *    + You may provide a `MessageDeduplicationId` explicitly.
     *    + If you aren't able to provide a `MessageDeduplicationId` and you enable `ContentBasedDeduplication` for your queue, Amazon SQS uses a SHA-256 hash to generate the `MessageDeduplicationId` using the body of the message (but not the attributes of the message).
     *    + If you don't provide a `MessageDeduplicationId` and the queue doesn't have `ContentBasedDeduplication` set, the action fails with an error.
     *    + If the queue has `ContentBasedDeduplication` set, your `MessageDeduplicationId` overrides the generated one.
     * + When `ContentBasedDeduplication` is in effect, messages with identical content sent within the deduplication interval are treated as duplicates and only one copy of the message is delivered.
     * + If you send one message with `ContentBasedDeduplication` enabled and then another message with a `MessageDeduplicationId` that is the same as the one generated for the first `MessageDeduplicationId`, the two messages are treated as duplicates and only one copy of the message is delivered.
     *
     * The `MessageDeduplicationId` is available to the consumer of the message (this can be useful for troubleshooting delivery issues).
     *
     * If a message is sent successfully but the acknowledgement is lost and the message is resent with the same `MessageDeduplicationId` after the deduplication interval, Amazon SQS can't detect duplicate messages.
     *
     * Amazon SQS continues to keep track of the message deduplication ID even after the message is received and deleted.
     *
     * The maximum length of `MessageDeduplicationId` is 128 characters. `MessageDeduplicationId` can contain alphanumeric characters (`a-z`, `A-Z`, `0-9`) and punctuation (`!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~`).
     *
     * For best practices of using `MessageDeduplicationId`, see [Using the MessageDeduplicationId Property](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html) in the *Amazon SQS Developer Guide*.
     */
    public val messageDeduplicationId: kotlin.String? = builder.messageDeduplicationId
    /**
     * This parameter applies only to FIFO (first-in-first-out) queues.
     *
     * The tag that specifies that a message belongs to a specific message group. Messages that belong to the same message group are processed in a FIFO manner (however, messages in different message groups might be processed out of order). To interleave multiple ordered streams within a single queue, use `MessageGroupId` values (for example, session data for multiple users). In this scenario, multiple consumers can process the queue, but the session data of each user is processed in a FIFO fashion.
     * + You must associate a non-empty `MessageGroupId` with a message. If you don't provide a `MessageGroupId`, the action fails.
     * + `ReceiveMessage` might return messages with multiple `MessageGroupId` values. For each `MessageGroupId`, the messages are sorted by time sent. The caller can't specify a `MessageGroupId`.
     *
     * The length of `MessageGroupId` is 128 characters. Valid values: alphanumeric characters and punctuation `(!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~)`.
     *
     * For best practices of using `MessageGroupId`, see [Using the MessageGroupId Property](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagegroupid-property.html) in the *Amazon SQS Developer Guide*.
     *
     * `MessageGroupId` is required for FIFO queues. You can't use it for Standard queues.
     */
    public val messageGroupId: kotlin.String? = builder.messageGroupId
    /**
     * The message system attribute to send. Each message system attribute consists of a `Name`, `Type`, and `Value`.
     *
     * + Currently, the only supported message system attribute is `AWSTraceHeader`. Its type must be `String` and its value must be a correctly formatted X-Ray trace header string.
     * + The size of a message system attribute doesn't count towards the total size of a message.
     */
    public val messageSystemAttributes: Map<String, MessageSystemAttributeValue>? = builder.messageSystemAttributes
    /**
     * The URL of the Amazon SQS queue to which a message is sent.
     *
     * Queue URLs and names are case-sensitive.
     */
    public val queueUrl: kotlin.String? = builder.queueUrl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sqs.model.SendMessageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SendMessageRequest(")
        append("delaySeconds=$delaySeconds,")
        append("messageAttributes=$messageAttributes,")
        append("messageBody=$messageBody,")
        append("messageDeduplicationId=$messageDeduplicationId,")
        append("messageGroupId=$messageGroupId,")
        append("messageSystemAttributes=$messageSystemAttributes,")
        append("queueUrl=$queueUrl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = delaySeconds ?: 0
        result = 31 * result + (messageAttributes?.hashCode() ?: 0)
        result = 31 * result + (messageBody?.hashCode() ?: 0)
        result = 31 * result + (messageDeduplicationId?.hashCode() ?: 0)
        result = 31 * result + (messageGroupId?.hashCode() ?: 0)
        result = 31 * result + (messageSystemAttributes?.hashCode() ?: 0)
        result = 31 * result + (queueUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SendMessageRequest

        if (delaySeconds != other.delaySeconds) return false
        if (messageAttributes != other.messageAttributes) return false
        if (messageBody != other.messageBody) return false
        if (messageDeduplicationId != other.messageDeduplicationId) return false
        if (messageGroupId != other.messageGroupId) return false
        if (messageSystemAttributes != other.messageSystemAttributes) return false
        if (queueUrl != other.queueUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sqs.model.SendMessageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The length of time, in seconds, for which to delay a specific message. Valid values: 0 to 900. Maximum: 15 minutes. Messages with a positive `DelaySeconds` value become available for processing after the delay period is finished. If you don't specify a value, the default value for the queue applies.
         *
         * When you set `FifoQueue`, you can't set `DelaySeconds` per message. You can set this parameter only on a queue level.
         */
        public var delaySeconds: kotlin.Int? = null
        /**
         * Each message attribute consists of a `Name`, `Type`, and `Value`. For more information, see [Amazon SQS message attributes](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes) in the *Amazon SQS Developer Guide*.
         */
        public var messageAttributes: Map<String, MessageAttributeValue>? = null
        /**
         * The message to send. The minimum size is one character. The maximum size is 256 KiB.
         *
         * A message can include only XML, JSON, and unformatted text. The following Unicode characters are allowed:
         *
         * `#x9` | `#xA` | `#xD` | `#x20` to `#xD7FF` | `#xE000` to `#xFFFD` | `#x10000` to `#x10FFFF`
         *
         * Any characters not included in this list will be rejected. For more information, see the [W3C specification for characters](http://www.w3.org/TR/REC-xml/#charsets).
         */
        public var messageBody: kotlin.String? = null
        /**
         * This parameter applies only to FIFO (first-in-first-out) queues.
         *
         * The token used for deduplication of sent messages. If a message with a particular `MessageDeduplicationId` is sent successfully, any messages sent with the same `MessageDeduplicationId` are accepted successfully but aren't delivered during the 5-minute deduplication interval. For more information, see [ Exactly-once processing](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-exactly-once-processing.html) in the *Amazon SQS Developer Guide*.
         * + Every message must have a unique `MessageDeduplicationId`,
         *    + You may provide a `MessageDeduplicationId` explicitly.
         *    + If you aren't able to provide a `MessageDeduplicationId` and you enable `ContentBasedDeduplication` for your queue, Amazon SQS uses a SHA-256 hash to generate the `MessageDeduplicationId` using the body of the message (but not the attributes of the message).
         *    + If you don't provide a `MessageDeduplicationId` and the queue doesn't have `ContentBasedDeduplication` set, the action fails with an error.
         *    + If the queue has `ContentBasedDeduplication` set, your `MessageDeduplicationId` overrides the generated one.
         * + When `ContentBasedDeduplication` is in effect, messages with identical content sent within the deduplication interval are treated as duplicates and only one copy of the message is delivered.
         * + If you send one message with `ContentBasedDeduplication` enabled and then another message with a `MessageDeduplicationId` that is the same as the one generated for the first `MessageDeduplicationId`, the two messages are treated as duplicates and only one copy of the message is delivered.
         *
         * The `MessageDeduplicationId` is available to the consumer of the message (this can be useful for troubleshooting delivery issues).
         *
         * If a message is sent successfully but the acknowledgement is lost and the message is resent with the same `MessageDeduplicationId` after the deduplication interval, Amazon SQS can't detect duplicate messages.
         *
         * Amazon SQS continues to keep track of the message deduplication ID even after the message is received and deleted.
         *
         * The maximum length of `MessageDeduplicationId` is 128 characters. `MessageDeduplicationId` can contain alphanumeric characters (`a-z`, `A-Z`, `0-9`) and punctuation (`!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~`).
         *
         * For best practices of using `MessageDeduplicationId`, see [Using the MessageDeduplicationId Property](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagededuplicationid-property.html) in the *Amazon SQS Developer Guide*.
         */
        public var messageDeduplicationId: kotlin.String? = null
        /**
         * This parameter applies only to FIFO (first-in-first-out) queues.
         *
         * The tag that specifies that a message belongs to a specific message group. Messages that belong to the same message group are processed in a FIFO manner (however, messages in different message groups might be processed out of order). To interleave multiple ordered streams within a single queue, use `MessageGroupId` values (for example, session data for multiple users). In this scenario, multiple consumers can process the queue, but the session data of each user is processed in a FIFO fashion.
         * + You must associate a non-empty `MessageGroupId` with a message. If you don't provide a `MessageGroupId`, the action fails.
         * + `ReceiveMessage` might return messages with multiple `MessageGroupId` values. For each `MessageGroupId`, the messages are sorted by time sent. The caller can't specify a `MessageGroupId`.
         *
         * The length of `MessageGroupId` is 128 characters. Valid values: alphanumeric characters and punctuation `(!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~)`.
         *
         * For best practices of using `MessageGroupId`, see [Using the MessageGroupId Property](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/using-messagegroupid-property.html) in the *Amazon SQS Developer Guide*.
         *
         * `MessageGroupId` is required for FIFO queues. You can't use it for Standard queues.
         */
        public var messageGroupId: kotlin.String? = null
        /**
         * The message system attribute to send. Each message system attribute consists of a `Name`, `Type`, and `Value`.
         *
         * + Currently, the only supported message system attribute is `AWSTraceHeader`. Its type must be `String` and its value must be a correctly formatted X-Ray trace header string.
         * + The size of a message system attribute doesn't count towards the total size of a message.
         */
        public var messageSystemAttributes: Map<String, MessageSystemAttributeValue>? = null
        /**
         * The URL of the Amazon SQS queue to which a message is sent.
         *
         * Queue URLs and names are case-sensitive.
         */
        public var queueUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sqs.model.SendMessageRequest) : this() {
            this.delaySeconds = x.delaySeconds
            this.messageAttributes = x.messageAttributes
            this.messageBody = x.messageBody
            this.messageDeduplicationId = x.messageDeduplicationId
            this.messageGroupId = x.messageGroupId
            this.messageSystemAttributes = x.messageSystemAttributes
            this.queueUrl = x.queueUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sqs.model.SendMessageRequest = SendMessageRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
