// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sqs.model



/**
 * Contains the details of a message movement task.
 */
public class ListMessageMoveTasksResultEntry private constructor(builder: Builder) {
    /**
     * The approximate number of messages already moved to the destination queue.
     */
    public val approximateNumberOfMessagesMoved: kotlin.Long = builder.approximateNumberOfMessagesMoved
    /**
     * The number of messages to be moved from the source queue. This number is obtained at the time of starting the message movement task.
     */
    public val approximateNumberOfMessagesToMove: kotlin.Long? = builder.approximateNumberOfMessagesToMove
    /**
     * The ARN of the destination queue if it has been specified in the `StartMessageMoveTask` request. If a `DestinationArn` has not been specified in the `StartMessageMoveTask` request, this field value will be NULL.
     */
    public val destinationArn: kotlin.String? = builder.destinationArn
    /**
     * The task failure reason (only included if the task status is FAILED).
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The number of messages to be moved per second (the message movement rate), if it has been specified in the `StartMessageMoveTask` request. If a `MaxNumberOfMessagesPerSecond` has not been specified in the `StartMessageMoveTask` request, this field value will be NULL.
     */
    public val maxNumberOfMessagesPerSecond: kotlin.Int? = builder.maxNumberOfMessagesPerSecond
    /**
     * The ARN of the queue that contains the messages to be moved to another queue.
     */
    public val sourceArn: kotlin.String? = builder.sourceArn
    /**
     * The timestamp of starting the message movement task.
     */
    public val startedTimestamp: kotlin.Long = builder.startedTimestamp
    /**
     * The status of the message movement task. Possible values are: RUNNING, COMPLETED, CANCELLING, CANCELLED, and FAILED.
     */
    public val status: kotlin.String? = builder.status
    /**
     * An identifier associated with a message movement task. When this field is returned in the response of the `ListMessageMoveTasks` action, it is only populated for tasks that are in RUNNING status.
     */
    public val taskHandle: kotlin.String? = builder.taskHandle

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sqs.model.ListMessageMoveTasksResultEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListMessageMoveTasksResultEntry(")
        append("approximateNumberOfMessagesMoved=$approximateNumberOfMessagesMoved,")
        append("approximateNumberOfMessagesToMove=$approximateNumberOfMessagesToMove,")
        append("destinationArn=$destinationArn,")
        append("failureReason=$failureReason,")
        append("maxNumberOfMessagesPerSecond=$maxNumberOfMessagesPerSecond,")
        append("sourceArn=$sourceArn,")
        append("startedTimestamp=$startedTimestamp,")
        append("status=$status,")
        append("taskHandle=$taskHandle")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = approximateNumberOfMessagesMoved.hashCode()
        result = 31 * result + (approximateNumberOfMessagesToMove?.hashCode() ?: 0)
        result = 31 * result + (destinationArn?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (maxNumberOfMessagesPerSecond ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (startedTimestamp.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (taskHandle?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListMessageMoveTasksResultEntry

        if (approximateNumberOfMessagesMoved != other.approximateNumberOfMessagesMoved) return false
        if (approximateNumberOfMessagesToMove != other.approximateNumberOfMessagesToMove) return false
        if (destinationArn != other.destinationArn) return false
        if (failureReason != other.failureReason) return false
        if (maxNumberOfMessagesPerSecond != other.maxNumberOfMessagesPerSecond) return false
        if (sourceArn != other.sourceArn) return false
        if (startedTimestamp != other.startedTimestamp) return false
        if (status != other.status) return false
        if (taskHandle != other.taskHandle) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sqs.model.ListMessageMoveTasksResultEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The approximate number of messages already moved to the destination queue.
         */
        public var approximateNumberOfMessagesMoved: kotlin.Long = 0L
        /**
         * The number of messages to be moved from the source queue. This number is obtained at the time of starting the message movement task.
         */
        public var approximateNumberOfMessagesToMove: kotlin.Long? = null
        /**
         * The ARN of the destination queue if it has been specified in the `StartMessageMoveTask` request. If a `DestinationArn` has not been specified in the `StartMessageMoveTask` request, this field value will be NULL.
         */
        public var destinationArn: kotlin.String? = null
        /**
         * The task failure reason (only included if the task status is FAILED).
         */
        public var failureReason: kotlin.String? = null
        /**
         * The number of messages to be moved per second (the message movement rate), if it has been specified in the `StartMessageMoveTask` request. If a `MaxNumberOfMessagesPerSecond` has not been specified in the `StartMessageMoveTask` request, this field value will be NULL.
         */
        public var maxNumberOfMessagesPerSecond: kotlin.Int? = null
        /**
         * The ARN of the queue that contains the messages to be moved to another queue.
         */
        public var sourceArn: kotlin.String? = null
        /**
         * The timestamp of starting the message movement task.
         */
        public var startedTimestamp: kotlin.Long = 0L
        /**
         * The status of the message movement task. Possible values are: RUNNING, COMPLETED, CANCELLING, CANCELLED, and FAILED.
         */
        public var status: kotlin.String? = null
        /**
         * An identifier associated with a message movement task. When this field is returned in the response of the `ListMessageMoveTasks` action, it is only populated for tasks that are in RUNNING status.
         */
        public var taskHandle: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sqs.model.ListMessageMoveTasksResultEntry) : this() {
            this.approximateNumberOfMessagesMoved = x.approximateNumberOfMessagesMoved
            this.approximateNumberOfMessagesToMove = x.approximateNumberOfMessagesToMove
            this.destinationArn = x.destinationArn
            this.failureReason = x.failureReason
            this.maxNumberOfMessagesPerSecond = x.maxNumberOfMessagesPerSecond
            this.sourceArn = x.sourceArn
            this.startedTimestamp = x.startedTimestamp
            this.status = x.status
            this.taskHandle = x.taskHandle
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sqs.model.ListMessageMoveTasksResultEntry = ListMessageMoveTasksResultEntry(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
